/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_jboss.boundary;

import br.com.fiorilli.instalador.business.instalar_jboss.control.InstallJBossLinux;
import br.com.fiorilli.instalador.business.instalar_jboss.control.SetupJbossDomainMode;
import br.com.fiorilli.instalador.cli.boundary.JBossCli;
import br.com.fiorilli.instalador.cli.control.CliException;
import br.com.fiorilli.instalador.file_system.UnzipUtility;
import br.com.fiorilli.instalador.http.FileDownloader;
import br.com.fiorilli.instalador.params.JBossMode;
import br.com.fiorilli.instalador.params.Params;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgress;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class InstallJBossService {
    private static final String JDK_LINUX32_FILENAME = "jdk-linux-32.zip";
    private static final String JDK_LINUX64_FILENAME = "jdk-linux-x64.zip";
    private static final String JDK_WIN32_FILENAME = "jdk-win-32.zip";
    private static final String JDK_WIN64_FILENAME = "jdk-win-64.zip";
    private static final String JBOSS_FILENAME = "jboss.zip";
    private static final String JBOSS_DIR = "jboss-as-7.1.1.Final";
    private static final String JBOSS_MODULES_FILENAME = "jboss-modules.zip";
    private static final String JBOSS_STATE_STARTING = "starting";
    private final Logger logger = Logger.getLogger(InstallJBossService.class);
    private final Params params;
    private final InstaladorProgress progress;

    public InstallJBossService(Params params, InstaladorProgress progress) {
        this.params = params;
        this.progress = progress;
    }

    public void install() throws IOException {
        String filename = JBOSS_FILENAME;
        this.logger.info("Baixando JBoss");
        this.download(filename, this.progress);
        this.logger.info("Download File: " + filename);
        File installationPathFile = new File(this.params.getJbossDir().concat(File.separator).concat(JBOSS_DIR));
        this.logger.info("Verificando diretorio antes de extrair: " + installationPathFile.toPath().toString());
        if (!installationPathFile.exists()) {
            this.extractZip(new File(filename), this.params.getJbossDir(), this.progress);
        }
        filename = this.getJDKFilenameToDownload();
        this.logger.info("Baixando Java");
        this.download(filename, this.progress);
        this.logger.info("Download File: " + filename);
        this.extractZip(new File(filename), this.getJDKInstallationPath(), this.progress);
        if (this.params.getJbossMode().equals((Object)JBossMode.DOMAIN)) {
            new SetupJbossDomainMode(this.params, JBOSS_DIR).setup();
        }
        this.checkArgumentXssJboss();
        if (SystemUtils.IS_OS_WINDOWS) {
            this.installWindows();
            this.logger.info("JBoss Instalado com Sucesso");
        } else {
            this.installLinux();
            this.logger.info("Instala\u00e7\u00e3o Conclu\u00edda");
            this.logger.warn("Realize as opera\u00e7\u00f5es necessarias para a inicializa\u00e7\u00e3o autom\u00e1tica do JBoss no Sistema Operacional");
            this.helpUnixUser();
        }
    }

    private String getJDKInstallationPath() {
        return this.params.getJbossDir().concat(File.separator).concat(JBOSS_DIR).concat(File.separator).concat("jdk");
    }

    private void installLinux() throws IOException {
        if (!Params.getDefaultJBossDir().equals(this.params.getJbossDir())) {
            InstallJBossLinux linuxInstall = new InstallJBossLinux();
            this.logger.info("Atualizando Script de Inicializa\u00e7\u00e3o com Novo Diret\u00f3rio");
            linuxInstall.updateLinuxServiceScript(new File(this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-standalone.sh"), this.params.getJbossDir() + "/" + JBOSS_DIR);
            this.logger.info("Atualizando Script do JBoss-cli com Novo Diret\u00f3rio");
            linuxInstall.updateLinuxCliScript(new File(this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/jboss-cli.sh"), this.params.getJbossDir() + "/" + JBOSS_DIR + "/jdk/bin/java");
        }
    }

    public void helpUnixUser() {
        this.logger.info("\n<<< PR\u00d3XIMOS PASSOS >>>:\n");
        this.logger.info("#adduser jboss\n#chown -fR jboss:jboss " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/\n" + "#su jboss\n" + "#chmod -R +x " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin\n" + "#chmod -R +x " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/jdk\n" + "\n" + "Inicializacao Automatica\n" + "Debian-like distribution (ex:Ubuntu)\n" + "\t#cp " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-7-standalone  /etc/init.d/\n" + "\t#update-rc.d jboss-as defaults\n" + "\n" + "RHEL-like distribution (ex:CentOS)\n" + "\t#ln -s -T " + this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/init.d/jboss-as-standalone.sh /etc/init.d/jboss-as\n" + "\t#chkconfig --add jboss-as --level 0356\n" + "\n" + "Se necessario execute o comando abaixo para listar as portas ocupadas.\n" + "#sudo netstat -tulpn\n" + "\n" + "Verifique como exibir estes itens novamente no help desta aplica\u00e7\u00e3o");
    }

    private void installWindows() {
        try {
            this.logger.info("Registrando Servico no Windows");
            String binpath = this.params.getJbossDir() + File.separator + JBOSS_DIR + File.separator + "bin";
            String cmd = binpath + File.separator + "service.bat install";
            File dir = new File(binpath);
            Runtime.getRuntime().exec(cmd, null, dir);
            Thread.sleep(10000L);
            this.logger.info("Iniciando JBoss");
            this.startServiceJbossWindows();
        }
        catch (CliException | IOException | InterruptedException e) {
            this.logger.error(e);
            throw new RuntimeException(e);
        }
    }

    public void testJBossInstallation() throws CliException, InterruptedException {
        try (JBossCli cli = new JBossCli(this.params.getJbossIp(), this.params.getJbossPort());){
            String serverState = cli.getServerState();
            while (serverState.equals(JBOSS_STATE_STARTING)) {
                this.logger.info("JBoss " + serverState);
                Thread.sleep(5000L);
                serverState = cli.getServerState();
            }
            this.logger.info("JBoss " + serverState);
        }
    }

    private void extractZip(File theFile, String installationPath, InstaladorProgress progress) {
        try {
            this.logger.info("Extraindo em: " + installationPath);
            UnzipUtility u = new UnzipUtility();
            u.unzip(String.valueOf(theFile), installationPath);
            this.logger.info("\nArquivos Extraidos com Sucesso");
        }
        catch (IOException e) {
            this.logger.error(e);
            throw new RuntimeException(e);
        }
    }

    private void download(String filename, InstaladorProgress progress) {
        try {
            FileDownloader.downloadFile(new URL("http://ftp.dcfiorilli.com.br/web/SIP/instalador/" + filename), filename, progress);
            this.logger.info("\nArquivo baixado com sucesso");
        }
        catch (Exception e) {
            this.logger.error("N\u00e3o foi poss\u00edvel baixar o Arquivo");
            throw new RuntimeException(e);
        }
    }

    private String getJDKFilenameToDownload() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (this.isWin64()) {
                return JDK_WIN64_FILENAME;
            }
            return JDK_WIN32_FILENAME;
        }
        if (SystemUtils.OS_ARCH != null && SystemUtils.OS_ARCH.indexOf("64") > -1) {
            return JDK_LINUX64_FILENAME;
        }
        return JDK_LINUX32_FILENAME;
    }

    private boolean isWin64() {
        if (System.getProperty("os.name").contains("Windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").indexOf("64") > -1;
    }

    public static String getDirName() {
        return JBOSS_DIR;
    }

    private String getJbossInstallationPath() {
        return this.params.getJbossDir().concat(File.separator).concat(JBOSS_DIR).concat(File.separator);
    }

    public boolean checkArgumentXssJboss() {
        try {
            String fileName = SystemUtils.IS_OS_WINDOWS ? "standalone.conf.bat" : "standalone.conf";
            File file = new File(this.params.getJbossDir() + "/" + JBOSS_DIR + "/bin/" + fileName);
            if (file.exists()) {
                this.logger.info("Verificando as configuracoes do Jboss");
                Scanner sc = new Scanner(file);
                StringBuffer buffer = new StringBuffer();
                String lineToInsert = "";
                String idComment = file.getName().endsWith(".bat") ? "rem" : "#";
                Pattern pattern = Pattern.compile("-Xss\\d*k");
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    if (!line.startsWith(idComment)) {
                        Matcher matcher = pattern.matcher(line);
                        if (matcher.find()) {
                            String lineToComment = String.format("%s %s - %s", idComment, line, "Commented by InstaladorJava in " + new SimpleDateFormat("dd/MM/yyyy").format(new Date()));
                            buffer.append(lineToComment + System.lineSeparator());
                            lineToInsert = matcher.replaceAll("-Xss1m");
                            buffer.append(lineToInsert + System.lineSeparator());
                            continue;
                        }
                        buffer.append(line + System.lineSeparator());
                        continue;
                    }
                    buffer.append(line + System.lineSeparator());
                }
                sc.close();
                if (!lineToInsert.isEmpty()) {
                    FileWriter writer = new FileWriter(file);
                    writer.write(buffer.toString());
                    writer.flush();
                    this.logger.info("Alterando arquivo " + file.getName());
                    return true;
                }
                this.logger.info("Configuracoes verificadas");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void updateModules() {
        String filename = JBOSS_MODULES_FILENAME;
        this.logger.info("Baixando JBoss Modules");
        this.download(filename, this.progress);
        this.logger.info("Download File: " + filename);
        this.extractZip(new File(filename), this.getJbossInstallationPath(), this.progress);
    }

    public void restartService() {
        try {
            this.logger.info("Reiniciando o JBoss");
            if (SystemUtils.IS_OS_WINDOWS) {
                this.stopServiceJbossWindows();
                this.startServiceJbossWindows();
            } else {
                this.restartServiceJbossLinux();
            }
        }
        catch (Exception e) {
            this.logger.info("Erro ao reiniciar o JBoss");
            e.printStackTrace();
        }
    }

    private void restartServiceJbossLinux() throws IOException, InterruptedException, CliException {
        String command = "/etc/init.d/jboss-as restart";
        this.executeCommand(command);
        Thread.sleep(10000L);
        if (this.params.getJbossMode().equals((Object)JBossMode.STANDALONE)) {
            this.logger.info("Testando JBoss");
            this.testJBossInstallation();
            this.logger.info("JBoss Testado");
        }
    }

    public void restartJboss() throws CliException, InterruptedException {
        try (JBossCli cli = new JBossCli(this.params.getJbossIp(), this.params.getJbossPort());){
            this.logger.info("Reiniciando o JBoss");
            cli.restart();
            Thread.sleep(10000L);
            if (this.params.getJbossMode().equals((Object)JBossMode.STANDALONE)) {
                this.logger.info("Testando JBoss");
                this.testJBossInstallation();
                this.logger.info("JBoss Testado");
            }
        }
    }

    private void startServiceJbossWindows() throws IOException, CliException, InterruptedException {
        String command = "net start JBAS711SVC";
        this.executeCommand(command);
        Thread.sleep(10000L);
        if (this.params.getJbossMode().equals((Object)JBossMode.STANDALONE)) {
            this.logger.info("Testando JBoss");
            this.testJBossInstallation();
            this.logger.info("JBoss Testado");
        }
    }

    private void stopServiceJbossWindows() throws IOException {
        String command = "net stop JBAS711SVC";
        this.executeCommand(command);
    }

    private void executeCommand(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = r.readLine();
        while (line != null) {
            if (!line.isEmpty()) {
                this.logger.info(line);
            }
            line = r.readLine();
        }
    }

    public boolean checkJbossModulesUpdated() {
        try {
            File restEasyModuleFile = new File(this.getJbossInstallationPath() + "modules" + File.separator + "org" + File.separator + "jboss" + File.separator + "resteasy" + File.separator + "resteasy-jaxrs" + File.separator + "main" + File.separator + "module.xml");
            if (restEasyModuleFile.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(restEasyModuleFile);
                NodeList nodeList = document.getElementsByTagName("resource-root");
                for (int i = 0; i <= nodeList.getLength(); ++i) {
                    Pattern pattern;
                    Matcher matcher;
                    String path = nodeList.item(i).getAttributes().getNamedItem("path").getTextContent();
                    if (!path.contains("resteasy-jaxrs-") || !(matcher = (pattern = Pattern.compile("\\d[.]\\d[.]\\d")).matcher(path)).find()) continue;
                    return Integer.parseInt(String.join((CharSequence)"", matcher.group().split("[.]"))) > 300;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

