/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_modulo.boundary;

import br.com.fiorilli.instalador.business.instalar_modulo.entity.ModuloWebFiorilli;
import br.com.fiorilli.instalador.cli.boundary.JBossCli;
import br.com.fiorilli.instalador.cli.entity.DeployVO;
import br.com.fiorilli.instalador.params.Params;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class VerificaVersaoInstaladaModuloWebFiorilli {
    static Logger logger = Logger.getLogger(VerificaVersaoInstaladaModuloWebFiorilli.class);

    private List<DeployVO> recuperarDeployments(Params params) throws Exception {
        List<DeployVO> deployList;
        try (JBossCli jBossCli = new JBossCli(params.getJbossIp(), params.getJbossPort());){
            deployList = jBossCli.getDeployments();
        }
        return deployList;
    }

    public void verificarVersoes(Params params, List<ModuloWebFiorilli> modulos) throws Exception {
        URI uri;
        if (params.isDebug()) {
            logger.info("Listando Modulos Instalados em " + params.getJbossIp());
        }
        JBossCli jBossCli = new JBossCli(params.getJbossIp(), params.getJbossPort());
        Object object = null;
        try {
            uri = jBossCli.getWebUri();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (jBossCli != null) {
                if (object != null) {
                    try {
                        jBossCli.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    jBossCli.close();
                }
            }
        }
        List<DeployVO> deployments = this.recuperarDeployments(params);
        for (DeployVO deploy : deployments) {
            for (ModuloWebFiorilli modulo : modulos) {
                if (deploy.getContexts() == null || !deploy.getContexts().contains(modulo.getContexto())) continue;
                if (params.isDebug()) {
                    logger.info("Verificando " + modulo.getNome());
                }
                modulo.setVersaoInstalada(this.recuperarVersao(uri, modulo.getContexto()));
                if (!params.isDebug()) continue;
                logger.info(modulo.getNome() + " instalado " + modulo.getVersaoInstalada());
            }
        }
    }

    private String recuperarVersao(URI uri, String contexto) throws IOException {
        URL url = new URL("http://" + uri.getHost() + ":" + uri.getPort() + contexto + "/versao");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (conn.getResponseCode() == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            return br.readLine();
        }
        return null;
    }

    public List<DeployVO> recuperarDeploymentsEnabled(Params params) {
        ArrayList<DeployVO> deployments = new ArrayList<DeployVO>();
        try {
            for (DeployVO deploy : this.recuperarDeployments(params)) {
                if (!deploy.isEnabled()) continue;
                deployments.add(deploy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deployments;
    }
}

