/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_modulo.entity;

import br.com.fiorilli.instalador.business.instalar_modulo.control.VersaoDisponivelNaoInformadaException;
import br.com.fiorilli.instalador.business.instalar_modulo.control.VersaoInstaladaNaoInformadaException;
import br.com.fiorilli.instalador.cli.entity.ArquivoVO;
import br.com.fiorilli.util.VersionControl;

public class ModuloWebFiorilli {
    private int id;
    private final String nome;
    private final String versaoDisponivel;
    private String versaoInstalada;
    private final String contexto;
    private String pwdDownload;
    private String tipoDownload;
    private String urlDownload;
    private String usrDownload;
    private ArquivoVO arquivoBaixado;
    private final int tabdef;

    public ModuloWebFiorilli(int id, String nome, String versaoDisponivel, String versaoInstalada, String contexto, int tabdef) {
        this.id = id;
        this.nome = nome;
        this.versaoDisponivel = versaoDisponivel;
        this.versaoInstalada = versaoInstalada;
        this.contexto = contexto;
        this.tabdef = tabdef;
    }

    public boolean isUpdate() throws VersaoDisponivelNaoInformadaException, VersaoInstaladaNaoInformadaException {
        if (this.versaoDisponivel == null) {
            throw new VersaoDisponivelNaoInformadaException("Informe a Versao Disponivel");
        }
        if (this.versaoInstalada == null) {
            throw new VersaoInstaladaNaoInformadaException("Informe a Versao Instalada");
        }
        return VersionControl.isVersaoDisponivelSuperior(this.versaoDisponivel, this.versaoInstalada);
    }

    public String getNome() {
        return this.nome;
    }

    public String getContexto() {
        return this.contexto;
    }

    public String getVersaoDisponivel() {
        return this.versaoDisponivel;
    }

    public String getVersaoInstalada() {
        return this.versaoInstalada;
    }

    public void setVersaoInstalada(String versaoInstalada) {
        this.versaoInstalada = versaoInstalada;
    }

    public String getPwdDownload() {
        return this.pwdDownload;
    }

    public String getTipoDownload() {
        return this.tipoDownload;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public String getUsrDownload() {
        return this.usrDownload;
    }

    public ArquivoVO getArquivoBaixado() {
        return this.arquivoBaixado;
    }

    public void setArquivoBaixado(ArquivoVO arquivoBaixado) {
        this.arquivoBaixado = arquivoBaixado;
    }

    public int getTabdef() {
        return this.tabdef;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuloWebFiorilli other = (ModuloWebFiorilli)obj;
        return this.id == other.id;
    }

    public boolean isSnapshot() {
        return this.getNome().contains("SNAPSHOT");
    }

    public Integer getVersaoDisponivelNumber() {
        return this.getVersionNumber(this.getVersaoDisponivel());
    }

    public Integer getVersaoInstaladaNumber() {
        return this.getVersionNumber(this.getVersaoDisponivel());
    }

    private Integer getVersionNumber(String version) {
        CharSequence[] groups = version.split("[.]");
        String versao = String.join((CharSequence)"", groups);
        return Integer.parseInt(versao);
    }
}

