/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.console;

import br.com.fiorilli.instalador.business.instalar_jboss.boundary.InstallJBossService;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.InstalarModuloWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.RepositorioDeModulosWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.VerificaVersaoInstaladaModuloWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.control.VersaoInstaladaNaoInformadaException;
import br.com.fiorilli.instalador.business.instalar_modulo.entity.ModuloWebFiorilli;
import br.com.fiorilli.instalador.cli.entity.DeployVO;
import br.com.fiorilli.instalador.console.InstaladorProgressBarConsole;
import br.com.fiorilli.instalador.params.JBossMode;
import br.com.fiorilli.instalador.params.Params;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgress;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgressNullObj;
import br.com.fiorilli.instalador.version_control.VerificaVersaoInstalador;
import br.com.fiorilli.util.VersionControl;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ConsoleApp {
    private static Logger logger;
    private static final String DEBUG_CMD = "debug";
    private static final String INSTALAR_MODULO_ID_PARAM = "id";
    private static final String DOWNLOAD_PARAM = "download";
    private static final String PROXY_PWD_PARAM = "proxy-pwd";
    private static final String PROXY_USR_PARAM = "proxy-usr";
    private static final String PROXY_PORTA_PARAM = "proxy-port";
    private static final String PROXY_IP_PARAM = "proxy-ip";
    private static final String SIP_INI_PARAM = "sip-ini";
    private static final String SIA_INI_PARAM = "sia-ini";
    private static final String SCPI_INI_PARAM = "scpi-ini";
    private static final String JBOSS_PORTA_PARAM = "jboss-port";
    private static final String JBOSS_IP_PARAM = "jboss-ip";
    private static final String VIRTUAL_HOST_PARAM = "virtual-host";
    private static final String SALVAR_LOG_CMD = "salvar-log";
    private static final String ARQUIVO_LOG_PARAM = "arquivo-log";
    private static final String INSTALAR_JBOSS_DIR_PARAM = "jboss-dir";
    private static final String INSTALAR_MODULO_CMD = "instalar-modulo";
    private static final String INSTALAR_JBOSS_MODE_PARAM = "mode";
    private static final String INSTALAR_JBOSS_CMD = "instalar-jboss";
    private static final String LISTAR_MODULOS_CMD_VERSAO = "listar-modulos-versao";
    private static final String LISTAR_MODULOS_CMD_BETA = "listar-modulos-beta";
    private static final String EXEMPLOS_CMD = "ex";
    private static final String JDK_DIR_PARAM = "jdk-dir";
    private static final String ATUALIZAR_MODULO = "atualizar-modulo";
    private static final List<String> arglist;
    private static final String INSTALAR_JBOSS_HELP_PARAM = "help";
    private static final String SHOW_VERSAO = "versao";
    private static String[] modulosIds;
    private static List<ModuloWebFiorilli> modulos;
    private static InstaladorProgress progress;
    private static Params params;
    private static Scanner scanner;

    public static void main(String[] args) {
        try {
            FileUtils.forceDelete(new File(ConsoleApp.getLogFileName()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Collections.addAll(arglist, args);
        ConsoleApp.configureLogger();
        logger = Logger.getLogger(ConsoleApp.class);
        scanner = new Scanner(System.in);
        if (args.length == 0 || args[0].toLowerCase().equals("/?") || args[0].toLowerCase().equals("--help") || args[0].toLowerCase().equals(INSTALAR_JBOSS_HELP_PARAM)) {
            ConsoleApp.printHelp();
            ConsoleApp.checkInstaladorNewVersion();
            ConsoleApp.checkConfigurationJboss();
        } else if (args.length == 1 && args[0].toLowerCase().equals(EXEMPLOS_CMD)) {
            ConsoleApp.printExemplos();
            ConsoleApp.checkInstaladorNewVersion();
            ConsoleApp.checkConfigurationJboss();
        } else {
            ConsoleApp.checkInstaladorNewVersion();
            ConsoleApp.checkConfigurationJboss();
            ConsoleApp.buildParams();
            try {
                if (arglist.contains(LISTAR_MODULOS_CMD_VERSAO)) {
                    ConsoleApp.listarModulos();
                } else if (arglist.contains(LISTAR_MODULOS_CMD_BETA)) {
                    ConsoleApp.listarModulosBeta();
                } else if (arglist.contains(INSTALAR_JBOSS_CMD)) {
                    if (arglist.contains(INSTALAR_JBOSS_HELP_PARAM)) {
                        ConsoleApp.printInstalarJBossHelp();
                    } else {
                        ConsoleApp.instalarJBoss();
                    }
                } else if (arglist.contains(INSTALAR_MODULO_CMD)) {
                    ConsoleApp.instalarModulo();
                } else if (arglist.contains(ATUALIZAR_MODULO)) {
                    ConsoleApp.atualizarModulos();
                } else if (arglist.contains(SHOW_VERSAO)) {
                    ConsoleApp.printVersion();
                } else {
                    logger.error("Parametro invalido");
                }
            }
            catch (Exception e) {
                if (arglist.contains(DEBUG_CMD)) {
                    e.printStackTrace();
                } else {
                    logger.error(e);
                }
            }
            finally {
                logger.info("\n");
                scanner.close();
            }
        }
    }

    private static void checkConfigurationJboss() {
        InstallJBossService installJBossService = new InstallJBossService(ConsoleApp.getParams(false), progress);
        if (installJBossService.checkArgumentXssJboss()) {
            if (ConsoleApp.confirm("As configuracoes do servidor Jboss foram ajustadas e sera necessario reinicia-lo. Deseja reiniciar agora?", true)) {
                installJBossService.restartService();
            } else {
                logger.info("Reinicio do Jboss pendente");
            }
        }
    }

    private static void atualizarModulo(ModuloWebFiorilli modulo, InstalarModuloWebFiorilli moduloService, boolean removeOldModulos) throws Exception {
        try {
            if (modulo.isUpdate()) {
                boolean restartJboss;
                logger.info("Versao disponivel " + modulo.getVersaoDisponivel());
                logger.info("Atualizando modulo");
                boolean updateModulesJboss = moduloService.checkUpdateModulesJboss(modulo, ConsoleApp.getParams(false), progress);
                if (updateModulesJboss && !(restartJboss = ConsoleApp.confirm("Para instalar a versao sera necessario atualizar e reiniciar o Jboss. Deseja continuar?", true))) {
                    logger.info("Instalacao cancelada");
                    return;
                }
                moduloService.instalar(modulo, ConsoleApp.getParams(removeOldModulos), progress, updateModulesJboss);
            } else {
                logger.info("Nenhuma atualizacao necessaria");
            }
        }
        catch (Exception e) {
            if (!(e instanceof VersaoInstaladaNaoInformadaException)) {
                throw e;
            }
            logger.info("Modulo nao instalado");
        }
    }

    private static void atualizarModulos() throws Exception {
        ConsoleApp.loadAllModulos();
        VerificaVersaoInstaladaModuloWebFiorilli deployService = new VerificaVersaoInstaladaModuloWebFiorilli();
        boolean removeOldModulos = ConsoleApp.confirm("Deseja remover os modulos anteriores?", false);
        deployService.verificarVersoes(ConsoleApp.getParams(false), modulos);
        InstalarModuloWebFiorilli moduloService = new InstalarModuloWebFiorilli();
        if (modulosIds != null && modulosIds.length > 0) {
            for (String id : modulosIds) {
                if (StringUtils.isNumeric(id)) {
                    ModuloWebFiorilli modulo = ConsoleApp.findModuloById(Integer.parseInt(id));
                    if (modulo != null) {
                        ConsoleApp.atualizarModulo(modulo, moduloService, removeOldModulos);
                        continue;
                    }
                    logger.error("Modulo nao encontrado id=" + id);
                    continue;
                }
                logger.error("Modulo Invalido id=" + id + ", informe um numero.");
            }
        } else {
            List<DeployVO> deployments = deployService.recuperarDeploymentsEnabled(ConsoleApp.getParams(false));
            if (deployments.isEmpty()) {
                logger.info("Nenhum modulo instalado encontrado");
            } else {
                ArrayList<ModuloWebFiorilli> modulosToUpdate = new ArrayList<ModuloWebFiorilli>();
                for (DeployVO deploy : deployments) {
                    String deployName = deploy.getName().substring(0, deploy.getName().indexOf(".ear"));
                    logger.info("Verificando atualizacao do " + deployName);
                    for (ModuloWebFiorilli modulo : modulos) {
                        String deployPattern;
                        deployName = deployName.replace("-SNAPSHOT", "");
                        String versionPattern = "\\d*[.]\\d*[.]\\d*[.]\\d*";
                        Matcher matcher = Pattern.compile(versionPattern).matcher(deployName);
                        if (!matcher.find() || !(matcher = Pattern.compile(deployPattern = deployName.replace(matcher.group(), versionPattern).concat("$")).matcher(modulo.getNome().replace("-SNAPSHOT", ""))).find()) continue;
                        modulosToUpdate.add(modulo);
                    }
                }
                if (modulosToUpdate.isEmpty()) {
                    logger.info("Nenhuma atualizacao necessaria");
                } else {
                    ModuloWebFiorilli modulo = Collections.max(modulosToUpdate, new Comparator<ModuloWebFiorilli>(){

                        @Override
                        public int compare(ModuloWebFiorilli m1, ModuloWebFiorilli m2) {
                            return m1.getVersaoDisponivelNumber().compareTo(m2.getVersaoDisponivelNumber());
                        }
                    });
                    ConsoleApp.atualizarModulo(modulo, moduloService, removeOldModulos);
                }
            }
        }
    }

    private static void printVersion() {
        logger.info("Versao deste instalador: " + ConsoleApp.getVersao());
    }

    private static void checkInstaladorNewVersion() {
        String versaoInstalada;
        String versaoDisponivel = new VerificaVersaoInstalador().getVersaoInstaladorDisponivel();
        if (VersionControl.isVersaoDisponivelSuperior(versaoDisponivel, versaoInstalada = ConsoleApp.getVersao())) {
            logger.info("\n/------------------------------------------------------------------\\\n| Nova Vers\u00e3o do Instalador Dispon\u00edvel.                            |\n| Acesse www.fiorilli.com.br/instalador para baixar a atualiza\u00e7\u00e3o. |\n| Versao Instalada:  " + versaoInstalada + "                                         |\n" + "| Versao Disponivel: " + versaoDisponivel + "                                         |\n" + "\\------------------------------------------------------------------/");
        }
    }

    private static String getVersao() {
        return "1.5.7";
    }

    private static void loadAllModulos() {
        modulos = new ArrayList<ModuloWebFiorilli>();
        new RepositorioDeModulosWebFiorilli().load(modulos, true);
        new RepositorioDeModulosWebFiorilli().load(modulos, false);
    }

    private static void loadModulos() {
        modulos = new ArrayList<ModuloWebFiorilli>();
        new RepositorioDeModulosWebFiorilli().load(modulos, true);
    }

    private static void loadModulosBeta() {
        modulos = new ArrayList<ModuloWebFiorilli>();
        new RepositorioDeModulosWebFiorilli().load(modulos, false);
    }

    private static void listarModulos() throws Exception {
        ConsoleApp.loadModulos();
        VerificaVersaoInstaladaModuloWebFiorilli deployService = new VerificaVersaoInstaladaModuloWebFiorilli();
        deployService.verificarVersoes(ConsoleApp.getParams(false), modulos);
        int maxLengthNome = 0;
        int maxLengthVersaoDisponivel = "Versao Disponivel".length();
        for (ModuloWebFiorilli modulo : modulos) {
            if (modulo.getNome().length() > maxLengthNome) {
                maxLengthNome = modulo.getNome().length();
            }
            if (modulo.getVersaoDisponivel().length() <= maxLengthVersaoDisponivel) continue;
            maxLengthVersaoDisponivel = modulo.getVersaoDisponivel().length();
        }
        logger.info("");
        StringBuilder sb = new StringBuilder();
        sb.append("#Id|");
        sb.append(String.format("%-" + maxLengthNome + "s", "Nome") + " |");
        sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", "Versao Disponivel") + " |");
        sb.append("Versao Instalada");
        logger.info(sb.toString());
        for (int i = 0; i < modulos.size(); ++i) {
            ModuloWebFiorilli modulo = modulos.get(i);
            sb = new StringBuilder();
            sb.append("#" + String.format("%2s", modulo.getId()) + "|");
            sb.append(String.format("%-" + maxLengthNome + "s", modulo.getNome()) + " |");
            sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", modulo.getVersaoDisponivel()) + " |");
            if (modulo.getVersaoInstalada() != null) {
                sb.append(modulo.getVersaoInstalada());
            }
            logger.info(sb.toString());
        }
        if (modulos.size() > 0) {
            logger.info("");
            int randomIndex = new Random().nextInt(modulos.size());
            sb = new StringBuilder();
            sb.append("Para instalar o ");
            sb.append(modulos.get(randomIndex).getNome());
            sb.append(" execute:\n");
            if (SystemUtils.IS_OS_WINDOWS) {
                sb.append("instalador ");
            } else {
                sb.append("./instalador");
            }
            sb.append("instalar-modulo id=");
            sb.append(modulos.get(randomIndex).getId());
            logger.info(sb.toString());
        }
    }

    private static void listarModulosBeta() throws Exception {
        ConsoleApp.loadModulosBeta();
        VerificaVersaoInstaladaModuloWebFiorilli deployService = new VerificaVersaoInstaladaModuloWebFiorilli();
        deployService.verificarVersoes(ConsoleApp.getParams(false), modulos);
        int maxLengthNome = 0;
        int maxLengthVersaoDisponivel = "Beta Disponivel".length();
        for (ModuloWebFiorilli modulo : modulos) {
            if (modulo.getNome().length() > maxLengthNome) {
                maxLengthNome = modulo.getNome().length();
            }
            if (modulo.getVersaoDisponivel().length() <= maxLengthVersaoDisponivel) continue;
            maxLengthVersaoDisponivel = modulo.getVersaoDisponivel().length();
        }
        logger.info("");
        StringBuilder sb = new StringBuilder();
        sb.append("#Id|");
        sb.append(String.format("%-" + maxLengthNome + "s", "Nome") + " |");
        sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", "Beta Disponivel") + " |");
        sb.append("Beta Instalado");
        logger.info(sb.toString());
        for (int i = 0; i < modulos.size(); ++i) {
            ModuloWebFiorilli modulo = modulos.get(i);
            sb = new StringBuilder();
            sb.append("#" + String.format("%2s", modulo.getId()) + "|");
            sb.append(String.format("%-" + maxLengthNome + "s", modulo.getNome()) + " |");
            sb.append(String.format("%-" + maxLengthVersaoDisponivel + "s", modulo.getVersaoDisponivel()) + " |");
            if (modulo.getVersaoInstalada() != null) {
                sb.append(modulo.getVersaoInstalada());
            }
            logger.info(sb.toString());
        }
        if (modulos.size() > 0) {
            logger.info("");
            int randomIndex = new Random().nextInt(modulos.size());
            sb = new StringBuilder();
            sb.append("Para instalar o ");
            sb.append(modulos.get(randomIndex).getNome());
            sb.append(" execute:\n");
            if (SystemUtils.IS_OS_WINDOWS) {
                sb.append("instalador ");
            } else {
                sb.append("./instalador");
            }
            sb.append("instalar-modulo id=");
            sb.append(modulos.get(randomIndex).getId());
            logger.info(sb.toString());
        }
    }

    private static void buildParams() {
        String jbossIp = null;
        int jbossPort = 0;
        String jbossUsr = null;
        String jbossPwd = null;
        String jbossDir = null;
        String scpiIni = null;
        String siaIni = null;
        String sipIni = null;
        boolean proxyUse = false;
        String proxyIp = null;
        boolean proxyPort = false;
        String proxyUser = null;
        String proxyPasswd = null;
        String virtualHost = null;
        String downloadFilePath = null;
        String jdkDir = null;
        JBossMode jbossMode = null;
        boolean debug = false;
        try {
            for (int i = 0; i < arglist.size(); ++i) {
                String arg = arglist.get(i);
                if (arg.contains(JBOSS_IP_PARAM)) {
                    jbossIp = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(JBOSS_PORTA_PARAM)) {
                    jbossPort = Integer.parseInt(arg.split("=")[1]);
                    continue;
                }
                if (arg.contains(INSTALAR_JBOSS_DIR_PARAM)) {
                    jbossDir = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(INSTALAR_MODULO_ID_PARAM)) {
                    modulosIds = arg.split("=")[1].split(",");
                    continue;
                }
                if (arg.contains(SCPI_INI_PARAM)) {
                    scpiIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(SIP_INI_PARAM)) {
                    sipIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(SIA_INI_PARAM)) {
                    siaIni = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(VIRTUAL_HOST_PARAM)) {
                    virtualHost = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(DOWNLOAD_PARAM)) {
                    downloadFilePath = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(JDK_DIR_PARAM)) {
                    jdkDir = arg.split("=")[1];
                    continue;
                }
                if (arg.contains(INSTALAR_JBOSS_MODE_PARAM)) {
                    jbossMode = JBossMode.valueOf(arg.split("=")[1].toUpperCase());
                    continue;
                }
                if (!arg.contains(DEBUG_CMD)) continue;
                debug = true;
            }
            if (SystemUtils.IS_OS_LINUX && jbossIp == null) {
                jbossIp = ConsoleApp.getIPLocal();
            }
            params = new Params(jbossIp, jbossPort, jbossUsr, jbossPwd, jbossDir, scpiIni, siaIni, sipIni, false, proxyIp, 0, proxyUser, proxyPasswd, virtualHost, downloadFilePath, jdkDir, jbossMode, debug, false);
        }
        catch (Exception e) {
            logger.error("Parametro ou Opcao Invalida");
            throw e;
        }
    }

    private static Params getParams(boolean removerModulos) {
        if (params == null) {
            ConsoleApp.buildParams();
        }
        params.setRemoveOldDeploys(removerModulos);
        return params;
    }

    private static void printExemplos() {
        logger.info("Exemplo 1 (Instalar o JBoss numa pasta diferente da padrao para o SO):");
        logger.info("    instalador instalar-jboss jboss-dir=" + Params.getDefaultJBossDir());
        logger.info("Exemplo 2 (Listar os modulos disponiveis para download e verificar a versao):");
        logger.info("    instalador listar-modulos-versao");
        logger.info("Exemplo 2.1 (Listar os modulos disponiveis para download e verificar a versao):");
        logger.info("    instalador listar-modulos-beta");
        logger.info("Exemplo 3 (Instalar um modulo):");
        logger.info("    instalador instalar-modulo id=1");
        logger.info("Exemplo 4 (instalar um modulo com virtual-host):");
        logger.info("    instalador instalar-modulo id=1 virtual-host=sipweb jdk-dir=" + Params.getDefaultJBossDir() + File.separator + InstallJBossService.getDirName() + File.separator + "jdk");
        logger.info("Exemplo 5 (instalar um modulo com download ja realizado):");
        logger.info("    instalador instalar-modulo id=1 download=c:\\fiorilli\\sip_7\\sipweb.ear");
        logger.info("Exemplo 6 (instalar um modulo com virtual-host com download ja realizado):");
        logger.info("    misturar os exemplos 4 e 5");
    }

    private static void configureLogger() {
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%m%n";
        console.setLayout(new PatternLayout("%m%n"));
        console.setEncoding(StandardCharsets.UTF_8.name());
        console.setThreshold(Level.INFO);
        console.activateOptions();
        Logger.getRootLogger().addAppender(console);
        FileAppender fa = new FileAppender();
        fa.setName("Instalador-Log-File");
        fa.setFile(ConsoleApp.getLogFileName());
        fa.setLayout(new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %-5p: %m%n"));
        fa.setThreshold(Level.INFO);
        fa.setAppend(true);
        fa.activateOptions();
        Logger.getRootLogger().addAppender(fa);
    }

    private static void printInstalarJBossHelp() {
        new InstallJBossService(ConsoleApp.getParams(false), new InstaladorProgressNullObj()).helpUnixUser();
    }

    private static String getLogFileName() {
        for (String arg : arglist) {
            if (!arg.contains(ARQUIVO_LOG_PARAM)) continue;
            return arg.split("=")[1];
        }
        return "Instalador.log.txt";
    }

    private static void instalarModulo() {
        ConsoleApp.loadAllModulos();
        InstalarModuloWebFiorilli moduloService = new InstalarModuloWebFiorilli();
        boolean removeOldModulos = ConsoleApp.confirm("Deseja remover os modulos anteriores?", false);
        for (String id : modulosIds) {
            if (StringUtils.isNumeric(id)) {
                ModuloWebFiorilli modulo = ConsoleApp.findModuloById(Integer.parseInt(id));
                if (modulo != null) {
                    boolean updateModulesJboss = moduloService.checkUpdateModulesJboss(modulo, ConsoleApp.getParams(false), progress);
                    if (updateModulesJboss && !ConsoleApp.confirm("Para instalar a versao sera necessario atualizar e reiniciar o Jboss. Deseja continuar?", true)) {
                        logger.info("Instalacao cancelada");
                        break;
                    }
                    moduloService.instalar(modulo, ConsoleApp.getParams(removeOldModulos), progress, updateModulesJboss);
                    continue;
                }
                logger.error("Modulo nao encontradoid=" + id);
                continue;
            }
            logger.error("Modulo Invalido id=" + id + ", informe um numero.");
        }
    }

    private static ModuloWebFiorilli findModuloById(int id) {
        for (ModuloWebFiorilli modulo : modulos) {
            if (modulo.getId() != id) continue;
            return modulo;
        }
        return null;
    }

    private static void instalarJBoss() throws IOException {
        new InstallJBossService(ConsoleApp.getParams(false), progress).install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean confirm(String question, boolean defaultValue) {
        boolean confirm = defaultValue;
        try {
            logger.info(String.format("%s (S/N) - %s", question, "Padrao ".concat(defaultValue ? "'S'" : "'N'")));
            String response = "";
            if (scanner.hasNextLine()) {
                response = scanner.nextLine();
            }
            if (!response.isEmpty()) {
                confirm = response.equalsIgnoreCase("S");
            }
            logger.info(confirm ? "Sim" : "Nao");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                confirm = false;
                logger.info(confirm ? "Sim" : "Nao");
            }
            catch (Throwable throwable) {
                logger.info(confirm ? "Sim" : "Nao");
                return confirm;
            }
            return confirm;
        }
        return confirm;
    }

    private static String getIPLocal() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    private static void printHelp() {
        logger.info("<<INSTRUCOES>>\n");
        logger.info(INSTALAR_JBOSS_CMD);
        logger.info("Parametros:");
        logger.info("    jboss-dir (padrao=" + Params.getDefaultJBossDir() + ")");
        logger.info("    mode (ex: mode=domain) (padrao=standalone)");
        logger.info("    help (exibe passos pos-instalacao novamente)");
        logger.info("");
        logger.info(LISTAR_MODULOS_CMD_VERSAO);
        logger.info("Parametros:");
        logger.info("    jboss-ip (padrao=" + Params.getDefaultLoopBackIp() + ")");
        logger.info("    jboss-port (padrao=" + Params.getDefaultJBossPort() + ")");
        logger.info("    proxy-ip");
        logger.info("    proxy-port");
        logger.info("    proxy-usr");
        logger.info("    proxy-pwd");
        logger.info("");
        logger.info(LISTAR_MODULOS_CMD_BETA);
        logger.info("Parametros:");
        logger.info("    jboss-ip (padrao=" + Params.getDefaultLoopBackIp() + ")");
        logger.info("    jboss-port (padrao=" + Params.getDefaultJBossPort() + ")");
        logger.info("    proxy-ip");
        logger.info("    proxy-port");
        logger.info("    proxy-usr");
        logger.info("    proxy-pwd");
        logger.info("");
        logger.info(INSTALAR_MODULO_CMD);
        logger.info("Parametros:");
        logger.info("    id=[numeros dos modulos separados por virgula dos comandos listar-modulos-versao / listar-modulos-beta]");
        logger.info("    scpi-ini (padrao=" + Params.getDefaultScpiIni() + ")");
        logger.info("    sia-ini (padrao=" + Params.getDefaultSiaIni() + ")");
        logger.info("    sip-ini (padrao=" + Params.getDefaultSipIni() + ")");
        logger.info("    download (caminho completo do arquivo baixado)");
        logger.info("    virtual-host (nome do virtual-host jdk-dir obrigatorio)");
        logger.info("    jdk-dir (caminho completo da JDK sem barra final)");
        logger.info("");
        logger.info(ATUALIZAR_MODULO);
        logger.info("Parametros:");
        logger.info("    id=[numero do modulo dos comandos listar-modulos-versao / listar-modulos-beta]");
        logger.info("    (Padrao = verifica se existe atualizacao do modulo instalado automaticamente)");
        logger.info("");
        logger.info(SALVAR_LOG_CMD);
        logger.info("Parametros:");
        logger.info("    arquivo-log=[caminho completo com nome do arquivo]");
        logger.info("");
        logger.info(DEBUG_CMD);
        logger.info("    (indicador para printStackTrace quando houver erros)");
        logger.info(EXEMPLOS_CMD);
        logger.info("    (Exibir Exemplos)");
        logger.info(SHOW_VERSAO);
        logger.info("    (Exibir a Versao Deste Instalador)");
        logger.info("");
        logger.info("IP local=" + ConsoleApp.getIPLocal());
        logger.info("");
    }

    static {
        arglist = new ArrayList<String>();
        progress = new InstaladorProgressBarConsole();
    }
}

