/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.file_system;

import br.com.fiorilli.instalador.progress_bar.InstaladorProgress;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FileUtil {
    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }

    public static File UnzipArchive(File theFile, File targetDir, InstaladorProgress progress) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " does not exist");
        }
        if (!FileUtil.buildDirectory(targetDir)) {
            throw new IOException("Could not create directory: " + targetDir);
        }
        try (ZipFile zipFile = new ZipFile(theFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<? extends ZipEntry> zipEntries = Collections.list(entries);
            for (int i = 0; i < zipEntries.size(); ++i) {
                ZipEntry zipEntry = (ZipEntry)zipEntries.get(i);
                File file = new File(targetDir, File.separator + zipEntry.getName());
                if (!FileUtil.buildDirectory(file.getParentFile())) {
                    throw new IOException("Could not create directory: " + file.getParentFile());
                }
                if (!zipEntry.isDirectory()) {
                    FileUtil.fastCopy(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file)));
                } else if (!FileUtil.buildDirectory(file)) {
                    throw new IOException("Could not create directory: " + file);
                }
                progress.setProgress((float)i / (float)zipEntries.size());
            }
            progress.setProgress(1.0);
        }
        return theFile;
    }

    public static void fastCopy(InputStream input, OutputStream output) throws IOException {
        WritableByteChannel dest;
        try (ReadableByteChannel src = Channels.newChannel(input);){
            dest = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        dest.close();
    }
}

