/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;

class CliConfigImpl
implements CliConfig {
    private static final String NS = "urn:jboss:cli:1.0";
    private static final String DEFAULT_CONTROLLER = "default-controller";
    private static final String ENABLED = "enabled";
    private static final String FILE_DIR = "file-dir";
    private static final String FILE_NAME = "file-name";
    private static final String JBOSS_CLI = "jboss-cli";
    private static final String HISTORY = "history";
    private static final String HOST = "host";
    private static final String MAX_SIZE = "max-size";
    private static final String PORT = "port";
    private String defaultControllerHost = "localhost";
    private int defaultControllerPort = 9999;
    private boolean historyEnabled = true;
    private String historyFileName = ".jboss-cli-history";
    private String historyFileDir = SecurityActions.getSystemProperty("user.home");
    private int historyMaxSize = 500;
    private SSLConfig sslConfig;

    static CliConfig load(CommandContext ctx) throws CliInitializationException {
        String jbossHome = SecurityActions.getEnvironmentVariable("JBOSS_HOME");
        if (jbossHome == null) {
            System.err.println("WARN: can't load the config file because JBOSS_HOME environment variable is not set.");
            return new CliConfigImpl();
        }
        return CliConfigImpl.parse(ctx, new File(jbossHome + File.separatorChar + "bin", "jboss-cli.xml"));
    }

    static CliConfig parse(CommandContext ctx, File f) throws CliInitializationException {
        if (f == null) {
            throw new CliInitializationException("The file argument is null.");
        }
        if (!f.exists()) {
            return new CliConfigImpl();
        }
        CliConfigImpl config = new CliConfigImpl();
        BufferedInputStream input = null;
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            mapper.registerRootElement(new QName(NS, JBOSS_CLI), new XMLElementReader<CliConfigImpl>(){

                @Override
                public void readElement(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
                    boolean jbossCliEnded = false;
                    while (reader.hasNext() && !jbossCliEnded) {
                        String localName;
                        int tag = reader.nextTag();
                        if (tag == 1) {
                            localName = reader.getLocalName();
                            if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                                this.readDefaultController(reader, config);
                                continue;
                            }
                            if (localName.equals(CliConfigImpl.HISTORY)) {
                                this.readHistory(reader, config);
                                continue;
                            }
                            if (localName.equals("ssl")) {
                                SslConfig sslConfig = new SslConfig();
                                this.readSSLElement(reader, sslConfig);
                                config.sslConfig = sslConfig;
                                continue;
                            }
                            throw new XMLStreamException("Unexpected element: " + localName);
                        }
                        if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                        jbossCliEnded = true;
                    }
                }

                private void readDefaultController(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String localName = reader.getLocalName();
                        String resolved = CliConfigImpl.resolveString(reader.getElementText());
                        if (CliConfigImpl.HOST.equals(localName)) {
                            config.defaultControllerHost = resolved;
                            continue;
                        }
                        if (CliConfigImpl.PORT.equals(localName)) {
                            try {
                                config.defaultControllerPort = Integer.parseInt(resolved);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new XMLStreamException("Failed to parse default-controller port value '" + resolved + "'", e);
                            }
                        }
                        throw new XMLStreamException("Unexpected child of default-controller: " + localName);
                    }
                }

                private void readHistory(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String localName = reader.getLocalName();
                        String resolved = CliConfigImpl.resolveString(reader.getElementText());
                        if (CliConfigImpl.ENABLED.equals(localName)) {
                            config.historyEnabled = Boolean.parseBoolean(resolved);
                            continue;
                        }
                        if (CliConfigImpl.FILE_NAME.equals(localName)) {
                            config.historyFileName = resolved;
                            continue;
                        }
                        if (CliConfigImpl.FILE_DIR.equals(localName)) {
                            config.historyFileDir = resolved;
                            continue;
                        }
                        if (CliConfigImpl.MAX_SIZE.equals(localName)) {
                            try {
                                config.historyMaxSize = Integer.parseInt(resolved);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new XMLStreamException("Failed to parse history max-size value '" + resolved + "'", e);
                            }
                        }
                        throw new XMLStreamException("Unexpected child of default-controller: " + localName);
                    }
                }

                public void readSSLElement(XMLExtendedStreamReader reader, SslConfig config) throws XMLStreamException {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String localName = reader.getLocalName();
                        if ("keyStore".equals(localName)) {
                            config.setKeyStore(reader.getElementText());
                            continue;
                        }
                        if ("keyStorePassword".equals(localName)) {
                            config.setKeyStorePassword(reader.getElementText());
                            continue;
                        }
                        if ("trustStore".equals(localName)) {
                            config.setTrustStore(reader.getElementText());
                            continue;
                        }
                        if ("trustStorePassword".equals(localName)) {
                            config.setTrustStorePassword(reader.getElementText());
                            continue;
                        }
                        if (!"modifyTrustStore".equals(localName)) continue;
                        config.setModifyTrustStore(Boolean.getBoolean(reader.getElementText()));
                    }
                }
            });
            FileInputStream is = new FileInputStream(f);
            input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            mapper.parseDocument(config, streamReader);
            streamReader.close();
        }
        catch (Throwable t) {
            try {
                throw new CliInitializationException("Failed to parse " + f.getAbsolutePath(), t);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
        }
        StreamUtils.safeClose(input);
        return config;
    }

    private static String resolveString(String str) throws XMLStreamException {
        if (str == null) {
            return null;
        }
        if (str.startsWith("${") && str.endsWith("}")) {
            String resolved = SecurityActions.getSystemProperty(str = str.substring(2, str.length() - 1));
            if (resolved == null) {
                throw new XMLStreamException("Failed to resolve '" + str + "' to a non-null value.");
            }
            str = resolved;
        }
        return str;
    }

    private CliConfigImpl() {
    }

    @Override
    public String getDefaultControllerHost() {
        return this.defaultControllerHost;
    }

    @Override
    public int getDefaultControllerPort() {
        return this.defaultControllerPort;
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    @Override
    public String getHistoryFileName() {
        return this.historyFileName;
    }

    @Override
    public String getHistoryFileDir() {
        return this.historyFileDir;
    }

    @Override
    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    @Override
    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    static class SslConfig
    implements SSLConfig {
        private String keyStore = null;
        private String keyStorePassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private boolean modifyTrustStore = true;

        SslConfig() {
        }

        @Override
        public String getKeyStore() {
            return this.keyStore;
        }

        void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public String getTrustStore() {
            return this.trustStore;
        }

        void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Override
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        void setModifyTrustStore(boolean modifyTrustStore) {
            this.modifyTrustStore = modifyTrustStore;
        }
    }
}

