/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.protocol.StreamUtils;

public interface Console {
    public void addCompleter(CommandLineCompleter var1);

    public boolean isUseHistory();

    public void setUseHistory(boolean var1);

    public CommandHistory getHistory();

    public void setHistoryFile(File var1);

    public void clearScreen();

    public void printColumns(Collection<String> var1);

    public void print(String var1);

    public void printNewLine();

    public String readLine(String var1);

    public String readLine(String var1, Character var2);

    public static final class Factory {
        public static Console getConsole(final CommandContext ctx) {
            ConsoleReader jlineConsole;
            String osName = SecurityActions.getSystemProperty("os.name").toLowerCase();
            String bindingsName = osName.indexOf("windows") >= 0 ? "keybindings/jline-windows-bindings.properties" : (osName.startsWith("mac") ? "keybindings/jline-mac-bindings.properties" : "keybindings/jline-default-bindings.properties");
            ClassLoader cl = SecurityActions.getClassLoader(Factory.class);
            InputStream bindingsIs = cl.getResourceAsStream(bindingsName);
            if (bindingsIs == null) {
                System.err.println("Failed to locate key bindings for OS '" + osName + "': " + bindingsName);
                try {
                    jlineConsole = new ConsoleReader();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to initialize console reader", e);
                }
            }
            try {
                FileInputStream in = new FileInputStream(FileDescriptor.in);
                String encoding = SecurityActions.getSystemProperty("jline.WindowsTerminal.output.encoding");
                if (encoding == null) {
                    encoding = SecurityActions.getSystemProperty("file.encoding");
                }
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
                jlineConsole = new ConsoleReader(in, out, bindingsIs);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize console reader", e);
            }
            finally {
                StreamUtils.safeClose(bindingsIs);
            }
            return new Console(){
                private CommandContext cmdCtx;
                private ConsoleReader console;
                private CommandHistory history;
                {
                    this.cmdCtx = ctx;
                    this.console = jlineConsole;
                    this.history = new HistoryImpl();
                }

                @Override
                public void addCompleter(final CommandLineCompleter completer) {
                    this.console.addCompletor(new Completor(){

                        @Override
                        public int complete(String buffer, int cursor, List candidates) {
                            return completer.complete(cmdCtx, buffer, cursor, candidates);
                        }
                    });
                }

                @Override
                public boolean isUseHistory() {
                    return jlineConsole.getUseHistory();
                }

                @Override
                public void setUseHistory(boolean useHistory) {
                    jlineConsole.setUseHistory(useHistory);
                }

                @Override
                public CommandHistory getHistory() {
                    return this.history;
                }

                @Override
                public void setHistoryFile(File f) {
                    try {
                        this.console.getHistory().setHistoryFile(f);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to setup the history file: " + f.getAbsolutePath());
                        e.printStackTrace();
                    }
                }

                @Override
                public void clearScreen() {
                    try {
                        this.console.setDefaultPrompt("");
                        this.console.clearScreen();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void printColumns(Collection<String> list) {
                    try {
                        this.console.printColumns(list);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void print(String line) {
                    try {
                        this.console.printString(line);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void printNewLine() {
                    try {
                        this.console.printNewline();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public String readLine(String prompt) {
                    try {
                        return this.console.readLine(prompt);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public String readLine(String prompt, Character mask) {
                    try {
                        return this.console.readLine(prompt, mask);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                class HistoryImpl
                implements CommandHistory {
                    HistoryImpl() {
                    }

                    @Override
                    public List<String> asList() {
                        return console.getHistory().getHistoryList();
                    }

                    @Override
                    public boolean isUseHistory() {
                        return console.getUseHistory();
                    }

                    @Override
                    public void setUseHistory(boolean useHistory) {
                        console.setUseHistory(useHistory);
                    }

                    @Override
                    public void clear() {
                        console.getHistory().clear();
                    }

                    @Override
                    public void setMaxSize(int maxSize) {
                        console.getHistory().setMaxSize(maxSize);
                    }

                    @Override
                    public int getMaxSize() {
                        return console.getHistory().getMaxSize();
                    }
                }
            };
        }
    }
}

