/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.controller.client.impl.ProtocolConfigurationFactory;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.xnio.OptionMap;

public class RemotingModelControllerClient
extends AbstractModelControllerClient {
    private Endpoint endpoint;
    private ManagementClientChannelStrategy strategy;
    private boolean closed;
    private final ManagementChannelHandler channelAssociation;
    private final ModelControllerClientConfiguration clientConfiguration;

    public RemotingModelControllerClient(ModelControllerClientConfiguration configuration) {
        this.channelAssociation = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            @Override
            public Channel getChannel() throws IOException {
                return RemotingModelControllerClient.this.getOrCreateChannel();
            }

            @Override
            public synchronized void close() throws IOException {
            }
        }, configuration.getExecutor(), this);
        this.clientConfiguration = configuration;
    }

    @Override
    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RemotingModelControllerClient remotingModelControllerClient = this;
        synchronized (remotingModelControllerClient) {
            this.closed = true;
            this.channelAssociation.shutdown();
            if (this.strategy != null) {
                StreamUtils.safeClose(this.strategy);
                this.strategy = null;
            }
            if (this.endpoint != null) {
                StreamUtils.safeClose(this.endpoint);
                this.endpoint = null;
            }
            this.channelAssociation.shutdownNow();
            try {
                this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            finally {
                StreamUtils.safeClose(this.clientConfiguration);
            }
        }
    }

    protected synchronized Channel getOrCreateChannel() throws IOException {
        if (this.closed) {
            throw ControllerClientMessages.MESSAGES.objectIsClosed(ModelControllerClient.class.getSimpleName());
        }
        if (this.strategy == null) {
            try {
                ProtocolChannelClient.Configuration configuration = ProtocolConfigurationFactory.create(this.clientConfiguration);
                this.endpoint = Remoting.createEndpoint("management-client", OptionMap.EMPTY);
                this.endpoint.addConnectionProvider("remote", new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
                configuration.setEndpoint(this.endpoint);
                ProtocolChannelClient setup = ProtocolChannelClient.create(configuration);
                this.strategy = ManagementClientChannelStrategy.create(setup, this.channelAssociation, this.clientConfiguration.getCallbackHandler(), this.clientConfiguration.getSaslOptions(), this.clientConfiguration.getSSLContext(), new CloseHandler<Channel>(){

                    @Override
                    public void handleClose(Channel closed, IOException exception) {
                        RemotingModelControllerClient.this.channelAssociation.handleChannelClosed(closed, exception);
                    }
                });
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.strategy.getChannel();
    }
}

