/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.OptionMap;

public abstract class ManagementClientChannelStrategy
implements Closeable {
    private static final String DEFAULT_CHANNEL_SERVICE_TYPE = "management";

    public abstract Channel getChannel() throws IOException;

    public static ManagementClientChannelStrategy create(Channel channel) {
        return new Existing(channel);
    }

    public static ManagementClientChannelStrategy create(ProtocolChannelClient setup, ManagementMessageHandler handler, CallbackHandler cbHandler, Map<String, String> saslOptions, SSLContext sslContext, CloseHandler<Channel> closeHandler) {
        return new Establishing(setup, saslOptions, cbHandler, sslContext, handler, closeHandler);
    }

    private static class Establishing
    extends ManagementClientChannelStrategy {
        private final String channelName;
        private final Map<String, String> saslOptions;
        private final CallbackHandler callbackHandler;
        private final SSLContext sslContext;
        private final Channel.Receiver receiver;
        private final ProtocolChannelClient setup;
        private final CloseHandler<Channel> closeHandlerDelegate;
        volatile Connection connection;
        volatile Channel channel;

        public Establishing(ProtocolChannelClient setup, Map<String, String> saslOptions, CallbackHandler callbackHandler, SSLContext sslContext, ManagementMessageHandler handler, CloseHandler<Channel> closeHandler) {
            this(ManagementClientChannelStrategy.DEFAULT_CHANNEL_SERVICE_TYPE, setup, saslOptions, callbackHandler, sslContext, handler, closeHandler);
        }

        public Establishing(String channelName, ProtocolChannelClient setup, Map<String, String> saslOptions, CallbackHandler callbackHandler, SSLContext sslContext, final ManagementMessageHandler handler, CloseHandler<Channel> closeHandler) {
            this.channelName = channelName;
            this.saslOptions = saslOptions;
            this.sslContext = sslContext;
            this.setup = setup;
            this.callbackHandler = callbackHandler;
            this.closeHandlerDelegate = closeHandler;
            this.receiver = new ManagementChannelReceiver(){

                @Override
                public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
                    handler.handleMessage(channel, input, header);
                }

                @Override
                protected void handleChannelReset(Channel channel) {
                    Establishing.this.resetChannel(channel);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Channel getChannel() throws IOException {
            boolean ok = false;
            try {
                Establishing establishing = this;
                synchronized (establishing) {
                    if (this.connection == null) {
                        this.connection = this.setup.connectSync(this.callbackHandler, this.saslOptions, this.sslContext);
                        this.connection.addCloseHandler(new CloseHandler<Connection>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleClose(Connection closed, IOException exception) {
                                Establishing establishing = Establishing.this;
                                synchronized (establishing) {
                                    if (Establishing.this.connection == closed) {
                                        Establishing.this.connection = null;
                                    }
                                }
                            }
                        });
                    }
                    if (this.channel == null) {
                        this.channel = this.connection.openChannel(this.channelName, OptionMap.EMPTY).get();
                        this.channel.addCloseHandler(new CloseHandler<Channel>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleClose(Channel closed, IOException exception) {
                                Establishing establishing = Establishing.this;
                                synchronized (establishing) {
                                    if (Establishing.this.channel == closed) {
                                        Establishing.this.channel = null;
                                    }
                                }
                                if (Establishing.this.closeHandlerDelegate != null) {
                                    Establishing.this.closeHandlerDelegate.handleClose(closed, exception);
                                }
                            }
                        });
                        this.channel.receiveMessage(this.receiver);
                    }
                    ok = true;
                }
            }
            finally {
                if (!ok) {
                    StreamUtils.safeClose(this.connection);
                    StreamUtils.safeClose(this.channel);
                }
            }
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetChannel(Channel old) {
            boolean reset = false;
            Establishing establishing = this;
            synchronized (establishing) {
                if (this.channel == old) {
                    this.channel = null;
                    reset = true;
                }
            }
            if (reset) {
                old.closeAsync();
            }
        }

        @Override
        public void close() {
            StreamUtils.safeClose(this.channel);
            StreamUtils.safeClose(this.connection);
        }
    }

    private static class Existing
    extends ManagementClientChannelStrategy {
        private final Channel channel;

        private Existing(Channel channel) {
            this.channel = channel;
        }

        @Override
        public Channel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
        }
    }
}

