/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;
import org.jboss.threads.BlockingExecutorService;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;
import org.jboss.threads.ShutdownListenable;
import org.jboss.threads.SimpleShutdownListenable;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.threads.ThreadCreationException;
import org.jboss.threads.management.BoundedThreadPoolExecutorMBean;

public final class QueuelessExecutor
extends AbstractExecutorService
implements BlockingExecutorService,
BoundedThreadPoolExecutorMBean,
ShutdownListenable {
    private static final Logger log = Logger.getLogger("org.jboss.threads.executor");
    private final SimpleShutdownListenable shutdownListenable = new SimpleShutdownListenable();
    private final ThreadFactory threadFactory;
    private final DirectExecutor taskExecutor;
    private final Lock lock = new ReentrantLock(false);
    private final Condition runnableDequeued = this.lock.newCondition();
    private final Condition nextReady = this.lock.newCondition();
    private final Condition workerDequeued = this.lock.newCondition();
    private final Condition taskEnqueued = this.lock.newCondition();
    private final Condition threadDeath = this.lock.newCondition();
    private final Set<Thread> runningThreads = new HashSet<Thread>(256);
    private Runnable workRunnable;
    private Worker waitingWorker;
    private long keepAliveTime;
    private int maxThreads;
    private boolean blocking;
    private Executor handoffExecutor;
    private boolean stop;
    private int largestPoolSize;
    private int rejectedCount;

    public QueuelessExecutor(ThreadFactory threadFactory, DirectExecutor taskExecutor, Executor handoffExecutor, long keepAliveTime) {
        this.threadFactory = threadFactory;
        this.taskExecutor = taskExecutor;
        this.handoffExecutor = handoffExecutor;
        this.keepAliveTime = keepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxThreads() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.maxThreads;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxThreads(int newSize) {
        if (newSize < 1) {
            throw new IllegalArgumentException("Pool size must be at least 1");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.maxThreads = newSize;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeepAliveTime() {
        Lock lock = this.lock;
        lock.lock();
        try {
            long l = this.keepAliveTime;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeepAliveTime(long milliseconds) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.keepAliveTime = milliseconds;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.runningThreads.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRejectedCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.rejectedCount;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlocking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.blocking;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlocking(boolean blocking) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.blocking = blocking;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getHandoffExecutor() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Executor executor = this.handoffExecutor;
            return executor;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandoffExecutor(Executor handoffExecutor) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.handoffExecutor = handoffExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean callShutdownListener = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                if (this.runningThreads.isEmpty()) {
                    callShutdownListener = true;
                } else {
                    for (Thread runningThread : this.runningThreads) {
                        runningThread.interrupt();
                    }
                }
            }
            this.stop = true;
            this.runnableDequeued.signalAll();
            this.nextReady.signalAll();
            this.workerDequeued.signalAll();
            this.taskEnqueued.signalAll();
        }
        finally {
            lock.unlock();
            if (callShutdownListener) {
                this.shutdownListenable.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                throw new IllegalStateException("Not shut down");
            }
            Date deadline = new Date(QueuelessExecutor.clipHigh(unit.toMillis(timeout) + System.currentTimeMillis()));
            Condition threadDeath = this.threadDeath;
            while (!this.runningThreads.isEmpty() && threadDeath.awaitUntil(deadline)) {
            }
            boolean bl = this.runningThreads.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop && this.runningThreads.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Set<Thread> runningThreads = this.runningThreads;
        Condition runnableDequeued = this.runnableDequeued;
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor has been shut down");
                }
                Worker waitingWorker = this.waitingWorker;
                if (waitingWorker != null) {
                    waitingWorker.setRunnable(task);
                    this.taskEnqueued.signal();
                    this.waitingWorker = null;
                    return;
                }
                int currentSize = runningThreads.size();
                if (currentSize < this.maxThreads) {
                    Thread thread = this.threadFactory.newThread(new Worker(task));
                    if (thread == null) {
                        throw new ThreadCreationException();
                    }
                    if (!runningThreads.add(thread)) {
                        throw new ThreadCreationException("Unable to add new thread to the running set");
                    }
                    if (currentSize >= this.largestPoolSize) {
                        this.largestPoolSize = currentSize + 1;
                    }
                    thread.start();
                    return;
                }
                if (!this.blocking) {
                    executor = this.handoffExecutor;
                    ++this.rejectedCount;
                    break;
                }
                Runnable workRunnable = this.workRunnable;
                if (workRunnable != null) {
                    try {
                        this.nextReady.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ExecutionInterruptedException();
                    }
                }
                this.workRunnable = task;
                try {
                    runnableDequeued.await();
                    if (this.workRunnable != null) continue;
                    this.nextReady.signal();
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionInterruptedException();
                }
                finally {
                    this.workRunnable = null;
                    continue;
                }
                break;
            }
        }
        finally {
            lock.unlock();
        }
        if (executor == null) {
            throw new RejectedExecutionException();
        }
        executor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Set<Thread> runningThreads = this.runningThreads;
        Condition runnableDequeued = this.runnableDequeued;
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor has been shut down");
                }
                Worker waitingWorker = this.waitingWorker;
                if (waitingWorker != null) {
                    waitingWorker.setRunnable(task);
                    this.taskEnqueued.signal();
                    this.waitingWorker = null;
                    return;
                }
                int currentSize = runningThreads.size();
                if (currentSize < this.maxThreads) {
                    Thread thread = this.threadFactory.newThread(new Worker(task));
                    if (thread == null) {
                        throw new ThreadCreationException();
                    }
                    if (!runningThreads.add(thread)) {
                        throw new ThreadCreationException("Unable to add new thread to the running set");
                    }
                    if (currentSize >= this.largestPoolSize) {
                        this.largestPoolSize = currentSize + 1;
                    }
                    thread.start();
                    return;
                }
                Runnable workRunnable = this.workRunnable;
                if (workRunnable != null) {
                    this.nextReady.await();
                    continue;
                }
                this.workRunnable = task;
                try {
                    runnableDequeued.await();
                    if (this.workRunnable != null) continue;
                    this.nextReady.signal();
                    return;
                }
                finally {
                    this.workRunnable = null;
                    continue;
                }
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        long now = System.currentTimeMillis();
        long deadline = now + unit.toMillis(timeout);
        if (deadline < 0L) {
            this.executeBlocking(task);
            return;
        }
        Set<Thread> runningThreads = this.runningThreads;
        Condition runnableDequeued = this.runnableDequeued;
        Lock lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.stop) {
                    throw new StoppedExecutorException("Executor has been shut down");
                }
                Worker waitingWorker = this.waitingWorker;
                if (waitingWorker != null) {
                    waitingWorker.setRunnable(task);
                    this.taskEnqueued.signal();
                    this.waitingWorker = null;
                    return;
                }
                int currentSize = runningThreads.size();
                if (currentSize < this.maxThreads) {
                    Thread thread = this.threadFactory.newThread(new Worker(task));
                    if (thread == null) {
                        throw new ThreadCreationException();
                    }
                    if (!runningThreads.add(thread)) {
                        throw new ThreadCreationException("Unable to add new thread to the running set");
                    }
                    if (currentSize >= this.largestPoolSize) {
                        this.largestPoolSize = currentSize + 1;
                    }
                    thread.start();
                    return;
                }
                Runnable workRunnable = this.workRunnable;
                if (workRunnable != null) {
                    this.nextReady.await();
                    continue;
                }
                this.workRunnable = task;
                try {
                    long remaining = deadline - now;
                    if (remaining <= 0L) {
                        throw new ExecutionTimedOutException();
                    }
                    runnableDequeued.await(remaining, TimeUnit.MILLISECONDS);
                    now = System.currentTimeMillis();
                    if (this.workRunnable != null) continue;
                    this.nextReady.signal();
                    return;
                }
                finally {
                    this.workRunnable = null;
                    continue;
                }
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        Executor executor;
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        Set<Thread> runningThreads = this.runningThreads;
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.stop) {
                throw new StoppedExecutorException("Executor has been shut down");
            }
            Worker waitingWorker = this.waitingWorker;
            if (waitingWorker != null) {
                waitingWorker.setRunnable(task);
                this.taskEnqueued.signal();
                this.waitingWorker = null;
                return;
            }
            int currentSize = runningThreads.size();
            if (currentSize < this.maxThreads) {
                Thread thread = this.threadFactory.newThread(new Worker(task));
                if (thread == null) {
                    throw new ThreadCreationException();
                }
                if (!runningThreads.add(thread)) {
                    throw new ThreadCreationException("Unable to add new thread to the running set");
                }
                if (currentSize >= this.largestPoolSize) {
                    this.largestPoolSize = currentSize + 1;
                }
                thread.start();
                return;
            }
            executor = this.handoffExecutor;
            ++this.rejectedCount;
        }
        finally {
            lock.unlock();
        }
        if (executor == null) {
            throw new RejectedExecutionException();
        }
        executor.execute(task);
    }

    @Override
    public <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.shutdownListenable.addShutdownListener(shutdownListener, attachment);
    }

    private static long clipHigh(long value) {
        return value < 0L ? Long.MAX_VALUE : value;
    }

    static /* synthetic */ Lock access$500(QueuelessExecutor x0) {
        return x0.lock;
    }

    static /* synthetic */ Condition access$600(QueuelessExecutor x0) {
        return x0.workerDequeued;
    }

    static /* synthetic */ Condition access$700(QueuelessExecutor x0) {
        return x0.runnableDequeued;
    }

    static /* synthetic */ Condition access$800(QueuelessExecutor x0) {
        return x0.taskEnqueued;
    }

    static /* synthetic */ Set access$900(QueuelessExecutor x0) {
        return x0.runningThreads;
    }

    static /* synthetic */ DirectExecutor access$1000(QueuelessExecutor x0) {
        return x0.taskExecutor;
    }

    static /* synthetic */ Logger access$1100() {
        return log;
    }

    static /* synthetic */ int access$1200(QueuelessExecutor x0) {
        return x0.maxThreads;
    }

    static /* synthetic */ Condition access$1300(QueuelessExecutor x0) {
        return x0.threadDeath;
    }

    static /* synthetic */ Runnable access$1400(QueuelessExecutor x0) {
        return x0.workRunnable;
    }

    static /* synthetic */ Runnable access$1402(QueuelessExecutor x0, Runnable x1) {
        x0.workRunnable = x1;
        return x0.workRunnable;
    }

    static /* synthetic */ Worker access$1500(QueuelessExecutor x0) {
        return x0.waitingWorker;
    }

    static /* synthetic */ Worker access$1502(QueuelessExecutor x0, Worker x1) {
        x0.waitingWorker = x1;
        return x0.waitingWorker;
    }

    static /* synthetic */ SimpleShutdownListenable access$1600(QueuelessExecutor x0) {
        return x0.shutdownListenable;
    }

    private final class Worker
    implements Runnable {
        private Runnable runnable;

        private Worker(Runnable runnable) {
            this.runnable = runnable;
        }

        private void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        private boolean awaitTimed(Condition condition, long idleSince) {
            long end = QueuelessExecutor.clipHigh(System.currentTimeMillis() + QueuelessExecutor.this.keepAliveTime);
            long remaining = end - idleSince;
            if (remaining < 0L) {
                return false;
            }
            if (QueuelessExecutor.this.stop) {
                return false;
            }
            try {
                condition.await(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return !QueuelessExecutor.this.stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            lock = QueuelessExecutor.access$500(QueuelessExecutor.this);
            workerDequeued = QueuelessExecutor.access$600(QueuelessExecutor.this);
            runnableDequeued = QueuelessExecutor.access$700(QueuelessExecutor.this);
            taskEnqueued = QueuelessExecutor.access$800(QueuelessExecutor.this);
            runningThreads = QueuelessExecutor.access$900(QueuelessExecutor.this);
            taskExecutor = QueuelessExecutor.access$1000(QueuelessExecutor.this);
            thread = Thread.currentThread();
            idleSince = 0x7FFFFFFFFFFFFFFFL;
            runnable = this.runnable;
            this.runnable = null;
            while (true) lbl-1000:
            // 6 sources

            {
                try {
                    taskExecutor.execute(runnable);
                }
                catch (Throwable t) {
                    QueuelessExecutor.access$1100().errorf(t, "Task execution failed for task %s", (Object)runnable);
                }
                idleSince = System.currentTimeMillis();
                lock.lock();
                try {
                    if (QueuelessExecutor.access$400(QueuelessExecutor.this) || runningThreads.size() > QueuelessExecutor.access$1200(QueuelessExecutor.this)) {
                        if (runningThreads.remove(thread) == false) return;
                        if (runningThreads.isEmpty() == false) return;
                        QueuelessExecutor.access$1300(QueuelessExecutor.this).signalAll();
                        return;
                    }
                    runnable = QueuelessExecutor.access$1400(QueuelessExecutor.this);
                    if (runnable != null) {
                        QueuelessExecutor.access$1402(QueuelessExecutor.this, null);
                        runnableDequeued.signal();
                    }
                    while (QueuelessExecutor.access$1500(QueuelessExecutor.this) != null) {
                        if (!this.awaitTimed(workerDequeued, idleSince)) {
                            return;
                        }
                        runnable = QueuelessExecutor.access$1400(QueuelessExecutor.this);
                        if (runnable == null) continue;
                    }
                    QueuelessExecutor.access$1502(QueuelessExecutor.this, this);
                    try {
                        do {
                            if (this.awaitTimed(taskEnqueued, idleSince)) continue;
                            return;
                        } while ((runnable = this.runnable) == null);
                    }
                    finally {
                        QueuelessExecutor.access$1502(QueuelessExecutor.this, null);
                        workerDequeued.signal();
                    }
                }
                finally {
                    lock.unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                last = false;
                lock.lock();
                try {
                    if (QueuelessExecutor.access$400(QueuelessExecutor.this) && runningThreads.remove(thread) && runningThreads.isEmpty()) {
                        QueuelessExecutor.access$1300(QueuelessExecutor.this).signalAll();
                        last = true;
                    }
                }
                finally {
                    lock.unlock();
                }
                if (last) {
                    QueuelessExecutor.access$1600(QueuelessExecutor.this).shutdown();
                }
            }
        }
    }
}

