/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_jboss.control;

import br.com.fiorilli.instalador.params.Params;
import java.io.File;
import org.apache.log4j.Logger;

public class SetupJbossDomainMode {
    Logger logger = Logger.getLogger(SetupJbossDomainMode.class);
    private final Params params;
    private final String jbossDirName;

    public SetupJbossDomainMode(Params params, String jbossDirName) {
        this.params = params;
        this.jbossDirName = jbossDirName;
    }

    public void setup() {
        this.logger.info((Object)"Configurando JBoss para modo dom\u00ednio");
        String bindir = this.params.getJbossDir() + File.separator + this.jbossDirName + File.separator + "bin" + File.separator;
        this.renameServiceBatToServiceStandaloneBat(bindir);
        this.renameServiceDomainBatToServiceBat(bindir);
        this.renameServiceInitdToServiceStandaloneInitd(bindir);
        this.renameServiceDomainInitdToServiceInitd(bindir);
        this.renameServiceShInitdToServiceStandaloneShInitd(bindir);
        this.renameServiceDomainShInitdToServiceShInitd(bindir);
        this.logger.info((Object)"JBoss Configurando para modo dom\u00ednio com sucesso");
    }

    private void renameServiceDomainShInitdToServiceShInitd(String bindir) {
        File f = new File(bindir + "init.d" + File.separator + "jboss-as-domain.sh");
        f.renameTo(new File(bindir + "init.d" + File.separator + "jboss-as.sh"));
    }

    private void renameServiceShInitdToServiceStandaloneShInitd(String bindir) {
        File f = new File(bindir + "init.d" + File.separator + "jboss-as.sh");
        f.renameTo(new File(bindir + "init.d" + File.separator + "jboss-as-standalone.sh"));
    }

    private void renameServiceBatToServiceStandaloneBat(String bindir) {
        File f = new File(bindir + "service.bat");
        f.renameTo(new File(bindir + "service-standalone.bat"));
    }

    private void renameServiceDomainBatToServiceBat(String bindir) {
        File f = new File(bindir + "service-domain.bat");
        f.renameTo(new File(bindir + "service.bat"));
    }

    private void renameServiceDomainInitdToServiceInitd(String bindir) {
        File f = new File(bindir + "init.d" + File.separator + "jboss-as-domain");
        f.renameTo(new File(bindir + "init.d" + File.separator + "jboss-as"));
    }

    private void renameServiceInitdToServiceStandaloneInitd(String bindir) {
        File f = new File(bindir + "init.d" + File.separator + "jboss-as");
        f.renameTo(new File(bindir + "init.d" + File.separator + "jboss-as-standalone"));
    }
}

