/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_modulo.boundary;

import br.com.fiorilli.instalador.business.instalar_jboss.boundary.InstallJBossService;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.AtualizadorServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.IsswebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.ModuloServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.ScpiServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.ServicosWebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.SincronizadorServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.dependency_resolver.SipwebServiceInfraDependencyResolver;
import br.com.fiorilli.instalador.business.instalar_modulo.control.virtual_host.ConfiguraVirtualHost;
import br.com.fiorilli.instalador.business.instalar_modulo.entity.ModuloWebFiorilli;
import br.com.fiorilli.instalador.cli.boundary.JBossCli;
import br.com.fiorilli.instalador.cli.entity.ArquivoVO;
import br.com.fiorilli.instalador.ftp.FTPUtil;
import br.com.fiorilli.instalador.http.FileDownloader;
import br.com.fiorilli.instalador.params.Params;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgress;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InstalarModuloWebFiorilli {
    static Logger logger = Logger.getLogger(InstalarModuloWebFiorilli.class);
    private Params params;
    private InstaladorProgress progress;

    public void instalar(ModuloWebFiorilli modulo, Params params, InstaladorProgress progress, boolean updateModulesJboss) {
        this.params = params;
        this.progress = progress;
        try {
            if (updateModulesJboss) {
                InstallJBossService installJBossService = new InstallJBossService(this.params, this.progress);
                installJBossService.updateModules();
                installJBossService.restartJboss();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        try {
            this.download(modulo);
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        try {
            this.publicar(modulo);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isDoubleExtention(String nomeArquivo) {
        return nomeArquivo.indexOf(".") < nomeArquivo.lastIndexOf(".");
    }

    private void download(ModuloWebFiorilli modulo) throws MalformedURLException {
        String nomeArquivo = FilenameUtils.getName((String)modulo.getUrlDownload());
        if (FilenameUtils.getExtension((String)nomeArquivo).equals("zip") && this.isDoubleExtention(nomeArquivo)) {
            nomeArquivo = nomeArquivo.replace(".zip", "");
        }
        String extention = FilenameUtils.getExtension((String)nomeArquivo);
        if (this.params.getDownloadFilePath() == null) {
            File file;
            if (!nomeArquivo.contains(modulo.getVersaoDisponivel())) {
                nomeArquivo = FilenameUtils.getBaseName((String)nomeArquivo).concat("-").concat(modulo.getVersaoDisponivel()).concat(".").concat(extention);
            }
            if ((file = new File(nomeArquivo)).exists()) {
                file.delete();
            }
            logger.info((Object)("Baixando " + modulo.getNome()));
            if ("FTP".equals(modulo.getTipoDownload())) {
                this.downloadFtp(modulo, nomeArquivo);
            } else {
                this.downloadHttp(modulo, nomeArquivo);
            }
        } else {
            nomeArquivo = this.params.getDownloadFilePath();
        }
        logger.info((Object)nomeArquivo);
        File deploy = new File(nomeArquivo);
        if (deploy.exists()) {
            modulo.setArquivoBaixado(new ArquivoVO(deploy));
            logger.info((Object)(modulo.getNome() + " baixado com sucesso. " + String.format("%,2dKB", modulo.getArquivoBaixado().getTamanhoEmKB())));
        } else {
            logger.info((Object)(modulo.getNome() + " nao foi baixado"));
        }
    }

    private void downloadFtp(ModuloWebFiorilli modulo, String nomeArquivo) {
        try {
            String ftpServer = modulo.getUrlDownload().split("/")[0];
            String ftpDirectory = FilenameUtils.getPathNoEndSeparator((String)modulo.getUrlDownload()).replace(ftpServer, "").substring(1);
            FTPUtil.downloadFromFTP(ftpServer, modulo.getUsrDownload(), modulo.getPwdDownload(), false, this.params.isProxyUse(), this.params.getProxyIp(), this.params.getProxyPort(), this.params.getProxyUser(), this.params.getProxyPasswd(), FilenameUtils.getName((String)modulo.getUrlDownload()), nomeArquivo, ftpDirectory, this.progress);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void downloadHttp(ModuloWebFiorilli modulo, String nomeArquivo) {
        try {
            URL url = new URL(modulo.getTipoDownload().concat("://").concat(modulo.getUrlDownload()));
            FileDownloader.downloadFile(url, nomeArquivo, this.progress);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void publicar(ModuloWebFiorilli modulo) throws Throwable {
        File file;
        try {
            file = modulo.getArquivoBaixado().getFile();
        }
        catch (NullPointerException e) {
            logger.error((Object)"Arquivo ja baixado nao encontrado");
            throw e;
        }
        String deploybasename = file.getName();
        if (!StringUtils.isEmpty((CharSequence)this.params.getVirtualHost())) {
            logger.info((Object)"Configurando Virtual Host");
            new ConfiguraVirtualHost().configuraModulo(file, this.params);
        }
        try (JBossCli cli = new JBossCli(this.params.getJbossIp(), this.params.getJbossPort());){
            ModuloServiceInfraDependencyResolver moduloInfraDependencyResolver = this.createModuloInfraDependencyResolver(modulo);
            if (moduloInfraDependencyResolver != null) {
                moduloInfraDependencyResolver.resolve(cli);
            }
            logger.info((Object)("Instalando Modulo " + modulo.getNome()));
            cli.deploy(file, deploybasename, this.params.isRemoveOldDeploys());
            if (cli.getErrors().size() == 0) {
                logger.info((Object)(modulo.getNome() + " Instalado com Sucesso"));
            } else {
                logger.info((Object)("Falha ao instalar modulo " + modulo.getNome()));
            }
        }
    }

    private ModuloServiceInfraDependencyResolver createModuloInfraDependencyResolver(ModuloWebFiorilli modulo) {
        String context = modulo.getContexto().toLowerCase();
        if (context.contains("sip")) {
            return new SipwebServiceInfraDependencyResolver(this.params);
        }
        if (context.contains("scpi")) {
            return new ScpiServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("atualizador")) {
            return new AtualizadorServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("sincronizador")) {
            return new SincronizadorServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("issweb")) {
            return new IsswebServiceInfraDependencyResolver(this.params);
        }
        if (context.toLowerCase().contains("servicosweb")) {
            return new ServicosWebServiceInfraDependencyResolver(this.params);
        }
        return null;
    }

    public boolean checkUpdateModulesJboss(ModuloWebFiorilli modulo, Params params, InstaladorProgress progress) {
        HashMap<String, Integer> mapVersionControl = new HashMap<String, Integer>();
        mapVersionControl.put("sip", 801061);
        mapVersionControl.put("sipweb", 371281);
        String key = modulo.getNome().split("-")[0];
        Integer versaoLimite = (Integer)mapVersionControl.get(key);
        InstallJBossService installJBossService = new InstallJBossService(params, progress);
        boolean updated = installJBossService.checkJbossModulesUpdated();
        return modulo.getVersaoDisponivelNumber().compareTo(versaoLimite) >= 0 && !updated;
    }
}

