/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_modulo.boundary;

import br.com.fiorilli.instalador.business.instalar_modulo.entity.ModuloWebFiorilli;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class RepositorioDeModulosWebFiorilli {
    private static final String URI_RELEASE = "/release";
    private static final String URI_BETA = "/beta";
    private static final String URI_PRIMARIA_INSTALADOR_CENTRAL = "http://fi1.fiorilli.com.br:5665/central/rest/modulos";
    private static final String URI_SECUNDARIA_INSTALADOR_CENTRAL = "http://fi2.fiorilli.com.br:5665/central/rest/modulos";
    static Logger logger = Logger.getLogger(RepositorioDeModulosWebFiorilli.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<ModuloWebFiorilli> result, boolean release) {
        block6: {
            if (result == null) {
                throw new IllegalArgumentException("Informe o argumento ja instanciado");
            }
            try {
                logger.info((Object)("Recuperando Modulos Disponiveis - " + (release ? "Versao" : "Beta")));
                HttpURLConnection conn = this.buildHttpConnection(release);
                if (conn == null) break block6;
                try {
                    ModuloWebFiorilli[] restItems = this.getModulosFromConnection(conn);
                    Collections.addAll(result, restItems);
                }
                finally {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private ModuloWebFiorilli[] getModulosFromConnection(HttpURLConnection conn) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ModuloWebFiorilli[] restItems = (ModuloWebFiorilli[])new Gson().fromJson((Reader)br, ModuloWebFiorilli[].class);
        logger.info((Object)(restItems.length + " modulos disponiveis"));
        br.close();
        return restItems;
    }

    private HttpURLConnection buildHttpConnection(boolean release) throws IOException {
        HttpURLConnection result = this.buildHttpConnection(URI_PRIMARIA_INSTALADOR_CENTRAL, release);
        if (result.getResponseCode() == 200) {
            return result;
        }
        result = this.buildHttpConnection(URI_SECUNDARIA_INSTALADOR_CENTRAL, release);
        if (result.getResponseCode() == 200) {
            return result;
        }
        return null;
    }

    private HttpURLConnection buildHttpConnection(String path, boolean release) throws IOException {
        URL url = new URL(path + (release ? URI_RELEASE : URI_BETA));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }
}

