/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.business.instalar_modulo.control.virtual_host;

import br.com.fiorilli.instalador.business.instalar_modulo.control.virtual_host.ConfiguraVirtualHostXmlApplication;
import br.com.fiorilli.instalador.business.instalar_modulo.control.virtual_host.ConfiguraVirtualHostXmlIntf;
import br.com.fiorilli.instalador.business.instalar_modulo.control.virtual_host.ConfiguraVirtualHostXmlJBossWeb;
import br.com.fiorilli.instalador.params.Params;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class ConfiguraVirtualHost {
    public void configuraModulo(File file, Params params) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (params.getJdkDir() == null) {
            throw new IllegalStateException("Informe o caminho da JDK para utilizar Virtual Host");
        }
        this.scanZip(file, params.getVirtualHost());
        List<String> files = this.extractWars(file);
        for (String f : files) {
            File warFile = new File(f);
            this.scanZip(warFile, params.getVirtualHost());
            String jarPath = params.getJdkDir().concat(File.separator).concat("bin").concat(File.separator);
            String cmd = String.format("%sjar uf %s %s", jarPath, file.getAbsolutePath(), warFile.getName());
            Process process = Runtime.getRuntime().exec(cmd);
            String error = IOUtils.toString((InputStream)process.getErrorStream());
            if (StringUtils.isNotBlank((CharSequence)error)) {
                throw new IOException("Ocorreu um erro ao atualizar o pacote ear\n" + error);
            }
            process.destroy();
            if (warFile.delete()) continue;
            warFile.deleteOnExit();
        }
    }

    private void scanZip(File file, String virtualHostName) throws ZipException, IOException, ParserConfigurationException, SAXException, TransformerException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + file.toPath().toUri());
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);
             ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().contains("application.xml")) {
                    this.configura(fs.getPath(entry.getName(), new String[0]), new ConfiguraVirtualHostXmlApplication());
                    continue;
                }
                if (!entry.getName().contains("jboss-web.xml")) continue;
                this.configura(fs.getPath(entry.getName(), new String[0]), new ConfiguraVirtualHostXmlJBossWeb(virtualHostName));
            }
        }
    }

    private void configura(Path xmlfilepath, ConfiguraVirtualHostXmlIntf configurador) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File xmltempfile = File.createTempFile(this.getClass().getCanonicalName(), ".xml");
        Files.copy(xmlfilepath, xmltempfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        configurador.configuraXml(xmltempfile);
        Files.copy(xmltempfile.toPath(), xmlfilepath, StandardCopyOption.REPLACE_EXISTING);
        xmltempfile.deleteOnExit();
    }

    private List<String> extractWars(File file) throws ZipException, IOException, ParserConfigurationException, SAXException, TransformerException {
        ArrayList<String> warNames = new ArrayList<String>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains(".war")) continue;
                File tempWar = new File(entry.getName());
                FileOutputStream tempOutWar = new FileOutputStream(tempWar);
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)tempOutWar);
                tempOutWar.close();
                warNames.add(entry.getName());
                tempWar.deleteOnExit();
            }
        }
        return warNames;
    }
}

