/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.ftp;

import br.com.fiorilli.instalador.ftp.FtpException;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgress;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamListener;

public class FTPUtil {
    private static final Logger logger = Logger.getLogger(FTPUtil.class.getName());

    public static FTPFile[] listFilesFromFTP(String ftpServer, String username, String password, boolean useActiveMode, boolean useProxy, String proxyHost, String proxyPort, String proxyUser, String proxyPassword, String ftpDirectory) throws FtpException {
        FTPFile[] lista;
        Object ftpClient = null;
        try {
            ftpClient = useProxy ? new FTPHTTPClient(proxyHost, Integer.parseInt(proxyPort), proxyUser, proxyPassword) : new FTPClient();
            int port = 0;
            String[] parts = ftpServer.split(":");
            if (parts.length == 2) {
                ftpServer = parts[0];
                port = Integer.parseInt(parts[1]);
            }
            if (port > 0) {
                ftpClient.connect(ftpServer, port);
            } else {
                ftpClient.connect(ftpServer);
            }
            logger.log(Level.FINEST, "Connected to {0} on {1}", new Object[]{ftpServer, port > 0 ? port : ftpClient.getDefaultPort()});
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftpClient.disconnect();
                logger.log(Level.WARNING, "O servidor FTP recusou a conex\u00e3o");
                throw new FtpException("O servidor FTP recusou a conex\u00e3o");
            }
            boolean login = ftpClient.login(username, password);
            if (!login) {
                logger.log(Level.WARNING, "N\u00e3o foi poss\u00edvel se conectar ao servidor FTP com as credenciais fornecidas");
                throw new FtpException("N\u00e3o foi poss\u00edvel se conectar ao servidor FTP com as credenciais fornecidas");
            }
            if (useActiveMode) {
                ftpClient.enterLocalActiveMode();
            } else {
                ftpClient.enterLocalPassiveMode();
            }
            boolean changeWorkingDirectory = ftpClient.changeWorkingDirectory(ftpDirectory);
            if (!changeWorkingDirectory) {
                logger.log(Level.WARNING, "O diret\u00f3rio fornecido n\u00e3o existe no servidor FTP");
                throw new FtpException("O diret\u00f3rio fornecido n\u00e3o existe no servidor FTP");
            }
            lista = ftpClient.listFiles();
            ftpClient.noop();
            ftpClient.logout();
        }
        catch (IOException e) {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.log(Level.SEVERE, null, e);
            throw new FtpException(e);
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException f) {
                    throw new FtpException("Erro ao desconectar-se do FTP");
                }
            }
        }
        return lista;
    }

    public static void downloadFromFTP(String ftpServer, String username, String password, boolean useActiveMode, boolean useProxy, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, String fileNameServer, String fileNameLocal, String ftpDirectory, InstaladorProgress pgbr) throws FtpException {
        Object ftpClient = null;
        FileOutputStream data = null;
        try {
            FTPFile[] files;
            data = new FileOutputStream(fileNameLocal);
            ftpClient = useProxy ? new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword) : new FTPClient();
            int port = 0;
            String[] parts = ftpServer.split(":");
            if (parts.length == 2) {
                ftpServer = parts[0];
                port = Integer.parseInt(parts[1]);
            }
            if (port > 0) {
                ftpClient.connect(ftpServer, port);
            } else {
                ftpClient.connect(ftpServer);
            }
            logger.log(Level.FINEST, "Connected to {0} on {1}", new Object[]{ftpServer, port > 0 ? port : ftpClient.getDefaultPort()});
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftpClient.disconnect();
                logger.log(Level.WARNING, "O servidor FTP recusou a conex\u00e3o");
                throw new FtpException("O servidor FTP recusou a conex\u00e3o");
            }
            boolean login = ftpClient.login(username, password);
            if (!login) {
                logger.log(Level.WARNING, "N\u00e3o foi poss\u00edvel se conectar ao servidor FTP com as credenciais fornecidas");
                throw new FtpException("N\u00e3o foi poss\u00edvel se conectar ao servidor FTP com as credenciais fornecidas");
            }
            if (useActiveMode) {
                ftpClient.enterLocalActiveMode();
            } else {
                ftpClient.enterLocalPassiveMode();
            }
            boolean changeWorkingDirectory = ftpClient.changeWorkingDirectory(ftpDirectory);
            if (!changeWorkingDirectory) {
                logger.log(Level.WARNING, "O diret\u00f3rio fornecido n\u00e3o existe no servidor FTP");
                throw new FtpException("O diret\u00f3rio fornecido n\u00e3o existe no servidor FTP");
            }
            ftpClient.setFileType(2);
            long filesize = 0L;
            for (FTPFile ftpFile : files = ftpClient.listFiles()) {
                if (!ftpFile.getName().equals(fileNameServer)) continue;
                filesize = ftpFile.getSize();
            }
            CopyStreamAdapterInstalador streamListener = new CopyStreamAdapterInstalador(pgbr, filesize);
            ftpClient.setCopyStreamListener((CopyStreamListener)streamListener);
            boolean retrieved = ftpClient.retrieveFile(fileNameServer, (OutputStream)data);
            if (!retrieved) {
                logger.log(Level.WARNING, "N\u00e3o foi poss\u00edvel recuperar o arquivo no servidor FTP");
                throw new FtpException("N\u00e3o foi poss\u00edvel recuperar o arquivo no servidor FTP");
            }
            ftpClient.noop();
            ftpClient.logout();
        }
        catch (IOException e) {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.log(Level.SEVERE, null, e);
            throw new FtpException(e);
        }
        finally {
            if (data != null) {
                try {
                    ((OutputStream)data).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException f) {
                    throw new FtpException("Erro ao desconectar-se do FTP");
                }
            }
        }
    }

    static class CopyStreamAdapterInstalador
    extends CopyStreamAdapter {
        private final InstaladorProgress pgbr;
        private final float filesize;

        public CopyStreamAdapterInstalador(InstaladorProgress pgbr, long filesize) {
            this.pgbr = pgbr;
            this.filesize = filesize;
        }

        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
            this.pgbr.setProgress((float)totalBytesTransferred / this.filesize);
        }
    }
}

