/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.javafx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class InstaladorLogAppenderFx
extends WriterAppender {
    private static final String DETAIL_MSG_FORMAT = "[%1$tY-%1$tM-%1$td %1$tH:%1$tM:%1$tS]";
    private static volatile TextArea lowLevelTextArea = null;
    private static volatile TextArea highLevelTextArea = null;
    private static volatile List<String> logdetail = new ArrayList<String>();

    public static void setTextAreaLowLevel(TextArea value) {
        lowLevelTextArea = value;
    }

    public static void setTextAreaHighLevel(TextArea value) {
        highLevelTextArea = value;
    }

    public void append(LoggingEvent loggingEvent) {
        String logdetailMessage = String.format(DETAIL_MSG_FORMAT, loggingEvent.timeStamp) + " " + String.format("%-5s", loggingEvent.getLevel().toString()) + ": " + loggingEvent.getMessage().toString() + "\n";
        logdetail.add(logdetailMessage);
        if (highLevelTextArea != null) {
            this.appendMessageToTextArea(logdetailMessage, highLevelTextArea);
        }
        if (loggingEvent.getLevel() == Level.INFO || loggingEvent.getLevel() == Level.ERROR || loggingEvent.getLevel() == Level.WARN) {
            String message = this.layout.format(loggingEvent);
            this.appendMessageToTextArea(message, lowLevelTextArea);
        }
    }

    private void appendMessageToTextArea(final String message, final TextArea textArea) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (textArea != null) {
                            textArea.appendText(message);
                        }
                    }
                    catch (Throwable t) {
                        System.out.println("Unable to append log to text area: " + t.getMessage());
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void saveToFile(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            for (String logitem : logdetail) {
                ((OutputStream)out).write(logitem.getBytes());
            }
            out.flush();
        }
    }
}

