/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.javafx;

import br.com.fiorilli.instalador.business.instalar_jboss.boundary.InstallJBossService;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.InstalarModuloWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.RepositorioDeModulosWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.boundary.VerificaVersaoInstaladaModuloWebFiorilli;
import br.com.fiorilli.instalador.business.instalar_modulo.entity.ModuloWebFiorilli;
import br.com.fiorilli.instalador.javafx.InstaladorLogAppenderFx;
import br.com.fiorilli.instalador.javafx.InstaladorProgressBarFxImpl;
import br.com.fiorilli.instalador.params.JBossMode;
import br.com.fiorilli.instalador.params.Params;
import br.com.fiorilli.instalador.progress_bar.InstaladorProgressNullObj;
import br.com.fiorilli.instalador.version_control.VerificaVersaoInstalador;
import br.com.fiorilli.util.VersionControl;
import br.com.fiorilli.util.criptografy.LoginCriptografy;
import br.com.fiorilli.util.criptografy.LoginCriptografyFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.animation.FadeTransition;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MainController
implements Initializable {
    private static final String PROPERTIES_FILENAME = "InstaladorJava.properties";
    private static Logger logger = Logger.getLogger(MainController.class);
    @FXML
    private TableView<ModuloWebFiorilli> tableView;
    @FXML
    private TableColumn<ModuloWebFiorilli, String> columnNome;
    @FXML
    private TableColumn<ModuloWebFiorilli, String> columnVersaoDisponivel;
    @FXML
    private TableColumn<ModuloWebFiorilli, String> columnVersaoInstalada;
    @FXML
    private TextArea memo;
    @FXML
    private TextArea memoAll;
    @FXML
    private Button btnInstalarJBoss;
    @FXML
    private Button btnListarModulos;
    @FXML
    private Button btnListarModulosBeta;
    @FXML
    private Button btnInstalarModulo;
    @FXML
    private Button btnLimpar;
    @FXML
    private Button btnTestarJBoss;
    @FXML
    private TabPane tabPane;
    @FXML
    private TextField inputIpJboss;
    @FXML
    private TextField inputJbossPort;
    @FXML
    private TextField inputJbossUsr;
    @FXML
    private PasswordField inputJbossPwd;
    @FXML
    private TextField inputJBossInstallDirecory;
    @FXML
    private TextField inputIniScpi;
    @FXML
    private TextField inputIniSia;
    @FXML
    private TextField inputIniSip;
    @FXML
    private CheckBox checkProxyUse;
    @FXML
    private TextField inputProxyIp;
    @FXML
    private TextField inputProxyPort;
    @FXML
    private TextField inputProxyUser;
    @FXML
    private TextField inputProxyPwd;
    @FXML
    private ProgressBar pgbr;
    @FXML
    private ProgressIndicator pgin;
    @FXML
    private CheckBox ckSemDownload;
    @FXML
    private TextField inputVirtualHost;
    @FXML
    private TextField inputArquivoBaixado;
    @FXML
    private ComboBox<JBossMode> selectJbossMode;
    @FXML
    private Label labelAppTitle;
    @FXML
    private CheckBox ckRemoverVersaoAnterior;
    private ObservableList<ModuloWebFiorilli> modulos;
    private HashMap<String, Integer> mapVersionControl = new HashMap();

    public void initialize(URL url, ResourceBundle rb) {
        this.labelAppTitle.setText("Instalador Java " + MainController.getVersao());
        this.pgin.setVisible(false);
        InstaladorLogAppenderFx.setTextAreaLowLevel(this.memo);
        InstaladorLogAppenderFx.setTextAreaHighLevel(this.memoAll);
        this.columnNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.columnVersaoDisponivel.setCellValueFactory((Callback)new PropertyValueFactory("versaoDisponivel"));
        this.columnVersaoDisponivel.setStyle("-fx-alignment: CENTER;");
        this.columnVersaoInstalada.setCellValueFactory((Callback)new PropertyValueFactory("versaoInstalada"));
        this.columnVersaoInstalada.setStyle("-fx-alignment: CENTER;");
        this.tabPane.getSelectionModel().select(0);
        this.initSelectJbossMode();
        this.onCkSemDownloadClick(null);
        this.loadProperties();
        this.checkInstaladorNewVersion();
        this.checkConfigurationJboss();
    }

    private void checkInstaladorNewVersion() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                String versaoInstalada;
                String versaoDisponivel = new VerificaVersaoInstalador().getVersaoInstaladorDisponivel();
                if (!VersionControl.isVersaoDisponivelSuperior((String)versaoDisponivel, (String)(versaoInstalada = MainController.getVersao()))) {
                    throw new Exception("Instalador Atualizado");
                }
                return null;
            }

            protected void succeeded() {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Atualizar Instalador");
                alert.setHeaderText(null);
                alert.setContentText("Nova Vers\u00e3o do Instalador Dispon\u00edvel.\nAcesse www.fiorilli.com.br/instalador para baixar a atualiza\u00e7\u00e3o.");
                alert.showAndWait();
                super.succeeded();
            }

            protected void failed() {
                super.failed();
            }
        };
        new Thread((Runnable)task).start();
    }

    private void initSelectJbossMode() {
        this.selectJbossMode.getItems().addAll((Object[])JBossMode.values());
        this.selectJbossMode.setValue((Object)JBossMode.STANDALONE);
    }

    private void fadeInOn(Node node) {
        FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), node);
        ft.setFromValue(0.5);
        ft.setToValue(1.0);
        ft.setAutoReverse(true);
        ft.play();
    }

    private void fadeOutOn(Node node) {
        FadeTransition ft = new FadeTransition(Duration.millis((double)2000.0), node);
        ft.setFromValue(1.0);
        ft.setToValue(0.5);
        ft.setAutoReverse(true);
        ft.play();
    }

    @FXML
    public void onVerificar(ActionEvent event) {
        if (this.tabPane.getSelectionModel().getSelectedIndex() != 0) {
            this.tabPane.getSelectionModel().select(0);
        }
        final ProgressIndicator pin = this.pgin;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainController.this.memo.clear();
                if (MainController.this.modulos != null) {
                    MainController.this.modulos.clear();
                }
                MainController.this.modulos = FXCollections.observableArrayList();
                new RepositorioDeModulosWebFiorilli().load((List<ModuloWebFiorilli>)MainController.this.modulos, true);
                VerificaVersaoInstaladaModuloWebFiorilli deployService = new VerificaVersaoInstaladaModuloWebFiorilli();
                try {
                    deployService.verificarVersoes(MainController.this.getParams(), (List<ModuloWebFiorilli>)MainController.this.modulos);
                    MainController.this.tableView.setItems(MainController.this.modulos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)e.getMessage());
                }
                return null;
            }

            protected void running() {
                super.running();
                pin.setProgress(-1.0);
                pin.setVisible(true);
                MainController.this.fadeOutOn((Node)MainController.this.btnListarModulos);
                MainController.this.fadeOutOn((Node)MainController.this.btnListarModulosBeta);
                MainController.this.btnInstalarModulo.setDisable(true);
                MainController.this.tabPane.getSelectionModel().select(0);
            }

            protected void succeeded() {
                super.succeeded();
                MainController.this.fadeInOn((Node)MainController.this.btnListarModulos);
                MainController.this.fadeInOn((Node)MainController.this.btnListarModulosBeta);
                if (MainController.this.modulos.size() > 0) {
                    MainController.this.fadeInOn((Node)MainController.this.btnInstalarModulo);
                    MainController.this.btnInstalarModulo.setDisable(false);
                }
                pin.setVisible(false);
            }

            protected void failed() {
                super.failed();
                pin.setVisible(false);
            }
        };
        new Thread((Runnable)task).start();
    }

    @FXML
    public void onVerificarBeta(ActionEvent event) {
        if (this.tabPane.getSelectionModel().getSelectedIndex() != 0) {
            this.tabPane.getSelectionModel().select(0);
        }
        final ProgressIndicator pin = this.pgin;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainController.this.memo.clear();
                if (MainController.this.modulos != null) {
                    MainController.this.modulos.clear();
                }
                MainController.this.modulos = FXCollections.observableArrayList();
                new RepositorioDeModulosWebFiorilli().load((List<ModuloWebFiorilli>)MainController.this.modulos, false);
                VerificaVersaoInstaladaModuloWebFiorilli deployService = new VerificaVersaoInstaladaModuloWebFiorilli();
                try {
                    deployService.verificarVersoes(MainController.this.getParams(), (List<ModuloWebFiorilli>)MainController.this.modulos);
                    MainController.this.tableView.setItems(MainController.this.modulos);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                return null;
            }

            protected void running() {
                super.running();
                pin.setProgress(-1.0);
                pin.setVisible(true);
                MainController.this.fadeOutOn((Node)MainController.this.btnListarModulos);
                MainController.this.fadeOutOn((Node)MainController.this.btnListarModulosBeta);
                MainController.this.btnInstalarModulo.setDisable(true);
                MainController.this.tabPane.getSelectionModel().select(0);
            }

            protected void succeeded() {
                super.succeeded();
                MainController.this.fadeInOn((Node)MainController.this.btnListarModulos);
                MainController.this.fadeInOn((Node)MainController.this.btnListarModulosBeta);
                if (MainController.this.modulos.size() > 0) {
                    MainController.this.fadeInOn((Node)MainController.this.btnInstalarModulo);
                    MainController.this.btnInstalarModulo.setDisable(false);
                }
                pin.setVisible(false);
            }

            protected void failed() {
                super.failed();
                pin.setVisible(false);
                logger.error((Object)"N\u00e3o foi poss\u00edvel listar os m\u00f3dulos.");
            }
        };
        new Thread((Runnable)task).start();
    }

    public TableView<ModuloWebFiorilli> getTableView() {
        return this.tableView;
    }

    @FXML
    public void onTestJbossConnection(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainController.this.memo.clear();
                MainController.this.checkConfigurationJboss();
                Params params = MainController.this.getParams();
                InstallJBossService installjb = new InstallJBossService(params, new InstaladorProgressNullObj());
                installjb.testJBossInstallation();
                return null;
            }

            protected void running() {
                super.running();
                MainController.this.btnTestarJBoss.setDisable(true);
                MainController.this.fadeOutOn((Node)MainController.this.btnTestarJBoss);
                logger.info((Object)"Tentativa de conex\u00e3o com o JBoss...");
            }

            protected void succeeded() {
                super.succeeded();
                MainController.this.fadeInOn((Node)MainController.this.btnTestarJBoss);
                MainController.this.btnTestarJBoss.setDisable(false);
                logger.info((Object)"Conex\u00e3o Realizada com Sucesso.");
            }

            protected void failed() {
                super.failed();
                MainController.this.fadeInOn((Node)MainController.this.btnTestarJBoss);
                MainController.this.btnTestarJBoss.setDisable(false);
                logger.info((Object)"N\u00e3o foi poss\u00edvel conectar.");
            }
        };
        new Thread((Runnable)task).start();
    }

    @FXML
    public void onLimpar(ActionEvent event) {
        if (this.modulos != null) {
            this.modulos.clear();
        }
        this.memo.clear();
        this.btnInstalarModulo.setDisable(true);
        this.fadeOutOn((Node)this.btnInstalarModulo);
    }

    @FXML
    public void onInstalarJboss(ActionEvent event) throws Exception {
        final InstaladorProgressBarFxImpl progress = new InstaladorProgressBarFxImpl((ProgressIndicator)this.pgbr);
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainController.this.memo.clear();
                new InstallJBossService(MainController.this.getParams(MainController.this.inputArquivoBaixado.getText()), progress).install();
                return null;
            }

            protected void running() {
                super.running();
                MainController.this.btnInstalarJBoss.setDisable(true);
                MainController.this.fadeOutOn((Node)MainController.this.btnInstalarJBoss);
                MainController.this.pgin.setVisible(true);
            }

            protected void succeeded() {
                super.succeeded();
                MainController.this.fadeInOn((Node)MainController.this.btnInstalarJBoss);
                MainController.this.btnInstalarJBoss.setDisable(false);
                MainController.this.pgin.setVisible(false);
                MainController.this.pgbr.setProgress(0.0);
            }

            protected void failed() {
                super.failed();
                MainController.this.pgin.setVisible(false);
                MainController.this.fadeInOn((Node)MainController.this.btnInstalarJBoss);
                MainController.this.btnInstalarJBoss.setDisable(false);
            }

            protected void cancelled() {
                super.cancelled();
                MainController.this.pgin.setVisible(false);
                MainController.this.fadeInOn((Node)MainController.this.btnInstalarJBoss);
                MainController.this.btnInstalarJBoss.setDisable(false);
            }
        };
        new Thread((Runnable)task).start();
    }

    public Params getParams() {
        return this.getParams(null);
    }

    public Params getParams(String downloadFilePath) {
        return new Params(this.inputIpJboss.getText(), StringUtils.isEmpty((CharSequence)this.inputJbossPort.getText()) ? 0 : Integer.parseInt(this.inputJbossPort.getText()), this.inputJbossUsr.getText(), this.inputJbossPwd.getText(), this.inputJBossInstallDirecory.getText(), this.inputIniScpi.getText(), this.inputIniSia.getText(), this.inputIniSip.getText(), this.checkProxyUse.isSelected(), this.inputProxyIp.getText(), this.inputProxyPort.getText().equals("") ? 0 : Integer.parseInt(this.inputProxyPort.getText()), this.inputProxyUser.getText(), this.inputProxyPwd.getText(), null, downloadFilePath, null, (JBossMode)((Object)this.selectJbossMode.getValue()), false, this.ckRemoverVersaoAnterior.isSelected());
    }

    @FXML
    public void onCkSemDownloadClick(ActionEvent event) {
        this.inputArquivoBaixado.setVisible(this.ckSemDownload.isSelected());
        if (!this.ckSemDownload.isSelected()) {
            this.inputArquivoBaixado.setText(null);
        }
    }

    @FXML
    public void onInstalarModulos(ActionEvent event) {
        final ModuloWebFiorilli modulo = (ModuloWebFiorilli)this.tableView.getSelectionModel().getSelectedItem();
        final InstaladorProgressBarFxImpl progress = new InstaladorProgressBarFxImpl((ProgressIndicator)this.pgbr);
        final InstalarModuloWebFiorilli moduloService = new InstalarModuloWebFiorilli();
        final boolean updateModulesJboss = moduloService.checkUpdateModulesJboss(modulo, this.getParams(), progress);
        if (updateModulesJboss && !this.onConfirmDialog(Alert.AlertType.INFORMATION, "Jboss", "Para instalar a vers\u00e3o ser\u00e1 necess\u00e1rio atualizar e reiniciar o Jboss.\nDeseja continuar?")) {
            logger.info((Object)"Instala\u00e7\u00e3o cancelada");
            return;
        }
        final TableView<ModuloWebFiorilli> tv = this.tableView;
        if (modulo != null) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    MainController.this.memo.clear();
                    moduloService.instalar(modulo, MainController.this.getParams(MainController.this.inputArquivoBaixado.getText()), progress, updateModulesJboss);
                    return null;
                }

                protected void succeeded() {
                    super.succeeded();
                    this.disableCtrls(false);
                    MainController.this.pgbr.setProgress(0.0);
                    modulo.setVersaoInstalada(modulo.getVersaoDisponivel());
                    this.updateVersaoInstalada();
                }

                private void updateVersaoInstalada() {
                    tv.getColumns().remove((Object)MainController.this.columnVersaoInstalada);
                    tv.getColumns().add((Object)MainController.this.columnVersaoInstalada);
                }

                protected void running() {
                    super.running();
                    this.disableCtrls(true);
                }

                protected void failed() {
                    super.failed();
                    this.disableCtrls(false);
                }

                protected void cancelled() {
                    super.cancelled();
                    this.disableCtrls(false);
                }

                private void disableCtrls(Boolean value) {
                    MainController.this.pgin.setVisible(value.booleanValue());
                    MainController.this.btnInstalarJBoss.setDisable(value.booleanValue());
                    MainController.this.btnInstalarModulo.setDisable(value.booleanValue());
                    MainController.this.btnLimpar.setDisable(value.booleanValue());
                }
            };
            new Thread((Runnable)task).start();
        } else {
            logger.info((Object)"Selecione um M\u00f3dulo");
        }
    }

    public ObservableList<ModuloWebFiorilli> getModulos() {
        return this.modulos;
    }

    public void setModulos(ObservableList<ModuloWebFiorilli> modulos) {
        this.modulos = modulos;
    }

    @FXML
    public void onSalvarLogInstalador(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Informe o Nome do Arquivo de Log");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivo Log", new String[]{"*.log"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivo Texto", new String[]{"*.txt"}));
        File file = fileChooser.showSaveDialog(((Button)event.getTarget()).getScene().getWindow());
        if (file != null) {
            try {
                InstaladorLogAppenderFx.saveToFile(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void onSalvarLogJboss() {
        logger.warn((Object)"Fun\u00e7\u00e3o Indispon\u00edvel");
    }

    @FXML
    public void onSalvarParams(ActionEvent event) {
        this.saveProperties();
        logger.info((Object)"Par\u00e2metros Salvos Com Sucesso");
    }

    private void loadProperties() {
        Properties prop = new Properties();
        try {
            File file = new File(PROPERTIES_FILENAME);
            if (file.exists()) {
                prop.load(new FileInputStream(file));
                this.inputIpJboss.setText(prop.getProperty("Jboss.Ip"));
                this.inputJbossPort.setText(prop.getProperty("Jboss.port"));
                this.inputIniScpi.setText(prop.getProperty("Scpi.Ini"));
                this.inputIniSip.setText(prop.getProperty("Sip.Ini"));
                this.checkProxyUse.selectedProperty().set(Boolean.parseBoolean(prop.getProperty("Proxy.Use")));
                this.inputProxyIp.setText(prop.getProperty("Proxy.Ip"));
                this.inputProxyPort.setText(prop.getProperty("Proxy.Port"));
                LoginCriptografy cripto = LoginCriptografyFactory.getNewLoginCriptografySipweb();
                this.inputProxyUser.setText(cripto.getCleanText(prop.getProperty("Proxy.User")));
                this.inputProxyPwd.setText(cripto.getCleanText(prop.getProperty("Proxy.Pwd")));
            } else {
                this.inputJBossInstallDirecory.setText(Params.getDefaultJBossDir());
                this.inputIniScpi.setText(Params.getDefaultScpiIni());
                this.inputIniSia.setText(Params.getDefaultSiaIni());
                this.inputIniSip.setText(Params.getDefaultSipIni());
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void saveProperties() {
        Properties prop = new Properties();
        try {
            prop.setProperty("Jboss.Ip", this.inputIpJboss.getText());
            prop.setProperty("Jboss.port", this.inputJbossPort.getText());
            prop.setProperty("Scpi.Ini", this.inputIniScpi.getText());
            prop.setProperty("Sip.Ini", this.inputIniSip.getText());
            prop.setProperty("Proxy.Use", Boolean.toString(this.checkProxyUse.isSelected()));
            prop.setProperty("Proxy.Ip", this.inputProxyIp.getText());
            prop.setProperty("Proxy.Port", this.inputProxyPort.getText());
            LoginCriptografy cripto = LoginCriptografyFactory.getNewLoginCriptografySipweb();
            prop.setProperty("Proxy.User", cripto.getCriptoText(this.inputProxyUser.getText()));
            prop.setProperty("Proxy.Pwd", cripto.getCriptoText(this.inputProxyPwd.getText()));
            prop.store(new FileWriter(PROPERTIES_FILENAME), null);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    @FXML
    public void onClose() {
        if (this.modulos != null) {
            for (ModuloWebFiorilli modulo : this.modulos) {
                File file = new File(FilenameUtils.getName((String)modulo.getUrlDownload()));
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    @FXML
    public void onLocalizarScpiIni(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Selecione o Arquivo Scpi.ini");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivo ini", new String[]{"*.ini"}));
        File file = fileChooser.showOpenDialog(((Button)event.getTarget()).getScene().getWindow());
        if (file != null) {
            this.inputIniScpi.setText(file.getAbsolutePath());
        }
    }

    @FXML
    public void onLocalizarSiaIni(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Selecione o Arquivo sia.ini");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivo ini", new String[]{"*.ini"}));
        File file = fileChooser.showOpenDialog(((Button)event.getTarget()).getScene().getWindow());
        if (file != null) {
            this.inputIniSia.setText(file.getAbsolutePath());
        }
    }

    @FXML
    public void onLocalizarSipIni(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Selecione o Arquivo sip.ini");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivo ini", new String[]{"*.ini"}));
        File file = fileChooser.showOpenDialog(((Button)event.getTarget()).getScene().getWindow());
        if (file != null) {
            this.inputIniSip.setText(file.getAbsolutePath());
        }
    }

    @FXML
    public void onLocalizarJBossInstalationDirectory(ActionEvent event) {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle("Selecione o Diret\u00f3rio de Instala\u00e7\u00e3o do JBoss");
        File file = dirChooser.showDialog(((Button)event.getTarget()).getScene().getWindow());
        if (file != null && file.isDirectory()) {
            this.inputJBossInstallDirecory.setText(file.getAbsolutePath());
        }
    }

    public static String getVersao() {
        return "1.5.7";
    }

    private boolean onConfirmDialog(Alert.AlertType alertType, String title, String text) {
        ButtonType buttonTypeResult;
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(text);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().add((Object)new ButtonType("Sim", ButtonBar.ButtonData.YES));
        alert.getButtonTypes().add((Object)new ButtonType("N\u00e3o", ButtonBar.ButtonData.NO));
        Optional result = alert.showAndWait();
        return result.isPresent() && (buttonTypeResult = (ButtonType)result.get()).getButtonData().equals((Object)ButtonBar.ButtonData.YES);
    }

    private boolean checkUpdateModulesJboss(ModuloWebFiorilli modulo, InstallJBossService installJBossService) {
        String key = modulo.getNome().split("-")[0];
        Integer versaoLimite = this.mapVersionControl.get(key);
        boolean updated = installJBossService.checkJbossModulesUpdated();
        return modulo.getVersaoDisponivelNumber().compareTo(versaoLimite) >= 0 && !updated;
    }

    private void checkConfigurationJboss() {
        final ProgressIndicator pin = this.pgin;
        InstaladorProgressBarFxImpl progress = new InstaladorProgressBarFxImpl((ProgressIndicator)this.pgbr);
        final InstallJBossService installJBossService = new InstallJBossService(this.getParams(), progress);
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainController.this.memo.clear();
                if (!installJBossService.checkArgumentXssJboss()) {
                    this.cancel();
                }
                return null;
            }

            protected void running() {
                super.running();
                pin.setProgress(-1.0);
                pin.setVisible(true);
            }

            protected void cancelled() {
                super.cancelled();
                pin.setVisible(false);
            }

            protected void succeeded() {
                super.succeeded();
                logger.info((Object)"Configura\u00e7\u00f5es atualizadas");
                pin.setVisible(false);
                if (MainController.this.onConfirmDialog(Alert.AlertType.WARNING, "Jboss", "As configura\u00e7\u00f5es do servidor Jboss foram ajustadas e ser\u00e1 necess\u00e1rio reinici\u00e1-lo.\nDeseja reiniciar agora?")) {
                    MainController.this.confirmRestartService();
                }
            }

            protected void failed() {
                super.failed();
                logger.info((Object)"Erro ao verificar configura\u00e7\u00f5es do Jboss");
                pin.setVisible(false);
            }
        };
        new Thread((Runnable)task).start();
    }

    private void confirmRestartService() {
        final ProgressIndicator pin = this.pgin;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                InstaladorProgressBarFxImpl progress = new InstaladorProgressBarFxImpl((ProgressIndicator)MainController.this.pgbr);
                InstallJBossService installJBossService = new InstallJBossService(MainController.this.getParams(), progress);
                installJBossService.restartService();
                return null;
            }

            protected void running() {
                super.running();
                pin.setProgress(-1.0);
                pin.setVisible(true);
                MainController.this.disableButtons(true);
            }

            protected void succeeded() {
                super.succeeded();
                pin.setVisible(false);
                MainController.this.disableButtons(false);
            }

            protected void failed() {
                super.failed();
                pin.setVisible(false);
                MainController.this.disableButtons(false);
            }
        };
        new Thread((Runnable)task).start();
    }

    private void disableButtons(boolean disable) {
        this.btnListarModulos.setDisable(disable);
        this.btnListarModulosBeta.setDisable(disable);
        this.btnLimpar.setDisable(disable);
    }
}

