/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.instalador.params;

import br.com.fiorilli.instalador.params.JBossMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;

public class Params {
    static Logger logger = Logger.getLogger(Params.class);
    private static final String IP_PATTERN = "^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String LOOP_BACK_NAME = "localhost";
    private static final String JBOSS_DEFAULT_DIR_UNIX = "/usr/share";
    private static final String JBOSS_DEFAULT_DIR_WINDOWS = "c:\\fiorilli";
    private static final String LOOP_BACK_IP = "127.0.0.1";
    private static final int JBOSSCLI_DEFAULT_PORT = 9999;
    private static final String SCPI_DEFAULT_WINDOWS_INI = "C:\\Fiorilli\\SCPI_8\\Scpi.ini";
    private static final String SCPI_DEFAULT_UNIX_INI = "/home/fiorilli/scpi_8/scpi.ini";
    private static final String SIP_DEFAULT_WINDOWS_INI = "C:\\Fiorilli\\SIP_7\\sipcon.ini";
    private static final String SIP_DEFAULT_UNIX_INI = "/home/fiorilli/sip_7/sipcon.ini";
    private static final String SIA_DEFAULT_WINDOWS_INI = "C:\\Fiorilli\\SIA7\\sia.ini";
    private static final String SIA_DEFAULT_UNIX_INI = "/home/fiorilli/sia7/sia.ini";
    private static Pattern pattern = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final String jbossIp;
    private final int jbossPort;
    private final String jbossDir;
    private final String scpiIni;
    private final String siaIni;
    private final String sipIni;
    private final boolean proxyUse;
    private final String proxyIp;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPasswd;
    private final String virtualHost;
    private final String downloadFilePath;
    private final String jdkDir;
    private final JBossMode jbossMode;
    private final boolean debug;
    private boolean removeOldDeploys;

    private static boolean validateIp(String ip) {
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static String getDefaultLoopBackIp() {
        return LOOP_BACK_IP;
    }

    public static int getDefaultJBossPort() {
        return 9999;
    }

    public static String getDefaultJBossDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return JBOSS_DEFAULT_DIR_WINDOWS;
        }
        return JBOSS_DEFAULT_DIR_UNIX;
    }

    public static String getDefaultScpiIni() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return SCPI_DEFAULT_WINDOWS_INI;
        }
        return SCPI_DEFAULT_UNIX_INI;
    }

    public static String getDefaultSiaIni() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return SIA_DEFAULT_WINDOWS_INI;
        }
        return SIA_DEFAULT_UNIX_INI;
    }

    public static String getDefaultSipIni() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return SIP_DEFAULT_WINDOWS_INI;
        }
        return SIP_DEFAULT_UNIX_INI;
    }

    public Params(String jbossIp, int jbossPort, String jbossUsr, String jbossPwd, String jbossDir, String scpiIni, String siaIni, String sipIni, boolean proxyUse, String proxyIp, int proxyPort, String proxyUser, String proxyPasswd, String virtualHost, String downloadFilePath, String jdkDir, JBossMode jbossMode, boolean debug, boolean removeOldDeploys) {
        if (LOOP_BACK_NAME.equalsIgnoreCase(jbossIp) || StringUtils.isEmpty((CharSequence)jbossIp)) {
            this.jbossIp = LOOP_BACK_IP;
        } else {
            if (!Params.validateIp(jbossIp)) {
                throw new IllegalArgumentException("IP do Servidor JBoss Inv\u00e1lido");
            }
            this.jbossIp = jbossIp;
        }
        this.jbossPort = jbossPort == 0 ? 9999 : jbossPort;
        this.jbossDir = StringUtils.isEmpty((CharSequence)jbossDir) ? (SystemUtils.IS_OS_WINDOWS ? JBOSS_DEFAULT_DIR_WINDOWS : JBOSS_DEFAULT_DIR_UNIX) : jbossDir;
        this.scpiIni = scpiIni == null ? Params.getDefaultScpiIni() : scpiIni;
        this.siaIni = siaIni == null ? Params.getDefaultSiaIni() : siaIni;
        this.sipIni = sipIni == null ? Params.getDefaultSipIni() : sipIni;
        this.proxyUse = proxyUse;
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPasswd = proxyPasswd;
        this.virtualHost = virtualHost;
        this.downloadFilePath = downloadFilePath;
        this.jdkDir = jdkDir;
        this.jbossMode = jbossMode == null ? JBossMode.STANDALONE : jbossMode;
        this.debug = debug;
        this.removeOldDeploys = removeOldDeploys;
    }

    public Params() {
        this(null, 0, null, null, null, null, null, null, false, null, 0, null, null, null, null, null, null, false, false);
    }

    public static String getLoopBackName() {
        return LOOP_BACK_NAME;
    }

    public static String getLoopBackIp() {
        return LOOP_BACK_IP;
    }

    public String getJbossIp() {
        return this.jbossIp;
    }

    public int getJbossPort() {
        return this.jbossPort;
    }

    public String getJbossDir() {
        return this.jbossDir;
    }

    public String getScpiIni() {
        return this.scpiIni;
    }

    public String getSiaIni() {
        return this.siaIni;
    }

    public String getSipIni() {
        return this.sipIni;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPasswd() {
        return this.proxyPasswd;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean isProxyUse() {
        return this.proxyUse;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getDownloadFilePath() {
        return this.downloadFilePath;
    }

    public String getJdkDir() {
        return this.jdkDir;
    }

    public JBossMode getJbossMode() {
        return this.jbossMode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isRemoveOldDeploys() {
        return this.removeOldDeploys;
    }

    public void setRemoveOldDeploys(boolean removeOldDeploys) {
        this.removeOldDeploys = removeOldDeploys;
    }
}

