/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Iterator;
import java.util.Objects;
import java.util.Tripwire;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public interface PrimitiveIterator<T, T_CONS>
extends Iterator<T> {
    public void forEachRemaining(T_CONS var1);

    public static interface OfDouble
    extends PrimitiveIterator<Double, DoubleConsumer> {
        public double nextDouble();

        @Override
        default public void forEachRemaining(DoubleConsumer doubleConsumer) {
            Objects.requireNonNull(doubleConsumer);
            while (this.hasNext()) {
                doubleConsumer.accept(this.nextDouble());
            }
        }

        @Override
        default public Double next() {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfDouble.nextLong()");
            }
            return this.nextDouble();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this.forEachRemaining((DoubleConsumer)((Object)consumer));
            } else {
                Objects.requireNonNull(consumer);
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfDouble.forEachRemainingDouble(action::accept)");
                }
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfInt
    extends PrimitiveIterator<Integer, IntConsumer> {
        public int nextInt();

        @Override
        default public void forEachRemaining(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            while (this.hasNext()) {
                intConsumer.accept(this.nextInt());
            }
        }

        @Override
        default public Integer next() {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfInt.nextInt()");
            }
            return this.nextInt();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)consumer));
            } else {
                Objects.requireNonNull(consumer);
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfInt.forEachRemainingInt(action::accept)");
                }
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfLong
    extends PrimitiveIterator<Long, LongConsumer> {
        public long nextLong();

        @Override
        default public void forEachRemaining(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            while (this.hasNext()) {
                longConsumer.accept(this.nextLong());
            }
        }

        @Override
        default public Long next() {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfLong.nextLong()");
            }
            return this.nextLong();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this.forEachRemaining((LongConsumer)((Object)consumer));
            } else {
                Objects.requireNonNull(consumer);
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling PrimitiveIterator.OfLong.forEachRemainingLong(action::accept)");
                }
                this.forEachRemaining(consumer::accept);
            }
        }
    }
}

