/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.Extension;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CertImpl;

class RevocationChecker
extends PKIXRevocationChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private TrustAnchor anchor;
    private PKIX.ValidatorParams params;
    private boolean onlyEE;
    private boolean softFail;
    private boolean crlDP;
    private URI responderURI;
    private X509Certificate responderCert;
    private List<CertStore> certStores;
    private Map<X509Certificate, byte[]> ocspResponses;
    private List<Extension> ocspExtensions;
    private boolean legacy;
    private LinkedList<CertPathValidatorException> softFailExceptions = new LinkedList();
    private X509Certificate issuerCert;
    private PublicKey prevPubKey;
    private boolean crlSignFlag;
    private int certIndex;
    private Mode mode = Mode.PREFER_OCSP;
    private static final long MAX_CLOCK_SKEW = 900000L;
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean[] CRL_SIGN_USAGE = new boolean[]{false, false, false, false, false, false, true};

    RevocationChecker() {
        this.legacy = false;
    }

    RevocationChecker(TrustAnchor trustAnchor, PKIX.ValidatorParams validatorParams) throws CertPathValidatorException {
        this.legacy = true;
        this.init(trustAnchor, validatorParams);
    }

    void init(TrustAnchor trustAnchor, PKIX.ValidatorParams validatorParams) throws CertPathValidatorException {
        block11: {
            RevocationProperties revocationProperties = RevocationChecker.getRevocationProperties();
            URI uRI = this.getOcspResponder();
            this.responderURI = uRI == null ? RevocationChecker.toURI(revocationProperties.ocspUrl) : uRI;
            X509Certificate x509Certificate = this.getOcspResponderCert();
            this.responderCert = x509Certificate == null ? RevocationChecker.getResponderCert(revocationProperties, validatorParams.trustAnchors(), validatorParams.certStores()) : x509Certificate;
            Set<PKIXRevocationChecker.Option> set = this.getOptions();
            block5: for (PKIXRevocationChecker.Option option : set) {
                switch (option) {
                    case ONLY_END_ENTITY: 
                    case PREFER_CRLS: 
                    case SOFT_FAIL: 
                    case NO_FALLBACK: {
                        continue block5;
                    }
                }
                throw new CertPathValidatorException("Unrecognized revocation parameter option: " + (Object)((Object)option));
            }
            this.softFail = set.contains((Object)PKIXRevocationChecker.Option.SOFT_FAIL);
            if (this.legacy) {
                this.mode = revocationProperties.ocspEnabled ? Mode.PREFER_OCSP : Mode.ONLY_CRLS;
                this.onlyEE = revocationProperties.onlyEE;
            } else {
                if (set.contains((Object)PKIXRevocationChecker.Option.NO_FALLBACK)) {
                    this.mode = set.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS) ? Mode.ONLY_CRLS : Mode.ONLY_OCSP;
                } else if (set.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS)) {
                    this.mode = Mode.PREFER_CRLS;
                }
                this.onlyEE = set.contains((Object)PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            this.crlDP = this.legacy ? revocationProperties.crlDPEnabled : true;
            this.ocspResponses = this.getOcspResponses();
            this.ocspExtensions = this.getOcspExtensions();
            this.anchor = trustAnchor;
            this.params = validatorParams;
            this.certStores = new ArrayList<CertStore>(validatorParams.certStores());
            try {
                this.certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(validatorParams.certificates())));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                if (debug == null) break block11;
                debug.println("RevocationChecker: error creating Collection CertStore: " + generalSecurityException);
            }
        }
    }

    private static URI toURI(String string) throws CertPathValidatorException {
        try {
            if (string != null) {
                return new URI(string);
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CertPathValidatorException("cannot parse ocsp.responderURL property", uRISyntaxException);
        }
    }

    private static RevocationProperties getRevocationProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<RevocationProperties>(){

            @Override
            public RevocationProperties run() {
                RevocationProperties revocationProperties = new RevocationProperties();
                String string = Security.getProperty("com.sun.security.onlyCheckRevocationOfEECert");
                revocationProperties.onlyEE = string != null && string.equalsIgnoreCase("true");
                String string2 = Security.getProperty("ocsp.enable");
                revocationProperties.ocspEnabled = string2 != null && string2.equalsIgnoreCase("true");
                revocationProperties.ocspUrl = Security.getProperty("ocsp.responderURL");
                revocationProperties.ocspSubject = Security.getProperty("ocsp.responderCertSubjectName");
                revocationProperties.ocspIssuer = Security.getProperty("ocsp.responderCertIssuerName");
                revocationProperties.ocspSerial = Security.getProperty("ocsp.responderCertSerialNumber");
                revocationProperties.crlDPEnabled = Boolean.getBoolean("com.sun.security.enableCRLDP");
                return revocationProperties;
            }
        });
    }

    private static X509Certificate getResponderCert(RevocationProperties revocationProperties, Set<TrustAnchor> set, List<CertStore> list) throws CertPathValidatorException {
        if (revocationProperties.ocspSubject != null) {
            return RevocationChecker.getResponderCert(revocationProperties.ocspSubject, set, list);
        }
        if (revocationProperties.ocspIssuer != null && revocationProperties.ocspSerial != null) {
            return RevocationChecker.getResponderCert(revocationProperties.ocspIssuer, revocationProperties.ocspSerial, set, list);
        }
        if (revocationProperties.ocspIssuer != null || revocationProperties.ocspSerial != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        return null;
    }

    private static X509Certificate getResponderCert(String string, Set<TrustAnchor> set, List<CertStore> list) throws CertPathValidatorException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(new X500Principal(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSubjectName property", illegalArgumentException);
        }
        return RevocationChecker.getResponderCert(x509CertSelector, set, list);
    }

    private static X509Certificate getResponderCert(String string, String string2, Set<TrustAnchor> set, List<CertStore> list) throws CertPathValidatorException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setIssuer(new X500Principal(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertIssuerName property", illegalArgumentException);
        }
        try {
            x509CertSelector.setSerialNumber(new BigInteger(RevocationChecker.stripOutSeparators(string2), 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CertPathValidatorException("cannot parse ocsp.responderCertSerialNumber property", numberFormatException);
        }
        return RevocationChecker.getResponderCert(x509CertSelector, set, list);
    }

    private static X509Certificate getResponderCert(X509CertSelector x509CertSelector, Set<TrustAnchor> set, List<CertStore> list) throws CertPathValidatorException {
        Collection<? extends Certificate> collection;
        for (TrustAnchor object : set) {
            collection = object.getTrustedCert();
            if (collection == null || !x509CertSelector.match((Certificate)((Object)collection))) continue;
            return collection;
        }
        for (CertStore certStore : list) {
            try {
                collection = certStore.getCertificates(x509CertSelector);
                if (collection.isEmpty()) continue;
                return (X509Certificate)collection.iterator().next();
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("CertStore exception:" + certStoreException);
            }
        }
        throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        if (this.anchor != null) {
            this.issuerCert = this.anchor.getTrustedCert();
            this.prevPubKey = this.issuerCert != null ? this.issuerCert.getPublicKey() : this.anchor.getCAPublicKey();
        }
        this.crlSignFlag = true;
        this.certIndex = this.params != null && this.params.certPath() != null ? this.params.certPath().getCertificates().size() - 1 : -1;
        this.softFailExceptions.clear();
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public List<CertPathValidatorException> getSoftFailExceptions() {
        return Collections.unmodifiableList(this.softFailExceptions);
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        this.check((X509Certificate)certificate, collection, this.prevPubKey, this.crlSignFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void check(X509Certificate x509Certificate, Collection<String> collection, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        if (debug != null) {
            debug.println("RevocationChecker.check: checking cert\n  SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + "\n  Issuer: " + x509Certificate.getIssuerX500Principal());
        }
        try {
            if (this.onlyEE && x509Certificate.getBasicConstraints() != -1) {
                if (debug == null) return;
                debug.println("Skipping revocation check; cert is not an end entity cert");
                return;
            }
            switch (this.mode) {
                case PREFER_OCSP: 
                case ONLY_OCSP: {
                    this.checkOCSP(x509Certificate, collection);
                    return;
                }
                case PREFER_CRLS: 
                case ONLY_CRLS: {
                    this.checkCRLs(x509Certificate, collection, null, publicKey, bl);
                    return;
                }
            }
            return;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                throw certPathValidatorException;
            }
            boolean bl2 = this.isSoftFailException(certPathValidatorException);
            if (bl2) {
                if (this.mode == Mode.ONLY_OCSP) return;
                if (this.mode == Mode.ONLY_CRLS) {
                    return;
                }
            } else {
                if (this.mode == Mode.ONLY_OCSP) throw certPathValidatorException;
                if (this.mode == Mode.ONLY_CRLS) {
                    throw certPathValidatorException;
                }
            }
            CertPathValidatorException certPathValidatorException2 = certPathValidatorException;
            if (debug != null) {
                debug.println("RevocationChecker.check() " + certPathValidatorException.getMessage());
                debug.println("RevocationChecker.check() preparing to failover");
            }
            try {
                switch (this.mode) {
                    case PREFER_OCSP: {
                        this.checkCRLs(x509Certificate, collection, null, publicKey, bl);
                        return;
                    }
                    case PREFER_CRLS: {
                        this.checkOCSP(x509Certificate, collection);
                        return;
                    }
                }
                return;
            }
            catch (CertPathValidatorException certPathValidatorException3) {
                if (debug != null) {
                    debug.println("RevocationChecker.check() failover failed");
                    debug.println("RevocationChecker.check() " + certPathValidatorException3.getMessage());
                }
                if (certPathValidatorException3.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                    throw certPathValidatorException3;
                }
                if (!this.isSoftFailException(certPathValidatorException3)) {
                    certPathValidatorException2.addSuppressed(certPathValidatorException3);
                    throw certPathValidatorException2;
                }
                if (bl2) return;
                throw certPathValidatorException2;
            }
        }
        finally {
            this.updateState(x509Certificate);
        }
    }

    private boolean isSoftFailException(CertPathValidatorException certPathValidatorException) {
        if (this.softFail && certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
            CertPathValidatorException certPathValidatorException2 = new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), this.params.certPath(), this.certIndex, certPathValidatorException.getReason());
            this.softFailExceptions.addFirst(certPathValidatorException2);
            return true;
        }
        return false;
    }

    private void updateState(X509Certificate x509Certificate) throws CertPathValidatorException {
        this.issuerCert = x509Certificate;
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (PKIX.isDSAPublicKeyWithoutParams(publicKey)) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.prevPubKey);
        }
        this.prevPubKey = publicKey;
        this.crlSignFlag = RevocationChecker.certCanSignCrl(x509Certificate);
        if (this.certIndex > 0) {
            --this.certIndex;
        }
    }

    private void checkCRLs(X509Certificate x509Certificate, Collection<String> collection, Set<X509Certificate> set, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        this.checkCRLs(x509Certificate, publicKey, null, bl, true, set, this.params.trustAnchors());
    }

    private void checkCRLs(X509Certificate x509Certificate, PublicKey publicKey, X509Certificate x509Certificate2, boolean bl, boolean bl2, Set<X509Certificate> set, Set<TrustAnchor> set2) throws CertPathValidatorException {
        Object object;
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() ---checking revocation status ...");
        }
        if (set != null && set.contains(x509Certificate)) {
            if (debug != null) {
                debug.println("RevocationChecker.checkCRLs() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        HashSet<X509CRL> hashSet2 = new HashSet<X509CRL>();
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.setCertificateChecking(x509Certificate);
        CertPathHelper.setDateAndTime(x509CRLSelector, this.params.date(), 900000L);
        CertPathValidatorException certPathValidatorException = null;
        for (CertStore certStore : this.certStores) {
            try {
                object = certStore.getCRLs(x509CRLSelector).iterator();
                while (object.hasNext()) {
                    CRL cRL = object.next();
                    hashSet.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException certStoreException) {
                if (debug != null) {
                    debug.println("RevocationChecker.checkCRLs() CertStoreException: " + certStoreException.getMessage());
                }
                if (certPathValidatorException != null || !CertStoreHelper.isCausedByNetworkIssue(certStore.getType(), certStoreException)) continue;
                certPathValidatorException = new CertPathValidatorException("Unable to determine revocation status due to network error", certStoreException, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() possible crls.size() = " + hashSet.size());
        }
        Object object2 = new boolean[9];
        if (!hashSet.isEmpty()) {
            hashSet2.addAll(this.verifyPossibleCRLs(hashSet, x509Certificate, publicKey, bl, (boolean[])object2, set2));
        }
        if (debug != null) {
            debug.println("RevocationChecker.checkCRLs() approved crls.size() = " + hashSet2.size());
        }
        if (!hashSet2.isEmpty() && Arrays.equals((boolean[])object2, ALL_REASONS)) {
            this.checkApprovedCRLs(x509Certificate, hashSet2);
        } else {
            try {
                if (this.crlDP) {
                    hashSet2.addAll(DistributionPointFetcher.getCRLs(x509CRLSelector, bl, publicKey, x509Certificate2, this.params.sigProvider(), this.certStores, (boolean[])object2, set2, null));
                }
            }
            catch (CertStoreException certStoreException) {
                if (certStoreException instanceof PKIX.CertStoreTypeException && CertStoreHelper.isCausedByNetworkIssue(((PKIX.CertStoreTypeException)(object = (PKIX.CertStoreTypeException)certStoreException)).getType(), certStoreException)) {
                    throw new CertPathValidatorException("Unable to determine revocation status due to network error", certStoreException, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                }
                throw new CertPathValidatorException(certStoreException);
            }
            if (!hashSet2.isEmpty() && Arrays.equals((boolean[])object2, ALL_REASONS)) {
                this.checkApprovedCRLs(x509Certificate, hashSet2);
            } else {
                if (bl2) {
                    try {
                        this.verifyWithSeparateSigningKey(x509Certificate, publicKey, bl, set);
                        return;
                    }
                    catch (CertPathValidatorException certPathValidatorException2) {
                        if (certPathValidatorException != null) {
                            throw certPathValidatorException;
                        }
                        throw certPathValidatorException2;
                    }
                }
                if (certPathValidatorException != null) {
                    throw certPathValidatorException;
                }
                throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
        }
    }

    private void checkApprovedCRLs(X509Certificate x509Certificate, Set<X509CRL> set) throws CertPathValidatorException {
        Object object;
        if (debug != null) {
            object = x509Certificate.getSerialNumber();
            debug.println("RevocationChecker.checkApprovedCRLs() starting the final sweep...");
            debug.println("RevocationChecker.checkApprovedCRLs() cert SN: " + ((BigInteger)object).toString());
        }
        object = CRLReason.UNSPECIFIED;
        X509CRLEntryImpl x509CRLEntryImpl = null;
        for (X509CRL x509CRL : set) {
            Date date;
            Set<String> set2;
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
            if (x509CRLEntry == null) continue;
            try {
                x509CRLEntryImpl = X509CRLEntryImpl.toImpl(x509CRLEntry);
            }
            catch (CRLException cRLException) {
                throw new CertPathValidatorException(cRLException);
            }
            if (debug != null) {
                debug.println("RevocationChecker.checkApprovedCRLs() CRL entry: " + x509CRLEntryImpl.toString());
            }
            if ((set2 = x509CRLEntryImpl.getCriticalExtensionOIDs()) != null && !set2.isEmpty()) {
                set2.remove(PKIXExtensions.ReasonCode_Id.toString());
                set2.remove(PKIXExtensions.CertificateIssuer_Id.toString());
                if (!set2.isEmpty()) {
                    throw new CertPathValidatorException("Unrecognized critical extension(s) in revoked CRL entry");
                }
            }
            if ((object = x509CRLEntryImpl.getRevocationReason()) == null) {
                object = CRLReason.UNSPECIFIED;
            }
            if (!(date = x509CRLEntryImpl.getRevocationDate()).before(this.params.date())) continue;
            CertificateRevokedException certificateRevokedException = new CertificateRevokedException(date, (CRLReason)((Object)object), x509CRL.getIssuerX500Principal(), x509CRLEntryImpl.getExtensions());
            throw new CertPathValidatorException(((Throwable)certificateRevokedException).getMessage(), certificateRevokedException, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
    }

    private void checkOCSP(X509Certificate x509Certificate, Collection<String> collection) throws CertPathValidatorException {
        Object object;
        Object object2;
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        OCSPResponse oCSPResponse = null;
        CertId certId = null;
        try {
            certId = this.issuerCert != null ? new CertId(this.issuerCert, x509CertImpl.getSerialNumberObject()) : new CertId(this.anchor.getCA(), this.anchor.getCAPublicKey(), x509CertImpl.getSerialNumberObject());
            object2 = this.ocspResponses.get(x509Certificate);
            if (object2 != null) {
                if (debug != null) {
                    debug.println("Found cached OCSP response");
                }
                oCSPResponse = new OCSPResponse((byte[])object2);
                object = null;
                for (Extension object3 : this.ocspExtensions) {
                    if (!object3.getId().equals("1.3.6.1.5.5.7.48.1.2")) continue;
                    object = object3.getValue();
                }
                oCSPResponse.verify(Collections.singletonList(certId), this.issuerCert, this.responderCert, this.params.date(), (byte[])object);
            } else {
                Object object3 = object = this.responderURI != null ? this.responderURI : OCSP.getResponderURI(x509CertImpl);
                if (object == null) {
                    throw new CertPathValidatorException("Certificate does not specify OCSP responder", null, null, -1);
                }
                oCSPResponse = OCSP.check(Collections.singletonList(certId), (URI)object, this.issuerCert, this.responderCert, null, this.ocspExtensions);
            }
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", iOException, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        object2 = oCSPResponse.getSingleResponse(certId);
        object = object2.getCertStatus();
        if (object == OCSP.RevocationStatus.CertStatus.REVOKED) {
            Date date = object2.getRevocationTime();
            if (date.before(this.params.date())) {
                CertificateRevokedException certificateRevokedException = new CertificateRevokedException(date, object2.getRevocationReason(), oCSPResponse.getSignerCertificate().getSubjectX500Principal(), object2.getSingleExtensions());
                throw new CertPathValidatorException(((Throwable)certificateRevokedException).getMessage(), certificateRevokedException, null, -1, CertPathValidatorException.BasicReason.REVOKED);
            }
        } else if (object == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
            throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.params.certPath(), -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (HEX_DIGITS.indexOf(cArray[i]) == -1) continue;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    static boolean certCanSignCrl(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            return blArray[6];
        }
        return false;
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> set, X509Certificate x509Certificate, PublicKey publicKey, boolean bl, boolean[] blArray, Set<TrustAnchor> set2) throws CertPathValidatorException {
        try {
            Object object;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("RevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension();
            List<Object> list = null;
            if (cRLDistributionPointsExtension == null) {
                object = (X500Name)x509CertImpl.getIssuerDN();
                DistributionPoint distributionPoint = new DistributionPoint(new GeneralNames().add(new GeneralName((GeneralNameInterface)object)), null, null);
                list = Collections.singletonList(distributionPoint);
            } else {
                list = cRLDistributionPointsExtension.get("points");
            }
            object = new HashSet();
            for (DistributionPoint distributionPoint : list) {
                for (X509CRL x509CRL : set) {
                    if (!DistributionPointFetcher.verifyCRL(x509CertImpl, distributionPoint, x509CRL, blArray, bl, publicKey, null, this.params.sigProvider(), set2, this.certStores, this.params.date())) continue;
                    object.add(x509CRL);
                }
                if (!Arrays.equals(blArray, ALL_REASONS)) continue;
                break;
            }
            return object;
        }
        catch (IOException | CRLException | CertificateException exception) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + exception.getMessage());
                exception.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    private void verifyWithSeparateSigningKey(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, Set<X509Certificate> set) throws CertPathValidatorException {
        String string = "revocation status";
        if (debug != null) {
            debug.println("RevocationChecker.verifyWithSeparateSigningKey() ---checking " + string + "...");
        }
        if (set != null && set.contains(x509Certificate)) {
            if (debug != null) {
                debug.println("RevocationChecker.verifyWithSeparateSigningKey() circular dependency");
            }
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        if (!bl) {
            this.buildToNewKey(x509Certificate, null, set);
        } else {
            this.buildToNewKey(x509Certificate, publicKey, set);
        }
    }

    private void buildToNewKey(X509Certificate x509Certificate, PublicKey publicKey, Set<X509Certificate> set) throws CertPathValidatorException {
        List<? extends Certificate> list;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PKIXBuilderParameters pKIXBuilderParameters;
        if (debug != null) {
            debug.println("RevocationChecker.buildToNewKey() starting work");
        }
        HashSet<PublicKey> hashSet = new HashSet<PublicKey>();
        if (publicKey != null) {
            hashSet.add(publicKey);
        }
        RejectKeySelector rejectKeySelector = new RejectKeySelector(hashSet);
        rejectKeySelector.setSubject(x509Certificate.getIssuerX500Principal());
        rejectKeySelector.setKeyUsage(CRL_SIGN_USAGE);
        Set<TrustAnchor> set2 = this.anchor == null ? this.params.trustAnchors() : Collections.singleton(this.anchor);
        try {
            pKIXBuilderParameters = new PKIXBuilderParameters(set2, (CertSelector)rejectKeySelector);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
        pKIXBuilderParameters.setInitialPolicies(this.params.initialPolicies());
        pKIXBuilderParameters.setCertStores(this.certStores);
        pKIXBuilderParameters.setExplicitPolicyRequired(this.params.explicitPolicyRequired());
        pKIXBuilderParameters.setPolicyMappingInhibited(this.params.policyMappingInhibited());
        pKIXBuilderParameters.setAnyPolicyInhibited(this.params.anyPolicyInhibited());
        pKIXBuilderParameters.setDate(this.params.date());
        pKIXBuilderParameters.setCertPathCheckers(this.params.getPKIXParameters().getCertPathCheckers());
        pKIXBuilderParameters.setSigProvider(this.params.sigProvider());
        pKIXBuilderParameters.setRevocationEnabled(false);
        if (Builder.USE_AIA) {
            block30: {
                object4 = null;
                try {
                    object4 = X509CertImpl.toImpl(x509Certificate);
                }
                catch (CertificateException certificateException) {
                    if (debug == null) break block30;
                    debug.println("RevocationChecker.buildToNewKey: error decoding cert: " + certificateException);
                }
            }
            object3 = null;
            if (object4 != null) {
                object3 = ((X509CertImpl)object4).getAuthorityInfoAccessExtension();
            }
            if (object3 != null && (object2 = ((AuthorityInfoAccessExtension)object3).getAccessDescriptions()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    AccessDescription accessDescription = object.next();
                    list = URICertStore.getInstance(accessDescription);
                    if (list == null) continue;
                    if (debug != null) {
                        debug.println("adding AIAext CertStore");
                    }
                    pKIXBuilderParameters.addCertStore((CertStore)((Object)list));
                }
            }
        }
        object4 = null;
        try {
            object4 = CertPathBuilder.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        try {
            while (true) {
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to try build ...");
                }
                object3 = (PKIXCertPathBuilderResult)((CertPathBuilder)object4).build(pKIXBuilderParameters);
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() about to check revocation ...");
                }
                if (set == null) {
                    set = new HashSet<X509Certificate>();
                }
                set.add(x509Certificate);
                object2 = ((PKIXCertPathValidatorResult)object3).getTrustAnchor();
                object = ((TrustAnchor)object2).getCAPublicKey();
                if (object == null) {
                    object = ((TrustAnchor)object2).getTrustedCert().getPublicKey();
                }
                boolean bl = true;
                list = ((PKIXCertPathBuilderResult)object3).getCertPath().getCertificates();
                if (list.isEmpty()) {
                    return;
                }
                try {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        X509Certificate x509Certificate2 = (X509Certificate)list.get(i);
                        if (debug != null) {
                            debug.println("RevocationChecker.buildToNewKey() index " + i + " checking " + x509Certificate2);
                        }
                        this.checkCRLs(x509Certificate2, (PublicKey)object, null, bl, true, set, set2);
                        bl = RevocationChecker.certCanSignCrl(x509Certificate2);
                        object = x509Certificate2.getPublicKey();
                    }
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    hashSet.add(((PKIXCertPathValidatorResult)object3).getPublicKey());
                    continue;
                }
                if (debug != null) {
                    debug.println("RevocationChecker.buildToNewKey() got key " + ((PKIXCertPathValidatorResult)object3).getPublicKey());
                }
                PublicKey publicKey2 = ((PKIXCertPathValidatorResult)object3).getPublicKey();
                try {
                    this.checkCRLs(x509Certificate, publicKey2, (X509Certificate)list.get(0), true, false, null, this.params.trustAnchors());
                    return;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                        throw certPathValidatorException;
                    }
                    hashSet.add(publicKey2);
                    continue;
                }
                break;
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CertPathValidatorException(invalidAlgorithmParameterException);
        }
        catch (CertPathBuilderException certPathBuilderException) {
            throw new CertPathValidatorException("Could not determine revocation status", null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    @Override
    public RevocationChecker clone() {
        RevocationChecker revocationChecker = (RevocationChecker)super.clone();
        revocationChecker.softFailExceptions = new LinkedList<CertPathValidatorException>(this.softFailExceptions);
        return revocationChecker;
    }

    private static enum Mode {
        PREFER_OCSP,
        PREFER_CRLS,
        ONLY_CRLS,
        ONLY_OCSP;

    }

    private static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Set<PublicKey> set) {
            this.badKeySet = set;
        }

        @Override
        public boolean match(Certificate certificate) {
            if (!super.match(certificate)) {
                return false;
            }
            if (this.badKeySet.contains(certificate.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectKeySelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectKeySelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RejectKeySelector: [\n");
            stringBuilder.append(super.toString());
            stringBuilder.append(this.badKeySet);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private static class RevocationProperties {
        boolean onlyEE;
        boolean ocspEnabled;
        boolean crlDPEnabled;
        String ocspUrl;
        String ocspSubject;
        String ocspIssuer;
        String ocspSerial;

        private RevocationProperties() {
        }
    }
}

