/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.client;

import br.com.fiorilli.nfse_nacional.client.ServicosTokenHolder;
import br.com.fiorilli.nfse_nacional.client.ServicosWebClient;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.GrContribuinteDTO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.LiMobilDTO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.Token;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;

public class ServicosWebClientAuthWrapper
implements ServicosWebClient {
    private static final Logger log = LoggerFactory.getLogger(ServicosWebClientAuthWrapper.class);
    @Value(value="${br.com.fiorilli.servicosweb.auth-key}")
    private String key;
    private final ServicosWebClient wrapped;
    private final ServicosTokenHolder servicosTokenHolder;

    public ResponseEntity<String> checkConnection() {
        return this.wrapped.checkConnection();
    }

    public synchronized ResponseEntity<GrContribuinteDTO> cadastrarContribuinte(GrContribuinteDTO grContribuinteDTO) {
        this.checkAuth();
        return this.wrapped.cadastrarContribuinte(grContribuinteDTO);
    }

    public synchronized ResponseEntity<LiMobilDTO> cadastrarEmpresa(LiMobilDTO liMobilDTO) {
        this.checkAuth();
        return this.wrapped.cadastrarEmpresa(liMobilDTO);
    }

    public ResponseEntity<Token> authenticate(String key) {
        return this.wrapped.authenticate(key);
    }

    private void checkAuth() {
        log.trace("Verificando auth do servicosweb...");
        if (this.servicosTokenHolder.getToken() != null && !this.servicosTokenHolder.isExpired()) {
            log.debug("Token valido");
            return;
        }
        log.trace("Token invalido, fazendo autenticacao...");
        this.servicosTokenHolder.setMoment(Instant.now());
        ResponseEntity tokenRes = this.authenticate(this.key);
        if (tokenRes == null) {
            throw new FiorilliException("N\u00e3o foi poss\u00edvel fazer a autentica\u00e7\u00e3o no servicosweb");
        }
        Token body = (Token)tokenRes.getBody();
        if (body == null) {
            throw new FiorilliException("N\u00e3o foi poss\u00edvel fazer a autentica\u00e7\u00e3o no servicosweb");
        }
        log.trace("Autenticado, salvando token...");
        this.servicosTokenHolder.setToken(body.access());
    }

    public ServicosWebClientAuthWrapper(ServicosWebClient wrapped, ServicosTokenHolder servicosTokenHolder) {
        this.wrapped = wrapped;
        this.servicosTokenHolder = servicosTokenHolder;
    }
}

