/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.client;

import br.com.fiorilli.nfse_nacional.client.ServicosTokenHolder;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.RequestInterceptor;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServicosWebClientConfig {
    private static final Logger log = LoggerFactory.getLogger(ServicosWebClientConfig.class);
    private final List<String> allowedPaths = List.of("/autenticacao/autorizar", "/service/checkConnection");

    @Bean
    Client client() {
        return new Client.Default(ServicosWebClientConfig.getDefaultSSLSocketFactory(), ServicosWebClientConfig.getHostnameVerifier());
    }

    @Bean
    RequestInterceptor interceptor(ServicosTokenHolder tokenHolder) {
        return request -> {
            if (!this.allowedPaths.contains(request.path())) {
                request.header("Authorization", new String[]{"Bearer " + tokenHolder.getToken()});
            }
        };
    }

    @Bean
    ErrorDecoder errorDecoder(ObjectMapper jacksonObjectMapper) {
        return (methodKey, response) -> {
            String errorResponse;
            try {
                StringBuilder sb = new StringBuilder();
                Reader reader = response.body().asReader(response.charset());
                char[] buffer = new char[1024];
                while (reader.read(buffer) != -1) {
                    sb.append(buffer);
                }
                errorResponse = sb.toString();
            }
            catch (IOException e) {
                log.error("Erro ao ler resposta: {}", (Object)e, (Object)e);
                errorResponse = null;
            }
            log.info("\n--- ERRO SERVICOSWEB CLIENT --------------------------------------------------------------------\n{}\n{}\n\n{}\n------------------------------------------------------------------------------------------------\n", new Object[]{response.status(), response.headers().entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(value -> MessageFormat.format("{0}: {1}", entry.getKey(), value))).collect(Collectors.joining("\n")), errorResponse});
            FiorilliException exception = new FiorilliException("Erro na resposta da api de servi\u00e7os, verifique", HttpStatus.resolve((int)response.status()));
            try {
                exception.jsonError(jacksonObjectMapper.readTree(errorResponse));
            }
            catch (JsonProcessingException e) {
                log.error("N\u00e3o foi poss\u00edvel ler json de resposta", (Throwable)e);
            }
            return exception;
        };
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, ServicosWebClientConfig.getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static TrustManager[] getTrustManager() {
        return new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
    }

    public static HostnameVerifier getHostnameVerifier() {
        return (s, sslSession) -> true;
    }
}

