/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.config;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.ShutdownSignalException;
import br.com.fiorilli.nfse_nacional.schema.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.evento.TCPedRegEvt;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.services.EmpresaService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableCaching
public class AppConfig {
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    @Value(value="${br.com.fiorilli.nfse.threads-processamento}")
    private int threadsConfig;

    @Bean
    @Primary
    ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        return builder.build();
    }

    @Bean
    @Qualifier(value="XML")
    XmlMapper xmlMapper() {
        return (XmlMapper)XmlMapper.xmlBuilder().build();
    }

    @Bean
    EntidadeVO beanEntidade(EmpresaService empresaService) {
        log.trace("Montando bean de entidade...");
        return empresaService.loadConfigs();
    }

    @Bean
    ObjectFactory xmlFactory() {
        return new ObjectFactory();
    }

    @Bean
    Jaxb2Marshaller NFSeMarshaller() {
        log.trace("Montando bean do marshaller de NFSe...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCNFSe.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.nfse", "br.com.fiorilli.nfse_nacional.schema.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller DPSMarshaller() {
        log.trace("Montando bean do marshaller de DPS...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCDPS.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.nfse", "br.com.fiorilli.nfse_nacional.schema.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller EventoMarshaller() {
        log.trace("Montando bean do marshaller de Evento...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCEvento.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.evento", "br.com.fiorilli.nfse_nacional.schema.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller PedRegEventoMarshaller() {
        log.trace("Montando bean do marshaller de Pedido de Registro de Evento...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCPedRegEvt.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.evento", "br.com.fiorilli.nfse_nacional.schema.common"});
        return marshaller;
    }

    @Bean
    ExecutorService nfseExecutor() {
        if (this.threadsConfig > 25) {
            log.error("\n\n\n########################################################################################################\n ERRO: \u00e9 permitido configurar no m\u00e1ximo 25 threads para execu\u00e7\u00e3o paralela nesta vers\u00e3o do nfse-nacional\n Ajuste o n\u00famero para menor ou igual a 25 para iniciar o servi\u00e7o corretamente\n########################################################################################################\n\n");
            throw new IllegalStateException("M\u00e1ximo 25 threads permitido!");
        }
        CustomizableThreadFactory factory = new CustomizableThreadFactory();
        factory.setThreadNamePrefix("nfx-th-");
        int nThreads = this.threadsConfig > 0 ? this.threadsConfig : Math.min(Runtime.getRuntime().availableProcessors(), 20);
        return Executors.newFixedThreadPool(nThreads, (ThreadFactory)factory);
    }

    @Bean
    TaskScheduler nfseTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setErrorHandler(t -> {
            if (t instanceof ShutdownSignalException) {
                log.error("Erro de shutdown detectado. Encerrando agendador de tarefas!");
                scheduler.shutdown();
            }
            log.error("Erro ao executar o task scheduler!", t);
        });
        return scheduler;
    }
}

