/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.dto;

import br.com.fiorilli.nfse_nacional.dto.NotaEnvioVO;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiServicoNbs;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.model.enums.RegimeEspecialTributacao;
import br.com.fiorilli.nfse_nacional.model.enums.ResponsavelRetencao;
import br.com.fiorilli.nfse_nacional.model.enums.SimNao;
import br.com.fiorilli.nfse_nacional.model.enums.TributacaoIssqn;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoSimplesNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoImunidadeIssqn;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoRetencaoISSQN;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import java.time.LocalDateTime;

public class NotaEnvioVO {
    private LiNotafiscal liNotafiscal;
    private LiMobil liMobil;
    private GrContribuintes grContribuintes;
    private Municipio municipioCadstro;

    public boolean isOptanteSimples() {
        if (this.liMobil != null) {
            return "S".equals(this.liMobil.getOptanteSimplesMbl());
        }
        if (this.grContribuintes != null) {
            return this.grContribuintes.getOptantesimplesCnt() == SimNao.SIM;
        }
        throw new IllegalStateException("Nenhum prestador para a nota!");
    }

    public SituacaoSimplesNacional optanteSimples() {
        if (this.isOptanteSimples()) {
            if (this.getLiMobil().getRegimeespecialtribMbl() == RegimeEspecialTributacao.MEI) {
                return SituacaoSimplesNacional.OPTANTE_MEI;
            }
            if (this.getLiMobil().getRegimeespecialtribMbl() == RegimeEspecialTributacao.EPP || this.getLiMobil().getRegimeespecialtribMbl() == RegimeEspecialTributacao.ME) {
                return SituacaoSimplesNacional.OPTANTE_MEEPP;
            }
        }
        return SituacaoSimplesNacional.NAO_OPTANTE;
    }

    public TipoRetencaoISSQN tipoRetencaoISSQN() {
        if (this.liNotafiscal.getImpostoretidoNfs() == SimNao.SIM) {
            if (this.liNotafiscal.getResponsavelretencaoNfs() == ResponsavelRetencao.TOMADOR) {
                return TipoRetencaoISSQN.RETIDO_TOMADOR;
            }
            if (this.liNotafiscal.getResponsavelretencaoNfs() == ResponsavelRetencao.INTERMEDIARIO) {
                return TipoRetencaoISSQN.RETIDO_INTERMEDIARIO;
            }
        }
        return TipoRetencaoISSQN.NAO_RETIDO;
    }

    public double valorServico() {
        return this.liNotafiscal.getItemServico().getValorNfi();
    }

    public double aliquota() {
        return this.liNotafiscal.getItemServico().getAliquotaNfi();
    }

    public double descontoCondicional() {
        return this.liNotafiscal.getItemServico().getDesccondicionalNfi();
    }

    public double descontoIncondicional() {
        return this.liNotafiscal.getItemServico().getDescincondicionalNfi();
    }

    public double deducoes() {
        return this.liNotafiscal.getItemServico().getDeducaobaseNfi();
    }

    public String getCodigoTributacao() {
        if (BuildXmlUtils.strip((String)this.liNotafiscal.getItemServico().getCodleiLc116Nfi()).length() > 5) {
            return this.liNotafiscal.getItemServico().getCodleiLc116Nfi();
        }
        return BuildXmlUtils.strip((String)this.liNotafiscal.getItemServico().getCodleiLc116Nfi()).replace(".", "").concat("01");
    }

    public String getDescricaoTributacao() {
        return this.liNotafiscal.getItemServico().getDescatvLc116Nfi();
    }

    public String getCodigoNBS() {
        LiServicoNbs servicoNbs = this.liNotafiscal.getItemServico().getLiServicoNbs();
        return servicoNbs == null ? null : servicoNbs.getCodSnb();
    }

    public String getDescricaoNBS() {
        LiServicoNbs liServicoNbs = this.liNotafiscal.getItemServico().getLiServicoNbs();
        return liServicoNbs == null ? null : liServicoNbs.getDescricaoSnb();
    }

    public String getDescricaoServico() {
        return this.liNotafiscal.getItemServico().getDescriNfi();
    }

    public String getCepCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getCepiMbl().replace("\\D", "");
        }
        return this.grContribuintes.getCepCnt().replaceAll("\\D", "");
    }

    public String getCodCidCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getCodCidMbl();
        }
        return this.grContribuintes.getCodCidCnt();
    }

    public String getLogradouroCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getGrLogra() != null ? this.liMobil.getGrLogra().getNomeLog() : this.liMobil.getLograMbl();
        }
        return this.grContribuintes.getNomLogCnt();
    }

    public String getNroEndCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getNumeroMbl();
        }
        return this.grContribuintes.getNumeroCnt();
    }

    public String getComplEndCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getCompleMbl();
        }
        return this.grContribuintes.getCompleCnt();
    }

    public String getBairroCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getGrBairro() != null ? this.liMobil.getGrBairro().getNomeBai() : this.liMobil.getBairroMbl();
        }
        return this.grContribuintes.getNomBaiCnt();
    }

    public String getFoneCadastro() {
        return this.grContribuintes.getFoneCnt();
    }

    public String getEmailCadastro() {
        return this.grContribuintes.getEmailCnt();
    }

    public String getInscricaoMunicipalCadastro() {
        if (this.liMobil != null) {
            return this.liMobil.getInscrmMbl();
        }
        return this.grContribuintes.getInscrmunCnt();
    }

    public LocalDateTime getDataHoraEmissao() {
        return this.liNotafiscal.getDataemissaoNfs().atTime(this.liNotafiscal.getHoraemissaoNfs());
    }

    public boolean isPisConfins() {
        return this.liNotafiscal.getValorpisNfs() != null && this.liNotafiscal.getValorpisNfs() > 0.0 && this.liNotafiscal.getValorcofinsNfs() != null && this.liNotafiscal.getValorcofinsNfs() > 0.0;
    }

    public TributacaoIssqn getTribIssqnNfn() {
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$ExigibilidadeISS[this.liNotafiscal.getExigibilidadeissNfs().ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1, 2, 3, 4 -> TributacaoIssqn.OPERACAO_TRIBUTAVEL;
            case 5 -> TributacaoIssqn.EXPORTACAO_DE_SERVICO;
            case 6 -> TributacaoIssqn.NAO_INCIDENCIA;
            case 7 -> TributacaoIssqn.IMUNIDADE;
        };
    }

    public TipoImunidadeIssqn getTpImunidadeNfn() {
        return TipoImunidadeIssqn.TIPO_NAO_INFORMADO;
    }

    public LiNotafiscal getLiNotafiscal() {
        return this.liNotafiscal;
    }

    public LiMobil getLiMobil() {
        return this.liMobil;
    }

    public GrContribuintes getGrContribuintes() {
        return this.grContribuintes;
    }

    public Municipio getMunicipioCadstro() {
        return this.municipioCadstro;
    }

    public void setLiNotafiscal(LiNotafiscal liNotafiscal) {
        this.liNotafiscal = liNotafiscal;
    }

    public void setLiMobil(LiMobil liMobil) {
        this.liMobil = liMobil;
    }

    public void setGrContribuintes(GrContribuintes grContribuintes) {
        this.grContribuintes = grContribuintes;
    }

    public void setMunicipioCadstro(Municipio municipioCadstro) {
        this.municipioCadstro = municipioCadstro;
    }
}

