/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.AdnClient;
import br.com.fiorilli.nfse_nacional.dto.nfse.DfeResponse;
import br.com.fiorilli.nfse_nacional.dto.nfse.EnviarLoteRequest;
import br.com.fiorilli.nfse_nacional.dto.nfse.LoteDFe;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiNfseEnvioLog;
import br.com.fiorilli.nfse_nacional.model.LiNfseEnvioQueue;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.model.enums.StatusImportacaoEnvio;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfseQueue;
import br.com.fiorilli.nfse_nacional.services.DfeEnvioService;
import br.com.fiorilli.nfse_nacional.services.EventoEnvioService;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService;
import br.com.fiorilli.nfse_nacional.services.data.LiNfseEnvioLogService;
import br.com.fiorilli.nfse_nacional.services.data.LiNfseEnvioQueueService;
import br.com.fiorilli.nfse_nacional.utils.ZipUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class DfeEnvioService {
    private static final Logger log = LoggerFactory.getLogger(DfeEnvioService.class);
    private final TaskScheduler nfseTaskScheduler;
    private final AdnClient adnClient;
    private final LiNfseEnvioQueueService liNfseEnvioQueueService;
    private final NotaFiscalEnvioService notaFiscalEnvioService;
    private final EventoEnvioService eventoEnvioService;
    private final AtomicInteger count = new AtomicInteger(0);
    private final ExecutorService envioThread = Executors.newSingleThreadExecutor();
    private final LiNfseEnvioLogService liNfseEnvioLogService;
    private ScheduledFuture<?> scheduledTask;

    @PostConstruct
    public void init() {
        this.scheduledTask = this.nfseTaskScheduler.scheduleAtFixedRate(() -> this.envioThread.submit(() -> this.checkAndSend()), Duration.ofSeconds(15L));
    }

    @PreDestroy
    public void destroy() {
        this.scheduledTask.cancel(false);
        this.envioThread.shutdown();
    }

    public void checkCountEmissao() {
        if (this.count.incrementAndGet() >= 1) {
            this.envioThread.submit(() -> this.checkAndSend());
        }
    }

    public synchronized void checkAndSend() {
        try {
            List envios = this.liNfseEnvioQueueService.queryFirstEnvios(1);
            if (envios.isEmpty()) {
                log.debug("Nenhum lote a ser enviado!");
                return;
            }
            List compressedEncodedXmls = envios.stream().map(envio -> {
                try {
                    String xml = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TipoDocumentoEnvio[envio.getTipoDocNeq().ordinal()]) {
                        default -> throw new MatchException(null, null);
                        case 1 -> this.eventoEnvioService.prepararCancelamento(envio.getLiNotafiscal().getCancelamento());
                        case 2 -> this.notaFiscalEnvioService.prepararEnvio(envio.getLiNotafiscal());
                    };
                    envio.setXml(xml);
                    return Base64.getEncoder().encodeToString(ZipUtils.compressUTF8((String)xml));
                }
                catch (Exception e) {
                    log.error("Erro no preparo do envio: {}", (Object)e, (Object)e);
                    this.marcarErroPreEnvio(envio);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!compressedEncodedXmls.isEmpty()) {
                log.info("Enviado lote de {} documentos", (Object)compressedEncodedXmls.size());
                this.sendAndProcess(compressedEncodedXmls, envios);
            }
            this.count.addAndGet(-envios.size());
        }
        catch (Exception e) {
            log.error("Erro no processo de envio", (Throwable)e);
            throw e;
        }
    }

    private void sendAndProcess(List<String> compressedEncodedXmls, List<LiNfseEnvioQueue> envios) {
        ResponseEntity res = this.adnClient.enviarLote(new EnviarLoteRequest(compressedEncodedXmls));
        if (res.getStatusCode().is2xxSuccessful()) {
            DfeResponse retorno = (DfeResponse)res.getBody();
            if (retorno == null) {
                throw new FiorilliException("Resposta nula da API");
            }
            Map<String, LoteDFe> map = retorno.getLote().stream().collect(Collectors.toMap(LoteDFe::getChaveAcesso, loteDFe -> loteDFe));
            envios.parallelStream().forEachOrdered(envio -> {
                LoteDFe lote = (LoteDFe)map.get(envio.getLiNotafiscal().getNotaNacional().getChaveNfseNfn());
                if (lote == null) {
                    lote = (LoteDFe)map.get(null);
                    this.marcarErroNoEnvio(envio, lote.getErros().stream().map(err -> err.toString().trim()).collect(Collectors.joining("\n")));
                    return;
                }
                if (!lote.getStatusProcessamento().equals("PROCESSADO_COM_ERROS")) {
                    if (lote.getStatusProcessamento().equals("PROCESSADO_COM_SUCESSO")) {
                        this.marcarSucessoNoEnvio(envio);
                    } else {
                        throw new FiorilliException("Status de processamento inesperado: " + lote.getStatusProcessamento());
                    }
                }
            });
            this.liNfseEnvioQueueService.batchSave(envios);
            List logs = envios.stream().map(LiNfseEnvioQueue::getLiNfseEnvioLog).filter(Objects::nonNull).collect(Collectors.toList());
            this.liNfseEnvioLogService.batchSave(logs);
        }
        if (log.isDebugEnabled()) {
            System.out.println(res);
        }
    }

    public void marcarErroPreEnvio(LiNfseEnvioQueue envio) {
        envio.setStatusNeq(StatusNfseQueue.NAO_ENVIADO_ERROS);
    }

    public void marcarErroNoEnvio(LiNfseEnvioQueue envio, String erro) {
        envio.setStatusNeq(StatusNfseQueue.ENVIADO_ERROS);
        envio.setRetornoErroNeq(erro);
        envio.setLiNfseEnvioLog(LiNfseEnvioLog.builder().liNotafiscal(envio.getLiNotafiscal()).tipoDocNen(envio.getTipoDocNeq()).xmlNen(envio.getXml()).statusNen(StatusImportacaoEnvio.ERRO).build());
    }

    public void marcarSucessoNoEnvio(LiNfseEnvioQueue envio) {
        envio.getLiNotafiscal().getNotaNacional().setStatusEnvioNac(StatusEnvioNotaNacional.ENVIADA);
        envio.setStatusNeq(null);
        envio.setLiNfseEnvioLog(LiNfseEnvioLog.builder().liNotafiscal(envio.getLiNotafiscal()).tipoDocNen(envio.getTipoDocNeq()).xmlNen(envio.getXml()).statusNen(StatusImportacaoEnvio.SUCESSO).build());
    }

    public DfeEnvioService(TaskScheduler nfseTaskScheduler, AdnClient adnClient, LiNfseEnvioQueueService liNfseEnvioQueueService, NotaFiscalEnvioService notaFiscalEnvioService, EventoEnvioService eventoEnvioService, LiNfseEnvioLogService liNfseEnvioLogService) {
        this.nfseTaskScheduler = nfseTaskScheduler;
        this.adnClient = adnClient;
        this.liNfseEnvioQueueService = liNfseEnvioQueueService;
        this.notaFiscalEnvioService = notaFiscalEnvioService;
        this.eventoEnvioService = eventoEnvioService;
        this.liNfseEnvioLogService = liNfseEnvioLogService;
    }
}

