/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.AdnClient;
import br.com.fiorilli.nfse_nacional.config.ShutdownHook;
import br.com.fiorilli.nfse_nacional.dto.nfse.DfeResponse;
import br.com.fiorilli.nfse_nacional.dto.nfse.LoteDFe;
import br.com.fiorilli.nfse_nacional.dto.nfse.TipoNSU;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.exception.NotaExistenteException;
import br.com.fiorilli.nfse_nacional.exception.ShutdownSignalException;
import br.com.fiorilli.nfse_nacional.model.LiNfseImport;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.NfeLog;
import br.com.fiorilli.nfse_nacional.model.NfeLogErros;
import br.com.fiorilli.nfse_nacional.model.NfeLogPK;
import br.com.fiorilli.nfse_nacional.model.enums.StatusImportacaoEnvio;
import br.com.fiorilli.nfse_nacional.schema.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCAtvEvento;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.services.EventoRecebimentoService;
import br.com.fiorilli.nfse_nacional.services.IntegradorCache;
import br.com.fiorilli.nfse_nacional.services.NfeLogService;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalRecebimentoService;
import br.com.fiorilli.nfse_nacional.services.ServicosWebService;
import br.com.fiorilli.nfse_nacional.services.data.LiNfseImportService;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import br.com.fiorilli.nfse_nacional.utils.NsuObjectHolder;
import br.com.fiorilli.nfse_nacional.utils.XmlUtils;
import br.com.fiorilli.nfse_nacional.utils.ZipUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import jakarta.annotation.PostConstruct;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.data.util.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class DfeRecepcaoService {
    private static final Logger log = LoggerFactory.getLogger(DfeRecepcaoService.class);
    public static final int TAMANHO_INTERVALO_LIMPEZA = 5;
    private final Environment env;
    private final Jaxb2Marshaller EventoMarshaller;
    private final Jaxb2Marshaller NFSeMarshaller;
    private final AdnClient adnClient;
    private final IntegradorCache integradorCache;
    private final ObjectMapper mapper;
    private final XmlMapper xmlMapper;
    private final NotaFiscalRecebimentoService notaFiscalRecebimentoService;
    private final EventoRecebimentoService eventoRecebimentoService;
    private final LiNfseImportService liNfseImportService;
    private final ServicosWebService servicosWebService;
    private final ExecutorService nfseExecutor;
    private final NfeLogService nfeLogService;
    private final TaskScheduler nfseTaskScheduler;
    private final Queue<LoteDFe> loteDFes = new ConcurrentLinkedDeque();
    private final Thread processingThread = new Thread(() -> this.loop(), "nota-proc-thr");
    private int runCount;
    public static int TAMANHO_PROCESSAMENTO = 50;
    public static int TAMANHO_CHECK_LOTE_QUEUE = 50;
    public static int INTERVAL_LOOP = 5000;
    @Value(value="${spring.profiles.active}")
    private String ambiente;
    @Value(value="${br.com.fiorilli.nfse.atualizar-notas}")
    private boolean atualizarNotasAntigas;
    @Value(value="${br.com.fiorilli.nfse.restringir-import}")
    private boolean restringirImportacao;
    @Value(value="${br.com.fiorilli.nfse.modo-intensivo}")
    private boolean modoIntensivo;
    @Value(value="${br.com.fiorilli.nfse.cron-processamento}")
    private String cronNormal;
    @Value(value="${br.com.fiorilli.nfse.cron-intensivo}")
    private String cronIntensivo;
    private ScheduledFuture<?> task;

    @PostConstruct
    public void init() {
        this.setModoIntensivo(this.modoIntensivo);
        this.processingThread.start();
    }

    private void setModoIntensivo(boolean active) {
        String cron;
        this.modoIntensivo = active;
        log.trace("Configurando modo de importa\u00e7\u00e3o: {}", (Object)(active ? "INTENSIVO" : "NORMAL"));
        if (this.task != null) {
            this.task.cancel(false);
        }
        if (active) {
            TAMANHO_CHECK_LOTE_QUEUE = 300;
            TAMANHO_PROCESSAMENTO = 100;
            INTERVAL_LOOP = 1000;
            cron = this.cronIntensivo;
        } else {
            TAMANHO_CHECK_LOTE_QUEUE = 50;
            TAMANHO_PROCESSAMENTO = 50;
            INTERVAL_LOOP = 5000;
            cron = this.cronNormal;
        }
        log.debug("Propriedades de importa\u00e7\u00e3o: max documentos em fila: {}; documentos por iteracao: {}; intervalo de processamento: {}; cron: {}", new Object[]{TAMANHO_CHECK_LOTE_QUEUE, TAMANHO_PROCESSAMENTO, INTERVAL_LOOP, cron});
        this.task = this.nfseTaskScheduler.schedule(() -> this.checkLoteQueue(), (Trigger)new CronTrigger(cron, ZoneId.of("America/Sao_Paulo")));
    }

    public DfeResponse recuperarLote() {
        try {
            return (DfeResponse)this.adnClient.recepcionarLote(this.nfeLogService.ultimoNsu(), TipoNSU.DISTRIBUICAO).getBody();
        }
        catch (FiorilliException e) {
            if (e.getStatus() == HttpStatus.NOT_FOUND) {
                log.info("Consulta \u00e0 API n\u00e3o retornou resultados!");
                if (this.modoIntensivo) {
                    log.warn("Desativando o modo de importa\u00e7\u00e3o intensiva!");
                    this.setModoIntensivo(false);
                }
                return null;
            }
            if (e.getStatus() == HttpStatus.TOO_MANY_REQUESTS && this.modoIntensivo) {
                log.info("Pular itera\u00e7\u00e3o: TOO_MANY_REQUESTS apontado pelo ADN");
            }
            throw e;
        }
    }

    public synchronized void checkLoteQueue() {
        if (ShutdownHook.shutdownInitiaded.get()) {
            return;
        }
        if (!this.processingThread.isAlive()) {
            throw new ShutdownSignalException("Thread de processamento inativa! Verifique por erros de execu\u00e7\u00e3o!");
        }
        if (this.loteDFes.size() < TAMANHO_CHECK_LOTE_QUEUE) {
            this.loteDFes.addAll(this.fetchLoteAdn());
        }
    }

    public void loop() {
        try {
            while (true) {
                Thread.sleep(INTERVAL_LOOP);
                if (!this.loteDFes.isEmpty()) {
                    this.processarLote();
                    continue;
                }
                log.trace("Checking processar - nenhum lote em espera");
            }
        }
        catch (Exception e) {
            log.error("Erro na execu\u00e7\u00e3o: {}", (Object)e, (Object)e);
            return;
        }
    }

    public synchronized void processarLote() {
        LoteDFe poll;
        if (ShutdownHook.shutdownInitiaded.get()) {
            return;
        }
        log.info("Processando automaticamente...");
        long begin = System.currentTimeMillis();
        if (!this.apiAvailable()) {
            return;
        }
        ArrayList erros = new ArrayList();
        ArrayList<NsuObjectHolder> liNotas = new ArrayList<NsuObjectHolder>();
        ArrayList<NsuObjectHolder> eventos = new ArrayList<NsuObjectHolder>();
        if (!this.integradorCache.areCachesEmpty()) {
            log.trace("Processando objetos em cache");
            ArrayList cacheNotas = new ArrayList(this.integradorCache.getNotas());
            this.integradorCache.getNotas().clear();
            liNotas.addAll(this.processNfse(cacheNotas, erros));
            ArrayList cacheEventos = new ArrayList(this.integradorCache.getEventos());
            this.integradorCache.getEventos().clear();
            eventos.addAll(this.processEventos(cacheEventos, erros));
        } else {
            log.debug("Sem dados em cache para processamento");
        }
        if (ShutdownHook.shutdownInitiaded.get()) {
            return;
        }
        ArrayList<LoteDFe> lote = new ArrayList<LoteDFe>();
        for (int i = 0; i < TAMANHO_PROCESSAMENTO && (poll = (LoteDFe)this.loteDFes.poll()) != null; ++i) {
            lote.add(poll);
        }
        try {
            liNotas.addAll(this.mapAndProcessNfse(lote, erros));
            eventos.addAll(this.mapAndProcessEventos(lote, erros));
            log.trace("Atualizando cache de eventos...");
            this.eventoRecebimentoService.atualizarCache();
            long end = System.currentTimeMillis();
            log.trace("Removendo itens nulos de lista...");
            liNotas.removeIf(NsuObjectHolder::isEmpty);
            eventos.removeIf(NsuObjectHolder::isEmpty);
            int notasSucesso = liNotas.size();
            int notasFalhas = erros.stream().filter(err -> err.getTipoNle().isTipoNota()).toList().size();
            log.info("Notas sucesso: {} Notas falhas: {}", (Object)notasSucesso, (Object)notasFalhas);
            int eventosSucesso = eventos.size();
            int eventosFalhas = erros.stream().filter(err -> err.getTipoNle().isTipoEvento()).toList().size();
            log.info("Eventos sucesso: {} Eventos falhas: {}", (Object)eventosSucesso, (Object)eventosFalhas);
            NfeLog nfeLog = this.nfeLogService.saveLog(NfeLog.builder().nfeLogPK(new NfeLogPK(Integer.valueOf(1), null)).ultimoNsuNlo(this.nfeLogService.ultimoNsu()).notasSucessoNlo(Integer.valueOf(notasSucesso)).notasFalhasNlo(Integer.valueOf(notasFalhas)).eventosSucessoNlo(Integer.valueOf(eventosSucesso)).eventosFalhasNlo(Integer.valueOf(eventosFalhas)).tempoMilisNlo(Integer.valueOf((int)(end - begin))).momentoNlo(LocalDateTime.now()).build(), erros);
            log.debug("Log salvo: ID {}", (Object)nfeLog.getNfeLogPK().getCodNlo());
            log.info("Processado. Tempo de processamento: {}s", (Object)((double)(end - begin) / 1000.0));
        }
        catch (ConcurrentRuntimeException e) {
            log.error("Erro de execu\u00e7\u00e3o", (Throwable)e);
            this.nfeLogService.saveExceptionLog("Erro de execu\u00e7\u00e3o", (Throwable)e);
        }
        if (this.runCount++ > 5) {
            this.notaFiscalRecebimentoService.cleanup();
            this.runCount = 0;
        }
        System.gc();
    }

    private List<LoteDFe> fetchLoteAdn() {
        log.trace("Recuperando lote do ADN...");
        DfeResponse dfeResponse = this.recuperarLote();
        log.trace("Recuperado lote com sucesso");
        if (dfeResponse == null) {
            return Collections.emptyList();
        }
        List lote = dfeResponse.getLoteDfe();
        if (lote.isEmpty()) {
            log.warn("AVISO: consulta foi bem sucedida, mas lote retornou vazio. Isso n\u00e3o \u00e9 esperado: se a consulta n\u00e3o retornar nenhum DFe, a consulta deve retornar HTTP 404 NOT FOUND");
            return Collections.emptyList();
        }
        long novoNsu = lote.stream().map(LoteDFe::getNsu).max(Long::compareTo).orElse(-1L);
        this.nfeLogService.updateNsu(Long.valueOf(novoNsu));
        log.debug("Last NSU: {}", (Object)this.nfeLogService.ultimoNsu());
        this.saveExampleLote(lote);
        return lote;
    }

    private boolean apiAvailable() {
        try {
            log.trace("Checando conexao com servicos web");
            this.servicosWebService.checkConncetion();
        }
        catch (FiorilliException e) {
            log.error("Erro ao checar conex\u00e3o com servicosweb : {}", (Object)e.toString());
            return false;
        }
        log.trace("Conexao sucedida");
        return true;
    }

    public List<NsuObjectHolder<TCEvento>> mapAndProcessEventos(List<LoteDFe> lote, List<NfeLogErros> erros) {
        return this.processEventos(this.filterAndMapEventos(lote, erros), erros);
    }

    private List<NsuObjectHolder<TCEvento>> processEventos(List<NsuObjectHolder<TCEvento>> eventos, List<NfeLogErros> erros) {
        if (ShutdownHook.shutdownInitiaded.get()) {
            return new ArrayList<NsuObjectHolder<TCEvento>>();
        }
        ArrayList finalList = new ArrayList();
        eventos.forEach(eventoHolder -> {
            if (this.isAllowedByProfile(((TCEvento)eventoHolder.getObject()).getInfEvento().getPedRegEvento().getInfPedReg().getTpAmb())) {
                finalList.add(eventoHolder.transform((nsu, evento) -> CompletableFuture.supplyAsync(() -> {
                    try {
                        log.debug("Processando evento NSU: {} ID: {}", (Object)eventoHolder.getNsu(), (Object)evento.getInfEvento().getId());
                        this.eventoRecebimentoService.processEvento(eventoHolder);
                        this.salvarSucessoImport(nsu, eventoHolder.getChaveAcesso(), eventoHolder.getOriginalXML());
                        return evento;
                    }
                    catch (ShutdownSignalException e) {
                        log.debug("Shutdown: add evento {} to cache", (Object)eventoHolder.getNsu());
                        this.integradorCache.addEvento(eventoHolder);
                        return null;
                    }
                    catch (FiorilliException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        this.integradorCache.addEvento(eventoHolder.incrementTrial());
                        erros.add(this.nfeLogService.errorEventoDefault(eventoHolder.getNsu(), "Erro de preenchimento", e.getMessage(), eventoHolder.getOriginalXML()));
                        this.salvarErroImport(nsu, eventoHolder.getChaveAcesso(), eventoHolder.getOriginalXML(), (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        this.integradorCache.addEvento(eventoHolder.incrementTrial());
                        erros.add(this.nfeLogService.errorEventoDefault(eventoHolder.getNsu(), "Erro inesperado de evento", e.getMessage(), eventoHolder.getOriginalXML()));
                        this.salvarErroImport(nsu, eventoHolder.getChaveAcesso(), eventoHolder.getOriginalXML(), (Throwable)e);
                        throw e;
                    }
                }, this.nfseExecutor)));
            }
        });
        return finalList.stream().map(nsuFutureHolder -> {
            try {
                CompletableFuture future = (CompletableFuture)nsuFutureHolder.getObject();
                if (future != null) {
                    return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)((TCEvento)future.join()), nsuFutureHolder.getOriginalXML());
                }
            }
            catch (CompletionException e) {
                return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)null, nsuFutureHolder.getOriginalXML(), (Throwable)e);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)null, nsuFutureHolder.getOriginalXML());
        }).collect(Collectors.toList());
    }

    private List<NsuObjectHolder<TCEvento>> filterAndMapEventos(List<LoteDFe> lote, List<NfeLogErros> erros) {
        return lote.stream().filter(loteDFe -> loteDFe.getTipoDocumento().equals("EVENTO")).map(loteDFe -> {
            byte[] arr = null;
            try {
                arr = Base64.getDecoder().decode(loteDFe.getArquivoXml());
                byte[] decompressed = ZipUtils.decompressGzip((byte[])arr);
                String stringXml = new String(decompressed, StandardCharsets.UTF_8);
                return new NsuObjectHolder(loteDFe.getNsu(), loteDFe.getChaveAcesso(), (Object)((TCEvento)XmlUtils.stringToXml((String)stringXml, (Unmarshaller)this.EventoMarshaller)), stringXml);
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                erros.add(this.nfeLogService.errorEventoDefault(loteDFe.getNsu(), "Erro ao decodificar string base64", e.getMessage(), loteDFe.getArquivoXml()));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                erros.add(this.nfeLogService.errorEventoXml(loteDFe.getNsu(), arr, (Exception)e));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<NsuObjectHolder<LiNotafiscal>> mapAndProcessNfse(List<LoteDFe> lote, List<NfeLogErros> erros) {
        log.trace("Processando notas...");
        List holders = this.filterAndMapNfses(lote, erros);
        this.saveExampleJson(holders);
        return this.processNfse(holders, erros);
    }

    private List<NsuObjectHolder<TCNFSe>> filterAndMapNfses(List<LoteDFe> lote, List<NfeLogErros> erros) {
        return lote.parallelStream().filter(loteDFe -> loteDFe.getTipoDocumento().equals("NFSE")).map(loteDFe -> {
            byte[] decompressed;
            byte[] arr;
            try {
                arr = Base64.getDecoder().decode(loteDFe.getArquivoXml());
            }
            catch (IllegalArgumentException e) {
                log.error("Erro ao decodificar arquivo xml", (Throwable)e);
                erros.add(this.nfeLogService.errorNotaDefault(loteDFe.getNsu(), "Erro ao decodificar string base64", e.getMessage(), loteDFe.getArquivoXml()));
                return null;
            }
            try {
                decompressed = ZipUtils.decompressGzip((byte[])arr);
            }
            catch (IOException e) {
                log.error("Erro ao descomprimir arquivo xml", (Throwable)e);
                erros.add(this.nfeLogService.errorNotaXml(loteDFe.getNsu(), arr, (Exception)e));
                return null;
            }
            String stringXml = new String(decompressed, StandardCharsets.UTF_8);
            return new NsuObjectHolder(loteDFe.getNsu(), loteDFe.getChaveAcesso(), (Object)((TCNFSe)XmlUtils.stringToXml((String)stringXml, (Unmarshaller)this.NFSeMarshaller)), stringXml);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<NsuObjectHolder<LiNotafiscal>> processNfse(List<NsuObjectHolder<TCNFSe>> holders, List<NfeLogErros> erros) {
        ArrayList notasParaProcessar;
        if (ShutdownHook.shutdownInitiaded.get()) {
            return new ArrayList<NsuObjectHolder<LiNotafiscal>>();
        }
        log.trace("Conferindo notas j\u00e1 salvas");
        List notasRelevantes = this.filtrarNotasIrrelevantes(holders);
        if (this.atualizarNotasAntigas) {
            notasParaProcessar = new ArrayList(notasRelevantes);
            this.recuperarNotasParaAtualizar(notasParaProcessar);
        } else {
            notasParaProcessar = this.filtrarNotasNovas(notasRelevantes);
        }
        ArrayList<NsuObjectHolder<TCNFSe>> notasVelhasOuIrrelevantes = new ArrayList<NsuObjectHolder<TCNFSe>>(holders);
        notasVelhasOuIrrelevantes.removeIf(holder -> FiorilliUtils.iterableContainsSuch((Iterable)notasParaProcessar, holder0 -> Objects.equals(holder0.getNsu(), holder.getNsu())));
        ArrayList<NsuObjectHolder> finalList = new ArrayList<NsuObjectHolder>();
        long startMillis = System.currentTimeMillis();
        for (NsuObjectHolder notaHolder : notasParaProcessar) {
            finalList.add(notaHolder.transform((nsu, tcnfse) -> CompletableFuture.supplyAsync(() -> {
                try {
                    this.tratarPossiveisAnomalias(tcnfse, notaHolder.getOriginalXML());
                    log.debug("Processando nota NSU: {} ID: {}", nsu, (Object)tcnfse.getInfNFSe().getId());
                    long start = System.currentTimeMillis();
                    LiNotafiscal liNota = this.notaFiscalRecebimentoService.processLiNota(notaHolder);
                    long end = System.currentTimeMillis();
                    log.debug("Time to process nota {} : {}s", (Object)liNota.getAdnNsuNfs(), (Object)((double)(end - start) / 1000.0));
                    start = System.currentTimeMillis();
                    this.notaFiscalRecebimentoService.salvarPreencherDados(tcnfse, liNota);
                    end = System.currentTimeMillis();
                    this.salvarSucessoImport(nsu, notaHolder.getChaveAcesso(), notaHolder.getOriginalXML());
                    log.debug("Time to save and process servico da nota {} : {}s", (Object)liNota.getAdnNsuNfs(), (Object)((double)(end - start) / 1000.0));
                    log.debug("Current elapsed time for notas: {}s", (Object)((double)(end - startMillis) / 1000.0));
                    return liNota;
                }
                catch (ShutdownSignalException e) {
                    log.debug("Shutdown: add nota {} to cache", nsu);
                    this.integradorCache.addNota(notaHolder);
                    return null;
                }
                catch (NotaExistenteException e) {
                    log.debug("Existente! Atualizando nota {}", nsu);
                    LiNotafiscal res = this.notaFiscalRecebimentoService.atualizarNotaExistente(notaHolder);
                    this.salvarSucessoImport(nsu, notaHolder.getChaveAcesso(), notaHolder.getOriginalXML());
                    return res;
                }
                catch (FiorilliException e) {
                    log.error("Erro ao processar a nota", (Throwable)e);
                    this.integradorCache.addNota(notaHolder.incrementTrial());
                    erros.add(this.nfeLogService.errorNotaDefault(nsu, "Erro de preenchimento", e.getMessage(), notaHolder.getOriginalXML()));
                    this.salvarErroImport(nsu, notaHolder.getChaveAcesso(), notaHolder.getOriginalXML(), (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error("Erro inesperado", (Throwable)e);
                    this.integradorCache.addNota(notaHolder.incrementTrial());
                    erros.add(this.nfeLogService.errorNotaDefault(nsu, "Erro inesperado de nota", e.getMessage(), notaHolder.getOriginalXML()));
                    this.salvarErroImport(nsu, notaHolder.getChaveAcesso(), notaHolder.getOriginalXML(), (Throwable)e);
                    throw e;
                }
            }, this.nfseExecutor)));
        }
        finalList.addAll(notasVelhasOuIrrelevantes.stream().map(holder -> holder.transform((nsu, o) -> CompletableFuture.completedFuture(null))).toList());
        if (ShutdownHook.shutdownInitiaded.get()) {
            finalList.forEach(holder -> {
                if (holder.getObject() != null) {
                    ((CompletableFuture)holder.getObject()).cancel(false);
                }
            });
            return new ArrayList<NsuObjectHolder<LiNotafiscal>>();
        }
        return finalList.stream().map(nsuFutureHolder -> {
            try {
                CompletableFuture future = (CompletableFuture)nsuFutureHolder.getObject();
                if (future != null) {
                    return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)((LiNotafiscal)future.join()), nsuFutureHolder.getOriginalXML());
                }
            }
            catch (CompletionException e) {
                return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)null, nsuFutureHolder.getOriginalXML(), (Throwable)e);
            }
            catch (CancellationException ignored) {
                log.trace("Cancellation catch");
            }
            return new NsuObjectHolder(nsuFutureHolder.getNsu(), nsuFutureHolder.getChaveAcesso(), (Object)null, nsuFutureHolder.getOriginalXML());
        }).collect(Collectors.toList());
    }

    private void recuperarNotasParaAtualizar(List<NsuObjectHolder<TCNFSe>> holders) {
        CompletableFuture.runAsync(() -> this.notaFiscalRecebimentoService.notasParaAtualizar(holders), this.nfseExecutor).join();
    }

    private List<NsuObjectHolder<TCNFSe>> filtrarNotasIrrelevantes(List<NsuObjectHolder<TCNFSe>> holders) {
        return holders.stream().filter(holder -> {
            Long nsu = holder.getNsu();
            TCNFSe tcnfse = (TCNFSe)holder.getObject();
            if (this.restringirImportacao && this.notaFiscalRecebimentoService.ignorarNota(holder)) {
                log.debug("Skip nota NSU: {} ID: {}", (Object)nsu, (Object)tcnfse.getInfNFSe().getId());
                return false;
            }
            log.debug("Pode cadastrar nota NSU: {} ID: {}", (Object)nsu, (Object)tcnfse.getInfNFSe().getId());
            return true;
        }).collect(Collectors.toList());
    }

    private List<NsuObjectHolder<TCNFSe>> filtrarNotasNovas(List<NsuObjectHolder<TCNFSe>> holders) {
        return CompletableFuture.supplyAsync(() -> this.notaFiscalRecebimentoService.apenasNotasNovas(holders), this.nfseExecutor).join().parallelStream().filter(holder -> this.isAllowedByProfile(((TCNFSe)holder.getObject()).getInfNFSe().getDPS().getInfDPS().getTpAmb())).collect(Collectors.toList());
    }

    private void saveExampleJson(List<NsuObjectHolder<TCNFSe>> notas) {
        if (!this.env.matchesProfiles(new String[]{"development"})) {
            return;
        }
        try {
            Path path = Path.of("./nota_exemplo.json", new String[0]);
            this.handleExampleFiles(new ArrayList<NsuObjectHolder<TCNFSe>>(notas), path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveExampleLote(List<LoteDFe> lote) {
        if (!this.env.matchesProfiles(new String[]{"development"})) {
            return;
        }
        try {
            Path path = Path.of("./lote_exemplo.json", new String[0]);
            this.handleExampleFiles(new ArrayList<LoteDFe>(lote), path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExampleFiles(List<Object> notas, Path path) throws IOException {
        Files.deleteIfExists(path);
        Path file = Files.createFile(path, new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            writer.write(91);
            notas.forEach(nota -> {
                try {
                    writer.write(this.mapper.writeValueAsString(nota));
                    writer.write(44);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            writer.write("{}\n]");
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }

    private boolean isAllowedByProfile(String ambienteAdn) {
        return switch (this.ambiente) {
            case "production" -> "1".equals(ambienteAdn);
            case "development" -> true;
            default -> throw new IllegalStateException("Ambiente n\u00e3o especificado");
        };
    }

    private void tratarPossiveisAnomalias(TCNFSe tcnfse, String originalXML) {
        try {
            Lazy lazyTree = Lazy.of(() -> {
                try {
                    return this.xmlMapper.readTree(originalXML);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
            TCAtvEvento atvEvento = tcnfse.getInfNFSe().getDPS().getInfDPS().getServ().getAtvEvento();
            if (atvEvento != null) {
                JsonNode node;
                if (atvEvento.getXNome() == null && (node = ((JsonNode)lazyTree.get()).get("infNFSe").get("DPS").get("infDPS").get("serv").get("atvEvento")).get("desc") != null) {
                    atvEvento.setXNome(node.get("desc").textValue());
                }
                if (atvEvento.getIdAtvEvt() == null && atvEvento.getEnd() == null && (node = ((JsonNode)lazyTree.get()).get("infNFSe").get("DPS").get("infDPS").get("serv").get("atvEvento")).get("id") != null) {
                    atvEvento.setIdAtvEvt(node.get("id").textValue());
                }
            }
        }
        catch (Exception e) {
            log.warn("Erro ao tentar tratar anomalias no XML: {}", (Object)e, (Object)e);
        }
    }

    private void salvarErroImport(Long nsu, String chave, String xml, Throwable t) {
        this.liNfseImportService.salvarRegistroImport(LiNfseImport.builder().nsuNim(nsu).chaveNim(chave).erroNim(t.toString()).momentoNim(LocalDateTime.now()).statsNim(StatusImportacaoEnvio.ERRO).xmlNim(xml).build());
    }

    private void salvarSucessoImport(Long nsu, String chave, String xml) {
        this.liNfseImportService.salvarRegistroImport(LiNfseImport.builder().nsuNim(nsu).chaveNim(chave).momentoNim(LocalDateTime.now()).statsNim(StatusImportacaoEnvio.SUCESSO).xmlNim(xml).build());
    }

    public DfeRecepcaoService(Environment env, Jaxb2Marshaller EventoMarshaller, Jaxb2Marshaller NFSeMarshaller, AdnClient adnClient, IntegradorCache integradorCache, ObjectMapper mapper, XmlMapper xmlMapper, NotaFiscalRecebimentoService notaFiscalRecebimentoService, EventoRecebimentoService eventoRecebimentoService, LiNfseImportService liNfseImportService, ServicosWebService servicosWebService, ExecutorService nfseExecutor, NfeLogService nfeLogService, TaskScheduler nfseTaskScheduler) {
        this.env = env;
        this.EventoMarshaller = EventoMarshaller;
        this.NFSeMarshaller = NFSeMarshaller;
        this.adnClient = adnClient;
        this.integradorCache = integradorCache;
        this.mapper = mapper;
        this.xmlMapper = xmlMapper;
        this.notaFiscalRecebimentoService = notaFiscalRecebimentoService;
        this.eventoRecebimentoService = eventoRecebimentoService;
        this.liNfseImportService = liNfseImportService;
        this.servicosWebService = servicosWebService;
        this.nfseExecutor = nfseExecutor;
        this.nfeLogService = nfeLogService;
        this.nfseTaskScheduler = nfseTaskScheduler;
    }
}

