/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiNotasubcancelada;
import br.com.fiorilli.nfse_nacional.model.enums.MotivoNacionalCancelamento;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.schema.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.evento.TCInfEvento;
import br.com.fiorilli.nfse_nacional.schema.evento.TCInfPedReg;
import br.com.fiorilli.nfse_nacional.schema.evento.TCPedRegEvt;
import br.com.fiorilli.nfse_nacional.schema.evento.TE101101;
import br.com.fiorilli.nfse_nacional.schema.evento.TE105102;
import br.com.fiorilli.nfse_nacional.schema.evento.TSCodigoEventoNFSe;
import br.com.fiorilli.nfse_nacional.services.FirebirdService;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.XmlUtils;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventoEnvioService {
    private static final Logger log = LoggerFactory.getLogger(EventoEnvioService.class);
    public static final String VERSAO_NACIONAL = "1.00";
    public static final String AMBIENTE_GERADOR_MUNICIPIO = "1";
    private final EntidadeVO entidadeVO;
    private final Jaxb2Marshaller EventoMarshaller;
    private final Jaxb2Marshaller PedRegEventoMarshaller;
    private final ObjectFactory factory;
    private final FirebirdService firebirdService;
    @Value(value="${spring.profiles.active}")
    private String ambiente;
    @Value(value="${spring.application.version}")
    private String versaoNfse;

    public String prepararCancelamento(LiNotasubcancelada liNotasubcancelada) throws Exception {
        if (liNotasubcancelada.getCancelada().getNotaNacional().getStatusEnvioNac() == StatusEnvioNotaNacional.NAO_ENVIADA) {
            throw new FiorilliException("N\u00e3o \u00e9 poss\u00edvel enviar evento de cancelamento da nota sem enviar a nota primeiro");
        }
        byte[] pkcs12 = this.entidadeVO.getCertificado();
        char[] password = this.entidadeVO.getSenhaCertificado().toCharArray();
        TCPedRegEvt pedRegEvento = this.buildPedRegEvento(liNotasubcancelada);
        String stringPedRegEvento = BuildXmlUtils.removeNamespace((String)XmlUtils.xmlToString((Object)pedRegEvento, (Marshaller)this.PedRegEventoMarshaller));
        String rawSignedPedReg = BuildXmlUtils.removeNamespace((String)XmlUtils.sign((byte[])stringPedRegEvento.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password));
        TCPedRegEvt signedPedReg = (TCPedRegEvt)XmlUtils.stringToXml((String)rawSignedPedReg, (Unmarshaller)this.PedRegEventoMarshaller);
        pedRegEvento.setSignature(signedPedReg.getSignature());
        TCEvento evento = this.buildEvento(pedRegEvento);
        String stringEvento = XmlUtils.xmlToString((Object)evento, (Marshaller)this.EventoMarshaller);
        String rawXml = XmlUtils.sign((byte[])stringEvento.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password);
        if (log.isDebugEnabled()) {
            System.out.println(NotaFiscalEnvioService.prettyPrintByTransformer((String)rawXml, (int)2, (boolean)true));
        }
        return rawXml;
    }

    public TCPedRegEvt buildPedRegEvento(LiNotasubcancelada liNotasubcancelada) {
        TCPedRegEvt pedRegEvento = this.factory.createTCPedRegEvt();
        pedRegEvento.setVersao("1.00");
        TCInfPedReg infPedReg = this.factory.createTCInfPedReg();
        infPedReg.setId(EventoEnvioService.prepararIdPedReg((LiNotasubcancelada)liNotasubcancelada));
        infPedReg.setVerAplic(this.versaoNfse);
        infPedReg.setDhEvento(BuildXmlUtils.formatToIsoOffset((LocalDateTime)liNotasubcancelada.getDtaIncNca()));
        String string = this.ambiente;
        int n = 0;
        infPedReg.setTpAmb(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"production"}, (Object)string, n)) {
            case 0 -> "1";
            default -> "2";
        });
        infPedReg.setChNFSe(liNotasubcancelada.getCancelada().getCodsegurancaNfs());
        infPedReg.setCNPJAutor(this.entidadeVO.getCnpj());
        if (liNotasubcancelada.getSubstituta() == null) {
            TE101101 e101101 = this.factory.createTE101101();
            e101101.setXDesc("Cancelamento de NFS-e");
            e101101.setCMotivo("9");
            e101101.setXMotivo(liNotasubcancelada.getDetalhemotivoNca());
            infPedReg.setE101101(e101101);
        } else {
            TE105102 e105102 = this.factory.createTE105102();
            e105102.setXDesc("Cancelamento de NFS-e por Substituicao");
            e105102.setChSubstituta(liNotasubcancelada.getSubstituta().getNotaNacional().getChaveNfseNfn());
            e105102.setCMotivo(Objects.requireNonNullElse(liNotasubcancelada.getCodMotivoNacionalNca(), MotivoNacionalCancelamento.OUTROS).codigo);
            e105102.setXMotivo(liNotasubcancelada.getDetalhemotivoNca());
            infPedReg.setE105102(e105102);
        }
        pedRegEvento.setInfPedReg(infPedReg);
        return pedRegEvento;
    }

    private static String prepararIdPedReg(LiNotasubcancelada liNotasubcancelada) {
        TSCodigoEventoNFSe evento = liNotasubcancelada.getSubstituta() == null ? TSCodigoEventoNFSe.E_101101 : TSCodigoEventoNFSe.E_105102;
        return "PRE" + liNotasubcancelada.getCancelada().getCodsegurancaNfs() + evento.name().replaceAll("\\D", "");
    }

    public TCEvento buildEvento(TCPedRegEvt pedRegEvento) {
        TCEvento evento = this.factory.createTCEvento();
        evento.setVersao("1.00");
        TCInfEvento infEvento = this.factory.createTCInfEvento();
        infEvento.setVerAplic(this.versaoNfse);
        infEvento.setAmbGer("1");
        infEvento.setNSeqEvento("001");
        infEvento.setDhProc(BuildXmlUtils.formatToIsoOffset((LocalDateTime)LocalDateTime.now()));
        infEvento.setNDFe(BuildXmlUtils.numToString((Number)this.generateNDFe()));
        infEvento.setPedRegEvento(pedRegEvento);
        evento.setInfEvento(infEvento);
        return evento;
    }

    private synchronized Long generateNDFe() {
        return this.firebirdService.genId(FirebirdService.Generators.GEN_NUMERO_DFE).longValue();
    }

    public EventoEnvioService(EntidadeVO entidadeVO, Jaxb2Marshaller EventoMarshaller, Jaxb2Marshaller PedRegEventoMarshaller, ObjectFactory factory, FirebirdService firebirdService) {
        this.entidadeVO = entidadeVO;
        this.EventoMarshaller = EventoMarshaller;
        this.PedRegEventoMarshaller = PedRegEventoMarshaller;
        this.factory = factory;
        this.firebirdService = firebirdService;
    }
}

