/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.ServicosWebClient;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.GrContribuinteDTO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.LiMobilDTO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.model.enums.SituacaoMobil;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCEnderNac;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCEndereco;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCInfoPrestador;
import br.com.fiorilli.nfse_nacional.services.ConfigService;
import br.com.fiorilli.nfse_nacional.services.FirebirdService;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.LiMobilService;
import jakarta.annotation.PostConstruct;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.text.MaskFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MobiliarioService {
    private static final Logger log = LoggerFactory.getLogger(MobiliarioService.class);
    private final ServicosWebClient servicosWebClient;
    private final FirebirdService firebirdService;
    private final LiMobilService liMobilService;
    private final ConfigService configService;
    private final UtilService utilService;
    private final EntidadeVO entidadeVO;
    private final Set<String> mobilDontSaveCache = new HashSet();
    private boolean isGerarCadastroAutomatico;
    private String maskMobil;

    public MobiliarioService(@Qualifier(value="decorated") ServicosWebClient servicosWebClient, FirebirdService firebirdService, LiMobilService liMobilService, ConfigService configService, UtilService utilService, EntidadeVO entidadeVO) {
        this.servicosWebClient = servicosWebClient;
        this.firebirdService = firebirdService;
        this.liMobilService = liMobilService;
        this.configService = configService;
        this.utilService = utilService;
        this.entidadeVO = entidadeVO;
    }

    @PostConstruct
    public void init() {
        this.isGerarCadastroAutomatico = this.configService.isGerarCadastroAutomaticoMobiliario();
        this.maskMobil = this.entidadeVO.getMaskMobil();
    }

    public synchronized Optional<LiMobil> recuperarEmpresa(String documento) {
        log.trace("Recovering mobil {}", (Object)documento);
        if (this.mobilDontSaveCache.contains(documento)) {
            return Optional.empty();
        }
        return this.liMobilService.recuperarMobil(documento);
    }

    public void markDontSave(String documento) {
        this.mobilDontSaveCache.add(documento);
    }

    public synchronized void saveMobiliarioFromNota(TCInfoPrestador prest, GrContribuintes grContribuintes) {
        log.trace("Saving mobil from nota: {} {}", (Object)prest.getCNPJ(), (Object)grContribuintes.getGrContribuintesPK().getCodCnt());
        log.trace("Async save mobil {}", (Object)prest.getCNPJ());
        LiMobilDTO mobilDto = this.makeLiMobilDto(prest, grContribuintes);
        log.trace("Sending request to mobil POST");
        long start = System.currentTimeMillis();
        LiMobilDTO responseDto = (LiMobilDTO)this.servicosWebClient.cadastrarEmpresa(mobilDto).getBody();
        long finish = System.currentTimeMillis();
        log.trace("Time to post mobil : {}ms", (Object)(finish - start));
        GrContribuinteDTO contrib = responseDto.getGrContribuintes();
        if (contrib == null) {
            throw new FiorilliException("Falha ao cadastrar mobili\u00e1rio: contribuinte da resposta nulo");
        }
        log.trace("Async mobil {} saved! Recovering", (Object)prest.getCNPJ());
        this.liMobilService.recuperarMobil(contrib.getCnpjCnt()).orElseThrow(() -> new FiorilliException("Cadastro de mobili\u00e1rio n\u00e3o realizado"));
    }

    private LiMobilDTO makeLiMobilDto(TCInfoPrestador prest, GrContribuintes grContribuintes) {
        LiMobilDTO.LiMobilDTOBuilder builder = LiMobilDTO.builder().codCntMbl(grContribuintes.getGrContribuintesPK().getCodCnt()).situacaoMbl(SituacaoMobil.ATIVO_PROVISORIO.valor).grContribuintes(grContribuintes.toDTO()).nomefMbl(prest.getXNome()).loginIncMbl("nfse-nac").dtaIncMbl(LocalDate.now());
        TCEndereco end = prest.getEnd();
        if (end != null) {
            TCEnderNac endnac = end.getEndNac();
            String codcid = null;
            if (endnac != null) {
                codcid = this.utilService.findCidadeByCdMunicipio(Integer.valueOf(endnac.getCMun())).getCodCid();
            }
            builder.codCidMbl(codcid).lograMbl(prest.getEnd().getXLgr()).numeroMbl(prest.getEnd().getNro()).bairroMbl(prest.getEnd().getXBairro()).compleMbl(prest.getEnd().getXCpl()).cepiMbl(prest.getEnd().getEndNac().getCEP());
        }
        builder.inscrmMbl(prest.getIM());
        if (!this.isGerarCadastroAutomatico) {
            String cadastroGerado = this.gerarCadastroMobil();
            builder.codMbl(cadastroGerado);
            if (prest.getIM() == null) {
                builder.inscrmMbl(cadastroGerado);
            }
        }
        return builder.build();
    }

    public String gerarCadastroMobil() {
        String numbers = this.maskMobil.replaceAll("\\D", "");
        if (MobiliarioService.contains((String)numbers, (String)"[0-8]")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel parsear mask do Mobil");
        }
        Number genId = this.firebirdService.genId(FirebirdService.Generators.GEN_LI_MOBIL_NONAUTO);
        String input = String.format("99%0" + (numbers.length() - 2) + "d", genId.longValue());
        return MobiliarioService.formatMask((String)input, (String)this.maskMobil.replaceAll("9", "#"));
    }

    private static String formatMask(String input, String pattern) {
        try {
            MaskFormatter formatter = new MaskFormatter(pattern);
            formatter.setValueContainsLiteralCharacters(false);
            return formatter.valueToString(input);
        }
        catch (ParseException e) {
            throw new RuntimeException("Falha ao formatar codigo do mobiliario", e);
        }
    }

    private static boolean contains(String text, String regex) {
        return Pattern.compile(regex).matcher(text).find();
    }

    public void cleanupCache() {
        this.mobilDontSaveCache.clear();
    }
}

