/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.NotaEnvioVO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.model.enums.RegimeEspecialTributacao;
import br.com.fiorilli.nfse_nacional.model.enums.TipoRetencaoPisCofins;
import br.com.fiorilli.nfse_nacional.schema.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoNfse;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoRetencaoISSQN;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCBeneficioMunicipal;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCEmitente;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCEnderecoEmitente;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCInfNFSe;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCInfoDedRed;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCInfoTributacao;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCTribFederal;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCTribOutrosPisCofins;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCVDescCondIncond;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCValoresNFSe;
import br.com.fiorilli.nfse_nacional.schema.nfse.TSUF;
import br.com.fiorilli.nfse_nacional.services.FirebirdService;
import br.com.fiorilli.nfse_nacional.services.NFSeBuildService;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NFSeBuildService {
    private static final Logger log = LoggerFactory.getLogger(NFSeBuildService.class);
    public static final String VERSAO_NACIONAL = "1.00";
    public static final String AMBIENTE_GERADOR_MUNICIPIO = "1";
    public static final String TIPO_EMISSAO_MODELO_PROPRIO_TRANSCRITO = "2";
    private final FirebirdService firebirdService;
    @Value(value="${spring.application.version}")
    private String versaoNfse;
    private final ObjectFactory factory;
    private final EntidadeVO entidadeVO;
    private final UtilService utilService;

    public TCNFSe buildNfse(NotaEnvioVO nota, TCDPS dps) {
        TCNFSe nfse = this.factory.createTCNFSe();
        nfse.setVersao("1.00");
        TCInfNFSe infNFSe = this.factory.createTCInfNFSe();
        infNFSe.setXLocEmi(this.entidadeVO.getMunicipio().getMunicipio());
        infNFSe.setXLocPrestacao(this.utilService.findMunicipio(nota.getLiNotafiscal().getCdMunicipioprestacaoNfs()).getMunicipio());
        infNFSe.setNNFSe(BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getNrnotaNfs()));
        Municipio municipio = this.utilService.findMunicipio(nota.getLiNotafiscal().getCdMunicipioincidenciaissNfs());
        infNFSe.setCLocIncid(BuildXmlUtils.numToString((Number)municipio.getCdMunicipio()));
        infNFSe.setXLocIncid(municipio.getMunicipio());
        infNFSe.setXTribNac(nota.getDescricaoTributacao());
        infNFSe.setXTribMun(null);
        infNFSe.setXNBS(nota.getDescricaoNBS());
        infNFSe.setVerAplic(this.versaoNfse);
        infNFSe.setAmbGer("1");
        infNFSe.setTpEmis("2");
        infNFSe.setProcEmi(null);
        infNFSe.setCStat(NFSeBuildService.parseSituacaoNota((NotaEnvioVO)nota).codigo);
        infNFSe.setDhProc(BuildXmlUtils.formatToIsoOffset((LocalDateTime)LocalDateTime.now()));
        infNFSe.setNDFSe(BuildXmlUtils.numToString((Number)this.generateNDFSe()));
        infNFSe.setEmit(this.buildEmitente(nota));
        infNFSe.setValores(this.buildValores(nota, dps));
        infNFSe.setDPS(dps);
        infNFSe.setId(NFSeBuildService.generateIdInfNFSe((TCInfNFSe)infNFSe));
        nfse.setInfNFSe(infNFSe);
        return nfse;
    }

    private synchronized Long generateNDFSe() {
        return this.firebirdService.genId(FirebirdService.Generators.GEN_NUMERO_DFE).longValue();
    }

    private TCEmitente buildEmitente(NotaEnvioVO nota) {
        TCEmitente emit = this.factory.createTCEmitente();
        String documento = nota.getGrContribuintes().getCnpjCnt().replaceAll("\\D", "");
        if (documento.length() == 14) {
            emit.setCNPJ(documento);
        } else if (documento.length() == 11) {
            emit.setCPF(documento);
        }
        emit.setIM(BuildXmlUtils.nullBlank((String)nota.getInscricaoMunicipalCadastro()));
        emit.setXNome(nota.getGrContribuintes().getNomeCnt());
        emit.setXFant(BuildXmlUtils.nullBlank((String)nota.getLiMobil().getNomefMbl()));
        emit.setFone(BuildXmlUtils.nullBlank((String)BuildXmlUtils.removeNonDigits((String)nota.getFoneCadastro())));
        emit.setEmail(StringEscapeUtils.escapeXml11((String)BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)nota.getEmailCadastro()))));
        emit.setEnderNac(this.buildEnderecoEmitente(nota));
        return emit;
    }

    private TCEnderecoEmitente buildEnderecoEmitente(NotaEnvioVO nota) {
        TCEnderecoEmitente enderNac = this.factory.createTCEnderecoEmitente();
        enderNac.setXLgr(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)nota.getLogradouroCadastro())));
        enderNac.setNro(nota.getNroEndCadastro());
        enderNac.setXCpl(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)nota.getComplEndCadastro())));
        enderNac.setXBairro(nota.getBairroCadastro());
        enderNac.setCMun(this.utilService.findMunicipioByGrCidade(nota.getCodCidCadastro()).getCdMunicipio().toString());
        enderNac.setUF(TSUF.valueOf((String)nota.getMunicipioCadstro().getUf()));
        enderNac.setCEP(nota.getCepCadastro());
        return enderNac;
    }

    private TCValoresNFSe buildValores(NotaEnvioVO nota, TCDPS dps) {
        BigDecimal beneficioMunicipal;
        TCValoresNFSe valores = this.factory.createTCValoresNFSe();
        TCInfoDedRed vDedRed = dps.getInfDPS().getValores().getVDedRed();
        BigDecimal deducoesReducoes = vDedRed != null ? BuildXmlUtils.bigDecimal((String)vDedRed.getVDR()) : BigDecimal.ZERO;
        valores.setVCalcDR(BuildXmlUtils.format((BigDecimal)deducoesReducoes));
        TCBeneficioMunicipal bm = dps.getInfDPS().getValores().getTrib().getTribMun().getBM();
        BigDecimal bigDecimal = beneficioMunicipal = bm != null ? BuildXmlUtils.bigDecimal((String)bm.getVRedBCBM()) : BigDecimal.ZERO;
        if (bm != null) {
            valores.setTpBM(bm.getNBM());
            valores.setVCalcBM(BuildXmlUtils.format((BigDecimal)beneficioMunicipal));
        }
        BigDecimal baseCalculo = NFSeBuildService.calcularBaseCalculo((TCDPS)dps, (BigDecimal)deducoesReducoes, (BigDecimal)beneficioMunicipal);
        valores.setVBC(BuildXmlUtils.format((BigDecimal)baseCalculo));
        BigDecimal aliquota = BigDecimal.valueOf(nota.aliquota()).setScale(2, RoundingMode.DOWN);
        valores.setPAliqAplic(BuildXmlUtils.format((BigDecimal)aliquota));
        BigDecimal valorIssNota = BigDecimal.valueOf(nota.getLiNotafiscal().getValorissNfs());
        BigDecimal valorIssCalculado = baseCalculo.multiply(aliquota).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_EVEN);
        if (!valorIssNota.equals(valorIssCalculado)) {
            log.warn("Valor do ISS informado na nota difere do calculado. No envio \u00e9 usado o valor calculado.");
        }
        valores.setVISSQN(BuildXmlUtils.format((BigDecimal)valorIssCalculado));
        BigDecimal totalRetencoes = NFSeBuildService.calcularTotalRetencoes((TCDPS)dps, (BigDecimal)valorIssNota);
        valores.setVTotalRet(BuildXmlUtils.format((BigDecimal)totalRetencoes));
        BigDecimal valorLiquido = NFSeBuildService.calcularValorLiquido((TCDPS)dps, (BigDecimal)totalRetencoes);
        valores.setVLiq(BuildXmlUtils.format((BigDecimal)valorLiquido));
        return valores;
    }

    private static BigDecimal calcularValorLiquido(TCDPS dps, BigDecimal totalRetencoes) {
        BigDecimal valorServico = BuildXmlUtils.bigDecimal((String)dps.getInfDPS().getValores().getVServPrest().getVServ());
        TCVDescCondIncond vDescCondIncond = dps.getInfDPS().getValores().getVDescCondIncond();
        BigDecimal descontoCondicionado = vDescCondIncond != null ? BuildXmlUtils.bigDecimal((String)vDescCondIncond.getVDescCond()) : BigDecimal.ZERO;
        BigDecimal descontoIncondicionado = vDescCondIncond != null ? BuildXmlUtils.bigDecimal((String)vDescCondIncond.getVDescIncond()) : BigDecimal.ZERO;
        return valorServico.subtract(descontoCondicionado).subtract(descontoIncondicionado).subtract(totalRetencoes);
    }

    private static BigDecimal calcularTotalRetencoes(TCDPS dps, BigDecimal valorIss) {
        TCInfoTributacao infoTributacao = dps.getInfDPS().getValores().getTrib();
        TCTribFederal tribFed = infoTributacao.getTribFed();
        BigDecimal retencaoCP = BuildXmlUtils.bigDecimal((String)(tribFed == null ? null : tribFed.getVRetCP()));
        BigDecimal retencaoIRRF = BuildXmlUtils.bigDecimal((String)(tribFed == null ? null : tribFed.getVRetIRRF()));
        BigDecimal retencaoCSLL = BuildXmlUtils.bigDecimal((String)(tribFed == null ? null : tribFed.getVRetCSLL()));
        boolean issRetido = TipoRetencaoISSQN.of((String)infoTributacao.getTribMun().getTpRetISSQN()) != TipoRetencaoISSQN.NAO_RETIDO;
        BigDecimal retencaoISSQN = issRetido ? valorIss : BigDecimal.ZERO;
        TCTribOutrosPisCofins piscofins = tribFed == null ? null : tribFed.getPiscofins();
        TipoRetencaoPisCofins tpRetPisCofins = piscofins == null ? null : TipoRetencaoPisCofins.of((String)piscofins.getTpRetPisCofins());
        boolean isPisRetido = tpRetPisCofins == TipoRetencaoPisCofins.PIS_COFINS_RETIDO || tpRetPisCofins == TipoRetencaoPisCofins.PIS_RETIDO;
        BigDecimal retencaoPis = isPisRetido ? BuildXmlUtils.bigDecimal((String)piscofins.getVPis()) : BigDecimal.ZERO;
        boolean isCofinsRetido = tpRetPisCofins == TipoRetencaoPisCofins.PIS_COFINS_RETIDO || tpRetPisCofins == TipoRetencaoPisCofins.COFINS_RETIDO;
        BigDecimal retencaoCofins = isCofinsRetido ? BuildXmlUtils.bigDecimal((String)piscofins.getVCofins()) : BigDecimal.ZERO;
        return retencaoCP.add(retencaoIRRF).add(retencaoCSLL).add(retencaoISSQN).add(retencaoPis).add(retencaoCofins);
    }

    private static BigDecimal calcularBaseCalculo(TCDPS dps, BigDecimal deducoesReducoes, BigDecimal beneficioMunicipal) {
        BigDecimal valorServico = BuildXmlUtils.bigDecimal((String)dps.getInfDPS().getValores().getVServPrest().getVServ());
        TCVDescCondIncond vDescCondIncond = dps.getInfDPS().getValores().getVDescCondIncond();
        BigDecimal descontoIncondicionado = BuildXmlUtils.bigDecimal((String)(vDescCondIncond == null ? null : vDescCondIncond.getVDescIncond()));
        return valorServico.subtract(descontoIncondicionado).subtract(deducoesReducoes).subtract(beneficioMunicipal);
    }

    private static String generateIdInfNFSe(TCInfNFSe infNFSe) {
        String codigoMunicipio = infNFSe.getEmit().getEnderNac().getCMun();
        String ambienteGerador = infNFSe.getAmbGer();
        String cpfCnpj = (String)StringUtils.defaultIfBlank((CharSequence)infNFSe.getEmit().getCNPJ(), (CharSequence)infNFSe.getEmit().getCPF());
        int tipoInscricao = cpfCnpj.length() == 14 ? 2 : 1;
        String inscricaoFederal = StringUtils.leftPad((String)cpfCnpj, (int)14, (char)'0');
        String nNFSe = StringUtils.leftPad((String)infNFSe.getNNFSe(), (int)13, (char)'0');
        YearMonth yearMonth = YearMonth.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(infNFSe.getDPS().getInfDPS().getDhEmi()));
        String ano = String.valueOf(yearMonth.getYear()).substring(2);
        String mes = StringUtils.leftPad((String)String.valueOf(yearMonth.getMonth().getValue()), (int)2, (char)'0');
        String anoMes = ano + mes;
        String codigoNumerico = RandomStringUtils.randomNumeric((int)9);
        String first49Digits = codigoMunicipio + ambienteGerador + tipoInscricao + inscricaoFederal + nNFSe + anoMes + codigoNumerico;
        String lastDigit = FiorilliUtils.getDg11((String)first49Digits);
        return "NFS" + first49Digits + lastDigit;
    }

    private static SituacaoNfse parseSituacaoNota(NotaEnvioVO nota) {
        return switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TipoNota[nota.getLiNotafiscal().getTiponotaNfs().ordinal()]) {
            case 1, 2, 3 -> {
                if (nota.getLiNotafiscal().getRegimeespecialtribNfs() == RegimeEspecialTributacao.MEI) {
                    yield SituacaoNfse.NFSE_MEI;
                }
                yield SituacaoNfse.NFSE_GERADA;
            }
            case 4 -> SituacaoNfse.NFSE_AVULSA;
            default -> throw new IllegalArgumentException("Tipo da nota " + nota.getLiNotafiscal().getPk().getCodNfs() + " nulo!");
        };
    }

    public NFSeBuildService(FirebirdService firebirdService, ObjectFactory factory, EntidadeVO entidadeVO, UtilService utilService) {
        this.firebirdService = firebirdService;
        this.factory = factory;
        this.entidadeVO = entidadeVO;
        this.utilService = utilService;
    }
}

