/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.model.NfeLog;
import br.com.fiorilli.nfse_nacional.model.NfeLogErros;
import br.com.fiorilli.nfse_nacional.model.NfeLogErrosPK;
import br.com.fiorilli.nfse_nacional.model.NfeLogPK;
import br.com.fiorilli.nfse_nacional.model.enums.TipoErroLog;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfeLogService {
    private static final Logger log = LoggerFactory.getLogger(NfeLogService.class);
    private final UtilService utilService;
    private final NfsePersistenceManager dbAccessDispatcher;
    private AtomicLong ultimoNsu;
    private static final ReentrantLock nsuLock = new ReentrantLock();

    public NfeLog saveExceptionLog(String descricao, Throwable e) {
        log.trace("Salvando log de ");
        NfeLogErros error = this.errorDefault(descricao, e.getMessage(), e);
        NfeLog log = NfeLog.builder().nfeLogPK(new NfeLogPK(Integer.valueOf(1), null)).momentoNlo(LocalDateTime.now()).ultimoNsuNlo(this.ultimoNsu()).notasFalhasNlo(Integer.valueOf(0)).notasSucessoNlo(Integer.valueOf(0)).eventosFalhasNlo(Integer.valueOf(0)).eventosSucessoNlo(Integer.valueOf(0)).tempoMilisNlo(Integer.valueOf(0)).build();
        return this.saveLog(log, FiorilliUtils.listSingle((Object)error));
    }

    private NfeLogErros errorXml(Long nsu, byte[] xml, Throwable cause, TipoErroLog tipo) {
        return NfeLogErros.builder().nfeLogErrosPK(new NfeLogErrosPK(Integer.valueOf(1), null)).nsuNle(nsu).tipoNle(tipo).blobBinaryNle(xml).descricaoNle("Erro ao converter xml").mensagemNle(StringUtils.abbreviate((String)cause.getMessage(), (String)"...", (int)255)).build();
    }

    public NfeLogErros errorNotaXml(Long nsu, byte[] xml, Exception cause) {
        return this.errorXml(nsu, xml, (Throwable)cause, TipoErroLog.ERRO_NOTA_XML);
    }

    public NfeLogErros errorEventoXml(Long nsu, byte[] xml, Exception cause) {
        return this.errorXml(nsu, xml, (Throwable)cause, TipoErroLog.ERRO_EVENTO_XML);
    }

    public NfeLogErros errorNotaDefault(Long nsu, String descricao, String mensagem, String blobText) {
        return this.errorDefault(nsu, descricao, mensagem, blobText, TipoErroLog.ERRO_NOTA_DEFAULT);
    }

    public NfeLogErros errorEventoDefault(Long nsu, String descricao, String mensagem, String blobText) {
        return this.errorDefault(nsu, descricao, mensagem, blobText, TipoErroLog.ERRO_EVENTO_DEFAULT);
    }

    public NfeLogErros errorDefault(String descricao, String mensagem, Throwable e) {
        return this.errorDefault(null, descricao, mensagem, ExceptionUtils.getStackTrace((Throwable)e), TipoErroLog.ERRO_DEFAULT);
    }

    private NfeLogErros errorDefault(Long nsu, String descricao, String mensagem, String blobText, TipoErroLog tipoErroLog) {
        return NfeLogErros.builder().nfeLogErrosPK(new NfeLogErrosPK(Integer.valueOf(1), null)).nsuNle(nsu).tipoNle(tipoErroLog).descricaoNle(descricao).mensagemNle(StringUtils.abbreviate((String)mensagem, (String)"...", (int)255)).blobTextNle(blobText).build();
    }

    public NfeLog saveLog(NfeLog nfeLog, List<NfeLogErros> erros) {
        this.dbAccessDispatcher.run(em -> em.persist((Object)nfeLog), true);
        erros.forEach(erro -> {
            erro.setCodNloNle(nfeLog.getNfeLogPK().getCodNlo());
            if (erro.getMensagemNle() != null && erro.getMensagemNle().length() > 255) {
                String firstPart = erro.getMensagemNle().substring(0, 255);
                String extra = erro.getMensagemNle().substring(255);
                String blob = "..." + extra;
                if (erro.getBlobTextNle() != null && !erro.getBlobTextNle().isEmpty()) {
                    blob = blob + "\n\n==============================================================================\n\n" + erro.getBlobTextNle();
                }
                erro.setMensagemNle(firstPart);
                erro.setBlobTextNle(blob);
            }
            erro.setMensagemNle(erro.getMensagemNle());
            erro.setBlobTextNle(erro.getBlobTextNle());
        });
        this.dbAccessDispatcher.run(em -> erros.forEach(arg_0 -> ((EntityManager)em).persist(arg_0)), true);
        return nfeLog;
    }

    public Long ultimoNsu() {
        nsuLock.lock();
        try {
            if (this.ultimoNsu == null) {
                this.ultimoNsu = new AtomicLong(((Optional)this.dbAccessDispatcher.call((em, taskId) -> {
                    log.debug("Task {}: CALL ultimoNsu", taskId);
                    return em.createQuery("select n.ultimoNsuNlo\nfrom NfeLog n\nwhere n.nfeLogPK.codEmpNlo = 1\n    and n.ultimoNsuNlo is not null\norder by n.momentoNlo desc\n", Long.class).setMaxResults(1).getResultStream().findFirst();
                }, false)).orElse(0L));
            }
            Long l = this.ultimoNsu.get();
            return l;
        }
        finally {
            nsuLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNsu(Long newNsu) {
        nsuLock.lock();
        try {
            long nsuNew = newNsu;
            long nsuOld = this.ultimoNsu.get();
            if (nsuNew > nsuOld) {
                log.trace("Atualizando valor do ultimo NSU {} -> {}", (Object)nsuOld, (Object)nsuNew);
                this.ultimoNsu.set(nsuNew);
            }
        }
        finally {
            nsuLock.unlock();
        }
    }

    public NfeLogService(UtilService utilService, NfsePersistenceManager dbAccessDispatcher) {
        this.utilService = utilService;
        this.dbAccessDispatcher = dbAccessDispatcher;
    }
}

