/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.NotaEnvioVO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.nfse.TCNFSe;
import br.com.fiorilli.nfse_nacional.services.DPSBuildService;
import br.com.fiorilli.nfse_nacional.services.NFSeBuildService;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.GrContribuintesService;
import br.com.fiorilli.nfse_nacional.services.data.LiMobilService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.XmlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotaFiscalEnvioService {
    private static final Logger log = LoggerFactory.getLogger(NotaFiscalEnvioService.class);
    private final Jaxb2Marshaller DPSMarshaller;
    private final Jaxb2Marshaller NFSeMarshaller;
    private final EntidadeVO entidadeVO;
    private final GrContribuintesService grContribuintesService;
    private final NFSeBuildService nFSeBuildService;
    private final DPSBuildService dPSBuildService;
    private final LiMobilService liMobilService;
    private final UtilService utilService;

    public String prepararEnvio(LiNotafiscal liNotafiscal) throws Exception {
        if (liNotafiscal.getNotaNacional() == null) {
            throw new FiorilliException("N\u00e3o \u00e9 permitido enviar notas sem as infos do layout nacional!");
        }
        byte[] pkcs12 = this.entidadeVO.getCertificado();
        char[] password = this.entidadeVO.getSenhaCertificado().toCharArray();
        NotaEnvioVO nota = this.fetchInfosDaNota(liNotafiscal);
        TCDPS dps = this.dPSBuildService.buildDps(nota);
        String stringDps = BuildXmlUtils.removeNamespace((String)XmlUtils.xmlToString((Object)dps, (Marshaller)this.DPSMarshaller));
        String rawSignedDps = BuildXmlUtils.removeNamespace((String)XmlUtils.sign((byte[])stringDps.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password));
        TCDPS signedDps = (TCDPS)XmlUtils.stringToXml((String)rawSignedDps, (Unmarshaller)this.DPSMarshaller);
        dps.setSignature(signedDps.getSignature());
        TCNFSe nfse = this.nFSeBuildService.buildNfse(nota, dps);
        String stringNfse = XmlUtils.xmlToString((Object)nfse, (Marshaller)this.NFSeMarshaller);
        String rawXml = XmlUtils.sign((byte[])stringNfse.getBytes(), (byte[])pkcs12, (char[])password);
        liNotafiscal.getNotaNacional().setChaveNfseNfn(nfse.getInfNFSe().getId().substring(3));
        if (log.isDebugEnabled()) {
            System.out.println(NotaFiscalEnvioService.prettyPrintByTransformer((String)rawXml, (int)2, (boolean)true));
        }
        return rawXml;
    }

    private NotaEnvioVO fetchInfosDaNota(LiNotafiscal liNotafiscal) {
        NotaEnvioVO nota = new NotaEnvioVO();
        nota.setLiNotafiscal(liNotafiscal);
        if (nota.getLiNotafiscal().getCodModNfs() == 2) {
            nota.setLiMobil((LiMobil)this.liMobilService.findByCodigo(nota.getLiNotafiscal().getCadastroNfs()).orElseThrow());
            nota.setGrContribuintes(nota.getLiMobil().getGrContribuintes());
        } else if (nota.getLiNotafiscal().getCodModNfs() == 5) {
            nota.setGrContribuintes((GrContribuintes)this.grContribuintesService.findByCodigo(nota.getLiNotafiscal().getCadastroNfs()).orElseThrow());
        }
        nota.setMunicipioCadstro(this.utilService.findMunicipioByGrCidade(nota.getCodCidCadastro()));
        return nota;
    }

    public static String prettyPrintByTransformer(String xmlString, int indent, boolean ignoreDeclaration) {
        try {
            InputSource src = new InputSource(new StringReader(xmlString));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", ignoreDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurs when pretty-printing xml:\n" + xmlString, e);
        }
    }

    public NotaFiscalEnvioService(Jaxb2Marshaller DPSMarshaller, Jaxb2Marshaller NFSeMarshaller, EntidadeVO entidadeVO, GrContribuintesService grContribuintesService, NFSeBuildService nFSeBuildService, DPSBuildService dPSBuildService, LiMobilService liMobilService, UtilService utilService) {
        this.DPSMarshaller = DPSMarshaller;
        this.NFSeMarshaller = NFSeMarshaller;
        this.entidadeVO = entidadeVO;
        this.grContribuintesService = grContribuintesService;
        this.nFSeBuildService = nFSeBuildService;
        this.dPSBuildService = dPSBuildService;
        this.liMobilService = liMobilService;
        this.utilService = utilService;
    }
}

