/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.LiMobil;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiMobilService {
    private static final Logger log = LoggerFactory.getLogger(LiMobilService.class);
    private final NfsePersistenceManager nfsePersistenceManager;

    public Optional<LiMobil> recuperarMobil(String documento) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL recuperarMobil {}", taskId, (Object)documento);
            return em.createQuery("from LiMobil m\njoin fetch m.grContribuintes c\nwhere m.liMobilPK.codEmpMbl = 1\nand c.cnpjCnt = :documento\n", LiMobil.class).setParameter("documento", (Object)documento).getResultList().stream().findFirst();
        }, false);
    }

    public Optional<LiMobil> findByCodigo(String codigo) {
        return (Optional)this.nfsePersistenceManager.call((em, taskId) -> {
            log.debug("Task {}: CALL findByCodigo {}", taskId, (Object)codigo);
            return em.createQuery("from LiMobil l\njoin fetch l.grContribuintes c\nleft join fetch l.grBairro bai\nleft join fetch l.grLogra log\nwhere l.liMobilPK.codEmpMbl = 1\nand l.liMobilPK.codMbl = :codigo\n", LiMobil.class).setParameter("codigo", (Object)codigo).getResultStream().findFirst();
        }, false);
    }

    public LiMobilService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

