/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import br.com.fiorilli.nfse_nacional.model.LiMovimentoeco;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiMovimentoecoService {
    private static final Logger log = LoggerFactory.getLogger(LiMovimentoecoService.class);
    private final NfsePersistenceManager nfsePersistenceManager;
    private static final ReentrantLock persistLock = new ReentrantLock();

    public Optional<LiMovimentoeco> recuperarMovimento(String cadastro, int modulo, int mes, int ano, String origem, String tipo, String tipoEscritura) {
        return (Optional)this.nfsePersistenceManager.call(em -> {
            log.debug("CALL recuperarMovimento {} {} {} {} {} {} {}", new Object[]{cadastro, modulo, mes, ano, origem, tipo, tipoEscritura});
            return em.createQuery("from LiMovimentoeco m\nwhere m.liMovimentoecoPK.codEmpMec = 1\n    and m.cadastroMec = :cadastro\n    and m.codModMec = :modulo\n    and m.mesMec = :mes\n    and m.anoMec = :ano\n    and m.origemMec = :origem\n    and m.tpMec = :tipo\n    and m.tipoescrituraMec = :tipoEscritura\n", LiMovimentoeco.class).setParameter("cadastro", (Object)cadastro).setParameter("modulo", (Object)modulo).setParameter("mes", (Object)mes).setParameter("ano", (Object)ano).setParameter("origem", (Object)origem).setParameter("tipo", (Object)tipo).setParameter("tipoEscritura", (Object)tipoEscritura).getResultList().stream().findFirst();
        }, false);
    }

    public LiMovimentoeco persist(LiMovimentoeco entity) {
        this.nfsePersistenceManager.run((em, taskId) -> {
            log.debug("Task {}: CALL persist", taskId);
            em.persist((Object)entity);
        }, true, persistLock);
        return entity;
    }

    public LiMovimentoecoService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

