/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services.data;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NfsePersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(NfsePersistenceManager.class);
    private static final ReentrantLock entityManagerMapLock = new ReentrantLock();
    private static final AtomicLong sessionTaskCounter = new AtomicLong(0L);
    private final EntityManagerFactory emf;
    private final Map<Thread, EntityManager> entityManagerMap = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        log.info("Initializing Db Dispatcher...");
    }

    @PreDestroy
    public void shutdown() {
        this.clearEMs(true);
        this.entityManagerMap.clear();
    }

    public void clearEMs(boolean close) {
        this.entityManagerMap.forEach((key, em) -> {
            em.clear();
            if (close && em.isOpen()) {
                em.close();
            }
        });
    }

    public <T> T call(Function<EntityManager, T> task, boolean transaction) {
        return (T)this.call((em, ignoreTaskId) -> task.apply((EntityManager)em), transaction);
    }

    public <T> T call(BiFunction<EntityManager, Long, T> task, boolean transaction) {
        return (T)this.call(task, transaction, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(BiFunction<EntityManager, Long, T> task, boolean transaction, ReentrantLock lock) {
        EntityManager em;
        long comId = sessionTaskCounter.getAndIncrement();
        log.debug("Submitted command {} : {}", (Object)comId, task);
        entityManagerMapLock.lock();
        try {
            em = this.entityManagerMap.computeIfAbsent(Thread.currentThread(), threadName -> this.emf.createEntityManager());
        }
        finally {
            entityManagerMapLock.unlock();
        }
        if (lock != null) {
            lock.lock();
        }
        long start = System.currentTimeMillis();
        try {
            log.debug("Executing call {} in em {}", (Object)comId, (Object)em);
            if (transaction && !em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            T res = task.apply(em, comId);
            if (transaction && em.getTransaction().isActive()) {
                em.getTransaction().commit();
            }
            T t = res;
            return t;
        }
        catch (Exception e) {
            if (transaction && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            log.debug("Time to execute call {}: {}s", (Object)comId, (Object)((double)(end - start) / 1000.0));
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public void run(Consumer<EntityManager> task, boolean transaction) {
        this.run((em, ignoreTaskId) -> task.accept((EntityManager)em), transaction);
    }

    public void run(BiConsumer<EntityManager, Long> task, boolean transaction) {
        this.run(task, transaction, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(BiConsumer<EntityManager, Long> task, boolean transaction, ReentrantLock lock) {
        EntityManager em;
        long comId = sessionTaskCounter.getAndIncrement();
        log.debug("Submitting command {}", (Object)comId);
        entityManagerMapLock.lock();
        try {
            em = this.entityManagerMap.computeIfAbsent(Thread.currentThread(), threadName -> this.emf.createEntityManager());
        }
        finally {
            entityManagerMapLock.unlock();
        }
        if (lock != null) {
            lock.lock();
        }
        long start = System.currentTimeMillis();
        try {
            log.debug("Executing run {} in em {}", (Object)comId, (Object)em);
            if (transaction && !em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            task.accept(em, comId);
            if (transaction && em.getTransaction().isActive()) {
                em.flush();
                em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (transaction && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            log.debug("Time to execute run {}: {}s", (Object)comId, (Object)((double)(end - start) / 1000.0));
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public NfsePersistenceManager(EntityManagerFactory emf) {
        this.emf = emf;
    }
}

