/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class FiorilliUtils {
    public static final int CODIGO_BRASIL = 1058;

    public static String cifrarDecifrar(String texto) {
        if (texto != null) {
            char[] senhaCrypt = new char[texto.length()];
            for (int cont = texto.trim().length(); cont >= 1; --cont) {
                char codAsc = texto.charAt(cont - 1);
                int i = codAsc ^ 4;
                senhaCrypt[texto.length() - cont] = (char)i;
            }
            return new String(senhaCrypt);
        }
        return "";
    }

    public static <T> List<T> listSingle(T t) {
        return new ArrayList<T>(List.of(t));
    }

    public static <T> boolean iterableContainsSuch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static LocalDateTime toDateTime(String value) {
        return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static LocalDate toDate(String value) {
        return LocalDate.parse(value, DateTimeFormatter.ISO_DATE);
    }

    public static String getDg11(String codigo) {
        String dg11 = "";
        if (codigo != null && !codigo.isEmpty() && !(codigo = codigo.replaceAll("\\.", "").replaceAll("-", "").replaceAll("a", "").replaceAll("/", "").replaceAll(" ", "")).trim().isEmpty()) {
            String cPosicao = "23456789";
            int nVal = 0;
            int nCont = 0;
            for (int i = codigo.length() - 1; i >= 0; --i) {
                nVal += Integer.parseInt(cPosicao.substring(nCont, nCont + 1)) * Integer.parseInt(codigo.substring(i, i + 1));
                if (++nCont <= 7) continue;
                nCont = 0;
            }
            int resto = nVal % 11;
            dg11 = resto != 0 && resto != 1 && resto <= 9 ? String.valueOf(11 - resto) : "1";
        }
        return dg11.trim();
    }

    private FiorilliUtils() {
    }
}

