/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.function.BiFunction;

public class NsuObjectHolder<T> {
    protected Long nsu;
    protected String chaveAcesso;
    protected T object;
    protected String originalXML;
    protected Throwable error;
    protected int trialCount = 0;

    public NsuObjectHolder(Long nsu, String chaveAcesso, T object, String originalXML, Throwable error) {
        this.nsu = nsu;
        this.chaveAcesso = chaveAcesso;
        this.object = object;
        this.originalXML = originalXML;
        this.error = error;
    }

    public NsuObjectHolder(Long nsu, String chaveAcesso, T object, String originalXML) {
        this(nsu, chaveAcesso, object, originalXML, null);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.object == null;
    }

    @JsonIgnore
    public <E> NsuObjectHolder<E> transform(BiFunction<Long, T, E> function) {
        return new NsuObjectHolder(this.nsu, this.chaveAcesso, function.apply(this.nsu, (Long)this.object), this.originalXML, this.error);
    }

    @JsonIgnore
    public NsuObjectHolder<T> incrementTrial() {
        ++this.trialCount;
        return this;
    }

    public Long getNsu() {
        return this.nsu;
    }

    public String getChaveAcesso() {
        return this.chaveAcesso;
    }

    public T getObject() {
        return (T)this.object;
    }

    public String getOriginalXML() {
        return this.originalXML;
    }

    public Throwable getError() {
        return this.error;
    }

    public int getTrialCount() {
        return this.trialCount;
    }

    public NsuObjectHolder() {
    }
}

