/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.client;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.codec.ErrorDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdnClientConfig {
    private static final Logger log = LoggerFactory.getLogger(AdnClientConfig.class);

    @Bean
    Client client(EntidadeVO entidadeVO) {
        if (entidadeVO.getCertificado() == null) {
            log.error("\n\n\n################################################################\n \u00c9 necess\u00e1rio informar o certificado digital no banco de dados!\n################################################################\n\n");
            throw new FiorilliException("Certificado digital nulo");
        }
        return new Client.Default(AdnClientConfig.getSSLSocketFactory((byte[])entidadeVO.getCertificado(), (char[])entidadeVO.getSenhaCertificado().toCharArray()), (name, session) -> true);
    }

    @Bean
    ErrorDecoder errorDecoder(ObjectMapper jacksonObjectMapper) {
        return (methodKey, response) -> {
            String errorResponse;
            try {
                StringBuilder sb = new StringBuilder();
                Reader reader = response.body().asReader(response.charset());
                char[] buffer = new char[1024];
                while (reader.read(buffer) != -1) {
                    sb.append(buffer);
                }
                errorResponse = sb.toString();
            }
            catch (IOException e) {
                log.error("Erro ao ler resposta: {}", (Object)e, (Object)e);
                errorResponse = null;
            }
            log.info("\n--- ERRO ADN CLIENT ----------------------------------------------------------------\n{}\n{}\n\n{}\n------------------------------------------------------------------------------------\n", new Object[]{response.status(), response.headers().entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(value -> MessageFormat.format("{0}: {1}", entry.getKey(), value))).collect(Collectors.joining("\n")), errorResponse});
            if (response.status() == 495) {
                return new FiorilliException("Erro de certifica\u00e7\u00e3o! Verifique o certificado usado na conex\u00e3o com o ambiente de dados nacional");
            }
            FiorilliException exception = new FiorilliException("Erro na resposta da api ADN", HttpStatus.resolve((int)response.status()));
            try {
                if (StringUtils.isNotBlank((CharSequence)errorResponse)) {
                    exception.jsonError(jacksonObjectMapper.readTree(errorResponse));
                }
            }
            catch (JsonProcessingException e) {
                log.warn("N\u00e3o foi poss\u00edvel ler json de resposta: {}", (Object)errorResponse);
                log.debug("", (Throwable)e);
                exception.errorMessage(errorResponse);
            }
            return exception;
        };
    }

    private static SSLSocketFactory getSSLSocketFactory(byte[] pfx, char[] senha) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(AdnClientConfig.getKeyManager((byte[])pfx, (char[])senha), AdnClientConfig.getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyManager[] getKeyManager(byte[] pfx, char[] senha) {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(pfx), senha);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, senha);
            return kmf.getKeyManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException("Could not load PFX", e);
        }
    }

    private static TrustManager[] getTrustManager() {
        return new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
    }
}

