/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.config;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.ShutdownSignalException;
import br.com.fiorilli.nfse_nacional.services.EmpresaService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableCaching
public class AppConfig {
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    @Value(value="${br.com.fiorilli.nfse.threads-processamento}")
    private int threadsConfig;

    @Bean
    @Primary
    ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        return builder.build();
    }

    @Bean
    @Qualifier(value="XML")
    XmlMapper xmlMapper() {
        return (XmlMapper)XmlMapper.xmlBuilder().build();
    }

    @Bean
    EntidadeVO beanEntidade(EmpresaService empresaService) {
        log.trace("Montando bean de entidade...");
        return empresaService.loadConfigs();
    }

    @Bean
    ExecutorService nfseExecutor() {
        int maxThreads = 15;
        if (this.threadsConfig > maxThreads) {
            log.error("\n\n\n########################################################################################################\n ERRO: \u00e9 permitido configurar no m\u00e1ximo 15 threads para execu\u00e7\u00e3o paralela nesta vers\u00e3o do nfse-nacional\n Ajuste o n\u00famero para menor ou igual a 15 para iniciar o servi\u00e7o corretamente\n########################################################################################################\n\n");
            throw new IllegalStateException("M\u00e1ximo " + maxThreads + " threads permitido!");
        }
        CustomizableThreadFactory factory = new CustomizableThreadFactory();
        factory.setThreadNamePrefix("nfx-th-");
        int nThreads = this.threadsConfig > 0 ? this.threadsConfig : Math.min(Runtime.getRuntime().availableProcessors(), maxThreads);
        return Executors.newFixedThreadPool(nThreads, (ThreadFactory)factory);
    }

    @Bean
    TaskScheduler nfseTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setErrorHandler(t -> {
            if (t instanceof ShutdownSignalException) {
                log.error("Erro de shutdown detectado. Encerrando agendador de tarefas!");
                scheduler.shutdown();
            }
            log.error("Erro ao executar o task scheduler!", t);
        });
        return scheduler;
    }
}

