/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.config;

import br.com.fiorilli.nfse_nacional.client.ServicosTokenHolder;
import br.com.fiorilli.nfse_nacional.client.ServicosWebClient;
import br.com.fiorilli.nfse_nacional.client.ServicosWebClientAuthWrapper;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import io.micrometer.common.util.StringUtils;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebConfig {
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    @Value(value="${br.com.fiorilli.servicosweb.url-api}")
    private String servicoswebUrl;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((String)this.servicoswebUrl)) {
            log.error("\n\n\n###############################################################################################\n ERRO: \u00c9 necess\u00e1rio informar a URL da api de servi\u00e7os como propriedade no xml de configura\u00e7\u00e3o!\n Adicione --br.com.fiorilli.servicosweb.url-api=<insira a url aqui, com final /rest>\n Exemplo: --br.com.fiorilli.servicosweb.url-api=http://localhost:8090/servicosweb-ws/rest\n###############################################################################################\n\n");
            throw new FiorilliException("URL da api de servi\u00e7os n\u00e3o informada");
        }
    }

    @Bean
    @Qualifier(value="decorated")
    ServicosWebClient servicosWebClient(ServicosWebClient servicosWebClient, ServicosTokenHolder servicosTokenHolder) {
        return new ServicosWebClientAuthWrapper(servicosWebClient, servicosTokenHolder);
    }
}

