/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.config;

import br.com.fiorilli.nfse_nacional.schema.v101.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCPedRegEvt;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCNFSe;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.xml.sax.SAXException;

@Configuration
public class XSD_v1_01_Config {
    private static final Logger log = LoggerFactory.getLogger(XSD_v1_01_Config.class);

    @Bean
    Validator nfseXsdValidator_v1_01() throws SAXException {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(Thread.currentThread().getContextClassLoader().getResource("schema/v1.01/NFSe_v1.01.xsd")).newValidator();
    }

    @Bean
    Validator eventoXsdValidator_v1_01() throws SAXException {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(Thread.currentThread().getContextClassLoader().getResource("schema/v1.01/evento_v1.01.xsd")).newValidator();
    }

    @Bean
    ObjectFactory xmlFactory_v1_01() {
        return new ObjectFactory();
    }

    @Bean
    Jaxb2Marshaller NFSeMarshaller_v1_01() {
        log.trace("Montando bean do marshaller de NFSe...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCNFSe.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.v101.nfse", "br.com.fiorilli.nfse_nacional.schema.v101.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller DPSMarshaller_v1_01() {
        log.trace("Montando bean do marshaller de DPS...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCDPS.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.v101.nfse", "br.com.fiorilli.nfse_nacional.schema.v101.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller EventoMarshaller_v1_01() {
        log.trace("Montando bean do marshaller de Evento...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCEvento.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.v101.evento", "br.com.fiorilli.nfse_nacional.schema.v101.common"});
        return marshaller;
    }

    @Bean
    Jaxb2Marshaller PedRegEventoMarshaller_v1_01() {
        log.trace("Montando bean do marshaller de Pedido de Registro de Evento...");
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setMappedClass(TCPedRegEvt.class);
        marshaller.setPackagesToScan(new String[]{"br.com.fiorilli.nfse_nacional.schema.v101.evento", "br.com.fiorilli.nfse_nacional.schema.v101.common"});
        return marshaller;
    }
}

