/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.controller;

import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.services.DfeEnvioService;
import br.com.fiorilli.nfse_nacional.services.DfeRecepcaoService;
import br.com.fiorilli.nfse_nacional.services.EventoEnvioService_v1_00;
import br.com.fiorilli.nfse_nacional.services.EventoEnvioService_v1_01;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService_v1_00;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService_v1_01;
import br.com.fiorilli.nfse_nacional.services.data.LiNotafiscalService;
import br.com.fiorilli.nfse_nacional.services.data.LiNotasubcanceladaService;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EnvioController {
    private final DfeEnvioService dfeEnvioService;
    private final NotaFiscalEnvioService_v1_00 notaFiscalEnvioService_v1_00;
    private final NotaFiscalEnvioService_v1_01 notaFiscalEnvioService_v1_01;
    private final LiNotafiscalService liNotafiscalService;
    private final LiNotasubcanceladaService liNotasubcanceladaService;
    private final DfeRecepcaoService dfeRecepcaoService;
    private final EventoEnvioService_v1_01 eventoEnvioService_v1_01;
    private final EventoEnvioService_v1_00 eventoEnvioService_v1_00;

    @GetMapping(value={"/ping"})
    @ResponseStatus(value=HttpStatus.OK)
    public void ping() {
    }

    @PostMapping(value={"/reprocessar-erros"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void tentarImportarErradas(@RequestParam(name="Nsu") String nsu) {
        long longNsu;
        try {
            longNsu = Long.parseLong(nsu);
        }
        catch (NumberFormatException e) {
            throw new FiorilliException("NSU inv\u00e1lido!", (Throwable)e);
        }
        CompletableFuture.runAsync(() -> this.dfeRecepcaoService.addNsuToQueryList(Long.valueOf(longNsu)));
    }

    @GetMapping(value={"/reimportar/{nsu}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void tentarReimportarNsu(@PathVariable String nsu) {
        long longNsu;
        try {
            longNsu = Long.parseLong(nsu);
        }
        catch (NumberFormatException e) {
            throw new FiorilliException("NSU inv\u00e1lido!", (Throwable)e);
        }
        CompletableFuture.runAsync(() -> this.dfeRecepcaoService.recepcionarSingle(longNsu));
    }

    @PostMapping(value={"/notificar-envio"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void notificarEnvio() {
        this.dfeEnvioService.checkCountEmissao();
    }

    @GetMapping(value={"/xml-nota/{codigo}"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public String gerarXmlNfse(@PathVariable Integer codigo, @RequestParam(defaultValue="1.00", required=false) String versao) {
        return this.liNotafiscalService.findNota(codigo).map(liNota -> switch (versao) {
            case "1.01" -> this.notaFiscalEnvioService_v1_01.apenasMontarXml(liNota);
            default -> this.notaFiscalEnvioService_v1_00.apenasMontarXml(liNota);
        }).orElseThrow(() -> new FiorilliException("Nota inexistente", HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/xml-evento/{codigo}"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public String gerarXmlEvento(@PathVariable Integer codigo, @RequestParam(defaultValue="1.00") String versao) {
        return this.liNotasubcanceladaService.find(codigo).map(cancelamento -> switch (versao) {
            case "1.01" -> this.eventoEnvioService_v1_01.apenasMontarXml(cancelamento);
            default -> this.eventoEnvioService_v1_00.apenasMontarXml(cancelamento);
        }).orElseThrow(() -> new FiorilliException("Cancelamento inexistente", HttpStatus.NOT_FOUND));
    }

    public EnvioController(DfeEnvioService dfeEnvioService, NotaFiscalEnvioService_v1_00 notaFiscalEnvioService_v1_00, NotaFiscalEnvioService_v1_01 notaFiscalEnvioService_v1_01, LiNotafiscalService liNotafiscalService, LiNotasubcanceladaService liNotasubcanceladaService, DfeRecepcaoService dfeRecepcaoService, EventoEnvioService_v1_01 eventoEnvioService_v1_01, EventoEnvioService_v1_00 eventoEnvioService_v1_00) {
        this.dfeEnvioService = dfeEnvioService;
        this.notaFiscalEnvioService_v1_00 = notaFiscalEnvioService_v1_00;
        this.notaFiscalEnvioService_v1_01 = notaFiscalEnvioService_v1_01;
        this.liNotafiscalService = liNotafiscalService;
        this.liNotasubcanceladaService = liNotasubcanceladaService;
        this.dfeRecepcaoService = dfeRecepcaoService;
        this.eventoEnvioService_v1_01 = eventoEnvioService_v1_01;
        this.eventoEnvioService_v1_00 = eventoEnvioService_v1_00;
    }
}

