/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.exception;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.ErrorResponseDTO;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.FieldErrorDTO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.exception.NotFoundException;
import br.com.fiorilli.nfse_nacional.exception.UnauthorizedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class ApiErrorHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiErrorHandler.class);

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseEntity<ErrorResponseDTO> handleUnauthorizedException(Exception e) {
        log.debug("Resolvido erro, tratando excecao UnauthorizedException", (Throwable)e);
        HttpStatus status = HttpStatus.UNAUTHORIZED;
        return new ResponseEntity((Object)ErrorResponseDTO.builder().status(status.name()).code(status.value()).message(e.getMessage()).build(), (HttpStatusCode)status);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        List validationList = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> FieldErrorDTO.builder().field(fieldError.getField()).message(fieldError.getDefaultMessage()).build()).collect(Collectors.toList());
        return new ResponseEntity((Object)ErrorResponseDTO.builder().status(status.toString()).code(status.value()).message("Erro de valida\u00e7\u00e3o").timestamp(new Date()).fieldErrors(validationList).build(), status);
    }

    @ExceptionHandler(value={FiorilliException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ErrorResponseDTO> handleFiorilliException(FiorilliException e) {
        log.debug("Resolvido erro, tratando excecao FiorilliException", (Throwable)e);
        HttpStatus status = Objects.isNull(e.getStatus()) ? HttpStatus.BAD_REQUEST : e.getStatus();
        return new ResponseEntity((Object)ErrorResponseDTO.builder().status(status.name()).code(status.value()).message(e.getMessage()).timestamp(new Date()).build(), (HttpStatusCode)status);
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ErrorResponseDTO> handleNotFoundException(NotFoundException e) {
        log.debug("Resolvido erro, tratando excecao NotFoundException", (Throwable)e);
        HttpStatus status = HttpStatus.NOT_FOUND;
        return new ResponseEntity((Object)ErrorResponseDTO.builder().status(status.name()).code(status.value()).message("Recurso n\u00e3o encontrado").timestamp(new Date()).build(), (HttpStatusCode)status);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponseDTO> handleExceptions(Exception e) {
        log.debug("Resolvido erro, tratando excecao generica Exception", (Throwable)e);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        return new ResponseEntity((Object)ErrorResponseDTO.builder().status(HttpStatus.INTERNAL_SERVER_ERROR.name()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()).message(e.getMessage()).stackTrace(stackTrace).build(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

