/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.exception;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpStatus;

public class FiorilliException
extends RuntimeException {
    private HttpStatus status;
    private JsonNode jsonError;
    private String errorMessage;

    public FiorilliException(String message) {
        super(message);
    }

    public FiorilliException(String message, HttpStatus status) {
        super(message);
        this.status = status;
    }

    public FiorilliException(String message, Throwable cause) {
        super(message, cause);
    }

    public FiorilliException jsonError(JsonNode errorMessage) {
        this.jsonError = errorMessage;
        return this;
    }

    public FiorilliException errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public String getMessage() {
        if (this.jsonError != null) {
            return super.getMessage() + " " + this.jsonError.toString();
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        return "FiorilliException: " + this.getMessage();
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public JsonNode getJsonError() {
        return this.jsonError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public FiorilliException() {
    }
}

