/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.model;

import br.com.fiorilli.nfse_nacional.model.GrLograPK;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name="GR_LOGRA", catalog="", schema="")
public class GrLogra
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected GrLograPK grLograPK;
    @Column(name="COD_BAIR_LOG")
    private Integer codBairLog;
    @Size(max=20)
    @Column(name="CEP_LOG")
    private @Size(max=20) String cepLog;
    @Size(max=60)
    @Column(name="NOME_LOG")
    private @Size(max=60) String nomeLog;
    @Size(max=30)
    @Column(name="LOGIN_INC_LOG")
    private @Size(max=30) String loginIncLog;
    @Column(name="DTA_INC_LOG")
    @Temporal(value=TemporalType.TIMESTAMP)
    private LocalDateTime dtaIncLog;
    @Size(max=30)
    @Column(name="LOGIN_ALT_LOG")
    private @Size(max=30) String loginAltLog;
    @Column(name="DTA_ALT_LOG")
    @Temporal(value=TemporalType.TIMESTAMP)
    private LocalDateTime dtaAltLog;
    @Size(max=60)
    @Column(name="NOME_ANT_LOG")
    private @Size(max=60) String nomeAntLog;
    @Column(name="CODANT")
    private Integer codant;
    @Size(max=10)
    @Column(name="SISTEMA")
    private @Size(max=10) String sistema;

    public GrLogra(GrLograPK grLograPK) {
        this.grLograPK = grLograPK;
    }

    public GrLogra(int codEmpLog, int codLog) {
        this.grLograPK = new GrLograPK(codEmpLog, codLog);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.grLograPK != null ? this.grLograPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GrLogra)) {
            return false;
        }
        GrLogra other = (GrLogra)object;
        return !(this.grLograPK == null && other.grLograPK != null || this.grLograPK != null && !this.grLograPK.equals((Object)other.grLograPK));
    }

    public String toString() {
        return "br.com.fiorilli.issweb.persistence.GrLogra[ grLograPK=" + String.valueOf(this.grLograPK) + " ]";
    }

    @PrePersist
    public void atualizarDataInclusao() {
        this.setDtaIncLog(LocalDateTime.now());
        this.setLoginIncLog("nfse-nac");
    }

    @PreUpdate
    public void atualizarDataAlteracao() {
        this.setDtaAltLog(LocalDateTime.now());
        this.setLoginAltLog("nfse-nac");
    }

    public void setGrLograPK(GrLograPK grLograPK) {
        this.grLograPK = grLograPK;
    }

    public void setCodBairLog(Integer codBairLog) {
        this.codBairLog = codBairLog;
    }

    public void setCepLog(String cepLog) {
        this.cepLog = cepLog;
    }

    public void setNomeLog(String nomeLog) {
        this.nomeLog = nomeLog;
    }

    public void setLoginIncLog(String loginIncLog) {
        this.loginIncLog = loginIncLog;
    }

    public void setDtaIncLog(LocalDateTime dtaIncLog) {
        this.dtaIncLog = dtaIncLog;
    }

    public void setLoginAltLog(String loginAltLog) {
        this.loginAltLog = loginAltLog;
    }

    public void setDtaAltLog(LocalDateTime dtaAltLog) {
        this.dtaAltLog = dtaAltLog;
    }

    public void setNomeAntLog(String nomeAntLog) {
        this.nomeAntLog = nomeAntLog;
    }

    public void setCodant(Integer codant) {
        this.codant = codant;
    }

    public void setSistema(String sistema) {
        this.sistema = sistema;
    }

    public GrLograPK getGrLograPK() {
        return this.grLograPK;
    }

    public Integer getCodBairLog() {
        return this.codBairLog;
    }

    public String getCepLog() {
        return this.cepLog;
    }

    public String getNomeLog() {
        return this.nomeLog;
    }

    public String getLoginIncLog() {
        return this.loginIncLog;
    }

    public LocalDateTime getDtaIncLog() {
        return this.dtaIncLog;
    }

    public String getLoginAltLog() {
        return this.loginAltLog;
    }

    public LocalDateTime getDtaAltLog() {
        return this.dtaAltLog;
    }

    public String getNomeAntLog() {
        return this.nomeAntLog;
    }

    public Integer getCodant() {
        return this.codant;
    }

    public String getSistema() {
        return this.sistema;
    }

    public GrLogra() {
    }
}

