/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.model.LiConfig;
import br.com.fiorilli.nfse_nacional.model.enums.SimNao;
import br.com.fiorilli.nfse_nacional.services.data.LiConfigService;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    private final LiConfigService liConfigService;

    @PostConstruct
    public void init() {
        LiConfig liConfig = this.findConfiguracao();
        if (liConfig.getCodserienfenacCnf() == null) {
            this.salvarSerieNacionalPadrao(liConfig);
        } else if (liConfig.getCodserienfenacCnf().equals(liConfig.getCodserienfeCnf()) || liConfig.getCodserienfenacCnf().equals(liConfig.getCodserienfeaCnf())) {
            log.warn("N\u00e3o \u00e9 permitido usar a mesma s\u00e9rie das notas convencionais ou avulsas para a nota nacional! Cadastrando nova...");
            this.salvarSerieNacionalPadrao(liConfig);
        }
    }

    private void salvarSerieNacionalPadrao(LiConfig liConfig) {
        Integer codigoSerieNacional = this.liConfigService.cadastrarSerieNacional();
        liConfig.setCodserienfenacCnf(codigoSerieNacional);
        this.liConfigService.merge(liConfig);
    }

    public LiConfig findConfiguracao() {
        return this.liConfigService.find();
    }

    public boolean isGerarCadastroAutomaticoMobiliario() {
        return this.findConfiguracao().getCampo04() == SimNao.SIM;
    }

    public ConfigService(LiConfigService liConfigService) {
        this.liConfigService = liConfigService;
    }
}

