/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.ServicosWebClient;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.GrContribuinteDTO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.GrCidade;
import br.com.fiorilli.nfse_nacional.model.GrContribuintes;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.model.enums.SimNao;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoSimplesNacional;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEnderExt;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEnderNac;
import br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEnderecoEmitente;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEmitente;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoPrestador;
import br.com.fiorilli.nfse_nacional.services.ContribuinteService;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.services.data.GrContribuintesService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ContribuinteService {
    private static final Logger log = LoggerFactory.getLogger(ContribuinteService.class);
    private final ServicosWebClient servicosWebClient;
    private final UtilService utilService;
    private final GrContribuintesService grContribuintesService;

    public ContribuinteService(@Qualifier(value="decorated") ServicosWebClient servicosWebClient, UtilService utilService, GrContribuintesService grContribuintesService) {
        this.servicosWebClient = servicosWebClient;
        this.utilService = utilService;
        this.grContribuintesService = grContribuintesService;
    }

    public synchronized GrContribuintes syncContribuinte(br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoPrestador tcPrestador, br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEmitente tcEmitente) {
        String cpfCnpj = (String)StringUtils.defaultIfBlank((CharSequence)tcPrestador.getCNPJ(), (CharSequence)tcPrestador.getCPF());
        log.trace("Sync contribuinte {}", (Object)cpfCnpj);
        return this.recuperarContribuinte(cpfCnpj).orElseGet(() -> {
            log.trace("Contribuinte {} not found, saving", (Object)cpfCnpj);
            return this.saveContribuinteFromNota(tcPrestador, tcEmitente);
        });
    }

    public synchronized GrContribuintes syncContribuinte(TCInfoPrestador tcPrestador, TCEmitente tcEmitente) {
        String cpfCnpj = (String)StringUtils.defaultIfBlank((CharSequence)tcPrestador.getCNPJ(), (CharSequence)tcPrestador.getCPF());
        log.trace("Sync contribuinte {}", (Object)cpfCnpj);
        return this.recuperarContribuinte(cpfCnpj).orElseGet(() -> {
            log.trace("Contribuinte {} not found, saving", (Object)cpfCnpj);
            return this.saveContribuinteFromNota(tcPrestador, tcEmitente);
        });
    }

    public Optional<GrContribuintes> recuperarContribuinte(String documento) {
        long startTime = System.currentTimeMillis();
        List contribuintes = this.grContribuintesService.recuperarContribuintes(documento);
        long endTime = System.currentTimeMillis();
        if (contribuintes.isEmpty()) {
            log.trace("Recuperar contribuintes EMPTY time {}ms", (Object)(endTime - startTime));
            return Optional.empty();
        }
        log.trace("Recuperar contribuintes FOUND time {}ms", (Object)(endTime - startTime));
        return Optional.of((GrContribuintes)contribuintes.getFirst());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GrContribuintes saveContribuinteFromNota(br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCInfoPrestador tcPrestador, br.com.fiorilli.nfse_nacional.schema.v100.nfse.TCEmitente tcEmitente) {
        String cep;
        String uf;
        String codigoGrCidade;
        Integer codigoIbgeMunicipio;
        Integer pais;
        String bairro;
        String numero;
        String complemento;
        String logradouro;
        String cpfCpnj = ((String)StringUtils.defaultIfBlank((CharSequence)tcPrestador.getCNPJ(), (CharSequence)tcPrestador.getCPF())).trim().toUpperCase();
        String cpfCpnjEmit = ((String)StringUtils.defaultIfBlank((CharSequence)tcEmitente.getCNPJ(), (CharSequence)tcEmitente.getCPF())).trim().toUpperCase();
        boolean isPrestadorEmitente = Objects.equals(cpfCpnj, cpfCpnjEmit);
        if (tcPrestador.getEnd() != null) {
            logradouro = tcPrestador.getEnd().getXLgr();
            complemento = tcPrestador.getEnd().getXCpl();
            numero = tcPrestador.getEnd().getNro();
            bairro = tcPrestador.getEnd().getXBairro();
            TCEnderNac endNac = tcPrestador.getEnd().getEndNac();
            TCEnderExt endExt = tcPrestador.getEnd().getEndExt();
            if (endNac != null) {
                pais = 1058;
                codigoIbgeMunicipio = Integer.valueOf(endNac.getCMun());
                GrCidade grCidade = this.utilService.findCidadeByCdMunicipio(codigoIbgeMunicipio);
                if (grCidade != null) {
                    codigoGrCidade = grCidade.getCodCid();
                    uf = grCidade.getUfCid();
                } else {
                    codigoGrCidade = null;
                    uf = null;
                }
                cep = endNac.getCEP();
            } else {
                if (endExt == null) throw new FiorilliException("Endere\u00e7o n\u00e3o informado se nacional ou internacional");
                codigoIbgeMunicipio = null;
                codigoGrCidade = null;
                uf = null;
                cep = null;
                pais = this.utilService.findCodBceByIso2(endExt.getCPais());
            }
        } else {
            if (!isPrestadorEmitente || tcEmitente.getEnderNac() == null) throw new FiorilliException("N\u00e3o foi poss\u00edvel extrair endere\u00e7o");
            pais = 1058;
            TCEnderecoEmitente enderNac = tcEmitente.getEnderNac();
            logradouro = enderNac.getXLgr();
            complemento = enderNac.getXCpl();
            numero = enderNac.getNro();
            bairro = enderNac.getXBairro();
            codigoIbgeMunicipio = Integer.valueOf(enderNac.getCMun());
            GrCidade grCidade = this.utilService.findCidadeByCdMunicipio(codigoIbgeMunicipio);
            if (grCidade != null) {
                codigoGrCidade = grCidade.getCodCid();
                uf = grCidade.getUfCid();
            } else {
                codigoGrCidade = null;
                uf = null;
            }
            cep = enderNac.getCEP();
        }
        String email = tcPrestador.getEmail();
        String celular = tcPrestador.getFone();
        String nome = tcPrestador.getXNome();
        String inscricaoMunicipal = tcPrestador.getIM();
        if (isPrestadorEmitente) {
            email = (String)StringUtils.defaultIfBlank((CharSequence)email, (CharSequence)tcEmitente.getEmail());
            celular = (String)StringUtils.defaultIfBlank((CharSequence)celular, (CharSequence)tcEmitente.getFone());
            nome = (String)StringUtils.defaultIfBlank((CharSequence)nome, (CharSequence)tcEmitente.getXNome());
            inscricaoMunicipal = (String)StringUtils.defaultIfBlank((CharSequence)inscricaoMunicipal, (CharSequence)tcEmitente.getIM());
        }
        GrContribuinteDTO grDto = GrContribuinteDTO.builder().ativoCnt("S").cnpjCnt(cpfCpnj).cepCnt(cep).emailCnt(email).celularCnt(StringUtils.length((CharSequence)celular) > 15 ? null : celular).nomeCnt(StringUtils.truncate((String)nome, (int)150)).dtaIncCnt(LocalDateTime.now()).loginIncCnt("nfse-nac").inscrmunCnt(inscricaoMunicipal).codCidCnt(codigoGrCidade).nomLogCnt(StringUtils.truncate((String)logradouro, (int)70)).compleCnt(StringUtils.truncate((String)complemento, (int)150)).codPaisCnt(pais).numeroCnt(StringUtils.length((CharSequence)numero) > 10 ? null : numero).nomBaiCnt(bairro).ufCnt(uf).build();
        log.trace("Sending contribuinte {} POST", (Object)cpfCpnj);
        long start = System.currentTimeMillis();
        GrContribuinteDTO responseDto = (GrContribuinteDTO)this.servicosWebClient.cadastrarContribuinte(grDto).getBody();
        long finish = System.currentTimeMillis();
        log.trace("Time to post contribuinte {}: {}ms", (Object)cpfCpnj, (Object)(finish - start));
        if (responseDto == null) {
            throw new FiorilliException("Falha ao cadastrar contribuinte: resposta nula");
        }
        log.trace("Contribuinte {} saved through api, recovering from DB...", (Object)cpfCpnj);
        start = System.currentTimeMillis();
        GrContribuintes cnt = (GrContribuintes)this.recuperarContribuinte(responseDto.getCnpjCnt()).orElseThrow(() -> new FiorilliException("Contribuinte n\u00e3o cadastrado"));
        finish = System.currentTimeMillis();
        log.trace("Time to access and retrieve {} cnt: {}ms", (Object)cpfCpnj, (Object)(finish - start));
        boolean optanteSimples = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$SituacaoSimplesNacional[SituacaoSimplesNacional.of((String)tcPrestador.getRegTrib().getOpSimpNac()).ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> false;
            case 2, 3 -> true;
        };
        cnt.setOptantesimplesCnt(optanteSimples ? SimNao.SIM : SimNao.NAO);
        if (cnt.getCodCidCnt() != null || cnt.getCodPaisCnt() != 1058) return this.grContribuintesService.merge(cnt);
        Municipio municipio = this.utilService.findMunicipio(codigoIbgeMunicipio);
        if (municipio == null) throw new FiorilliException("N\u00e3o foi encontrado munic\u00edpio para c\u00f3digo IBGE: " + codigoIbgeMunicipio);
        cnt.setCidadeIbgeCnt(municipio.getCdMunicipio().toString());
        cnt.setUfCnt(municipio.getUf());
        return this.grContribuintesService.merge(cnt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GrContribuintes saveContribuinteFromNota(TCInfoPrestador tcPrestador, TCEmitente tcEmitente) {
        String cep;
        String uf;
        String codigoGrCidade;
        Integer codigoIbgeMunicipio;
        Integer pais;
        String bairro;
        String numero;
        String complemento;
        String logradouro;
        String cpfCpnj = ((String)StringUtils.defaultIfBlank((CharSequence)tcPrestador.getCNPJ(), (CharSequence)tcPrestador.getCPF())).trim().toUpperCase();
        String cpfCpnjEmit = ((String)StringUtils.defaultIfBlank((CharSequence)tcEmitente.getCNPJ(), (CharSequence)tcEmitente.getCPF())).trim().toUpperCase();
        boolean isPrestadorEmitente = Objects.equals(cpfCpnj, cpfCpnjEmit);
        if (tcPrestador.getEnd() != null) {
            logradouro = tcPrestador.getEnd().getXLgr();
            complemento = tcPrestador.getEnd().getXCpl();
            numero = tcPrestador.getEnd().getNro();
            bairro = tcPrestador.getEnd().getXBairro();
            br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderNac endNac = tcPrestador.getEnd().getEndNac();
            br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderExt endExt = tcPrestador.getEnd().getEndExt();
            if (endNac != null) {
                pais = 1058;
                codigoIbgeMunicipio = Integer.valueOf(endNac.getCMun());
                GrCidade grCidade = this.utilService.findCidadeByCdMunicipio(codigoIbgeMunicipio);
                if (grCidade != null) {
                    codigoGrCidade = grCidade.getCodCid();
                    uf = grCidade.getUfCid();
                } else {
                    codigoGrCidade = null;
                    uf = null;
                }
                cep = endNac.getCEP();
            } else {
                if (endExt == null) throw new FiorilliException("Endere\u00e7o n\u00e3o informado se nacional ou internacional");
                codigoIbgeMunicipio = null;
                codigoGrCidade = null;
                uf = null;
                cep = null;
                pais = this.utilService.findCodBceByIso2(endExt.getCPais());
            }
        } else {
            if (!isPrestadorEmitente || tcEmitente.getEnderNac() == null) throw new FiorilliException("N\u00e3o foi poss\u00edvel extrair endere\u00e7o");
            pais = 1058;
            br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderecoEmitente enderNac = tcEmitente.getEnderNac();
            logradouro = enderNac.getXLgr();
            complemento = enderNac.getXCpl();
            numero = enderNac.getNro();
            bairro = enderNac.getXBairro();
            codigoIbgeMunicipio = Integer.valueOf(enderNac.getCMun());
            GrCidade grCidade = this.utilService.findCidadeByCdMunicipio(codigoIbgeMunicipio);
            if (grCidade != null) {
                codigoGrCidade = grCidade.getCodCid();
                uf = grCidade.getUfCid();
            } else {
                codigoGrCidade = null;
                uf = null;
            }
            cep = enderNac.getCEP();
        }
        String email = tcPrestador.getEmail();
        String celular = tcPrestador.getFone();
        String nome = tcPrestador.getXNome();
        String inscricaoMunicipal = tcPrestador.getIM();
        if (isPrestadorEmitente) {
            email = (String)StringUtils.defaultIfBlank((CharSequence)email, (CharSequence)tcEmitente.getEmail());
            celular = (String)StringUtils.defaultIfBlank((CharSequence)celular, (CharSequence)tcEmitente.getFone());
            nome = (String)StringUtils.defaultIfBlank((CharSequence)nome, (CharSequence)tcEmitente.getXNome());
            inscricaoMunicipal = (String)StringUtils.defaultIfBlank((CharSequence)inscricaoMunicipal, (CharSequence)tcEmitente.getIM());
        }
        GrContribuinteDTO grDto = GrContribuinteDTO.builder().ativoCnt("S").cnpjCnt(cpfCpnj).cepCnt(cep).emailCnt(email).celularCnt(StringUtils.length((CharSequence)celular) > 15 ? null : celular).nomeCnt(StringUtils.truncate((String)nome, (int)150)).dtaIncCnt(LocalDateTime.now()).loginIncCnt("nfse-nac").inscrmunCnt(inscricaoMunicipal).codCidCnt(codigoGrCidade).nomLogCnt(StringUtils.truncate((String)logradouro, (int)70)).compleCnt(StringUtils.truncate((String)complemento, (int)150)).codPaisCnt(pais).numeroCnt(StringUtils.length((CharSequence)numero) > 10 ? null : numero).nomBaiCnt(bairro).ufCnt(uf).build();
        log.trace("Sending contribuinte {} POST", (Object)cpfCpnj);
        long start = System.currentTimeMillis();
        GrContribuinteDTO responseDto = (GrContribuinteDTO)this.servicosWebClient.cadastrarContribuinte(grDto).getBody();
        long finish = System.currentTimeMillis();
        log.trace("Time to post contribuinte {}: {}ms", (Object)cpfCpnj, (Object)(finish - start));
        if (responseDto == null) {
            throw new FiorilliException("Falha ao cadastrar contribuinte: resposta nula");
        }
        log.trace("Contribuinte {} saved through api, recovering from DB...", (Object)cpfCpnj);
        start = System.currentTimeMillis();
        GrContribuintes cnt = (GrContribuintes)this.recuperarContribuinte(responseDto.getCnpjCnt()).orElseThrow(() -> new FiorilliException("Contribuinte n\u00e3o cadastrado"));
        finish = System.currentTimeMillis();
        log.trace("Time to access and retrieve {} cnt: {}ms", (Object)cpfCpnj, (Object)(finish - start));
        boolean optanteSimples = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$SituacaoSimplesNacional[SituacaoSimplesNacional.of((String)tcPrestador.getRegTrib().getOpSimpNac()).ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> false;
            case 2, 3 -> true;
        };
        cnt.setOptantesimplesCnt(optanteSimples ? SimNao.SIM : SimNao.NAO);
        if (cnt.getCodCidCnt() != null || cnt.getCodPaisCnt() != 1058) return this.grContribuintesService.merge(cnt);
        Municipio municipio = this.utilService.findMunicipio(codigoIbgeMunicipio);
        if (municipio == null) throw new FiorilliException("N\u00e3o foi encontrado munic\u00edpio para c\u00f3digo IBGE: " + codigoIbgeMunicipio);
        cnt.setCidadeIbgeCnt(municipio.getCdMunicipio().toString());
        cnt.setUfCnt(municipio.getUf());
        return this.grContribuintesService.merge(cnt);
    }
}

