/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.NotaEnvioVO;
import br.com.fiorilli.nfse_nacional.dto.nfse.ConsultaConvenioResponse;
import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.NotaInaptaException;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscal;
import br.com.fiorilli.nfse_nacional.model.LiNotafiscalNacional;
import br.com.fiorilli.nfse_nacional.model.LiNotaintermediario;
import br.com.fiorilli.nfse_nacional.model.enums.MotivoEmissaoDPSTomaInterm;
import br.com.fiorilli.nfse_nacional.model.enums.RegimeEspecialTributacao;
import br.com.fiorilli.nfse_nacional.model.enums.SimNao;
import br.com.fiorilli.nfse_nacional.model.enums.TipoNota;
import br.com.fiorilli.nfse_nacional.model.enums.TributacaoIssqn;
import br.com.fiorilli.nfse_nacional.schema.enums.IndDestinatario;
import br.com.fiorilli.nfse_nacional.schema.enums.RegimeEspecialTributacaoNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.SituacaoSimplesNacional;
import br.com.fiorilli.nfse_nacional.schema.enums.TipoEmitenteDPS;
import br.com.fiorilli.nfse_nacional.schema.v101.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCAtvEvento;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCBeneficioMunicipal;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCCServ;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCComExterior;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCDPS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderExt;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderExtSimples;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderNac;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderObraEvento;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEndereco;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCEnderecoSimples;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfDPS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoCompl;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoDedRed;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoObra;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoPessoa;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoPrestador;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoTributacao;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCInfoValores;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCListaDocDedRed;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCLocPrest;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoDest;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoIBSCBS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoImovel;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoTributosIBSCBS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoTributosSitClas;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRTCInfoValoresIBSCBS;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCRegTrib;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCServ;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCTribFederal;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCTribMunicipal;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCTribOutrosPisCofins;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCTribTotal;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCTribTotalMonet;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCVDescCondIncond;
import br.com.fiorilli.nfse_nacional.schema.v101.nfse.TCVServPrest;
import br.com.fiorilli.nfse_nacional.services.DPSBuildService_v1_01;
import br.com.fiorilli.nfse_nacional.services.UtilService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.NFSeUtil;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DPSBuildService_v1_01 {
    private static final Logger log = LoggerFactory.getLogger(DPSBuildService_v1_01.class);
    public static final String FINALIDADE_EMISSAO_NFSE_REGULAR = "0";
    private final EntidadeVO entidadeVO;
    @Value(value="${spring.application.version}")
    private String versaoNfse;
    @Value(value="${spring.profiles.active}")
    private String ambiente;
    private final ObjectFactory factory_v1_01;
    private final UtilService utilService;

    public TCDPS buildDps(NotaEnvioVO nota) {
        TCDPS dps = this.factory_v1_01.createTCDPS();
        dps.setVersao("1.01");
        TCInfDPS infDps = this.factory_v1_01.createTCInfDPS();
        String string = this.ambiente;
        int n = 0;
        infDps.setTpAmb(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Production"}, (Object)string, n)) {
            case 0 -> "1";
            default -> "2";
        });
        if (LocalDateTime.now().minusYears(6L).isAfter(nota.getDataHoraEmissao())) {
            throw new NotaInaptaException("Prazo m\u00e1ximo de 6 anos (da data de emiss\u00e3o) para compartilhamento excedido!", nota.getLiNotafiscal());
        }
        if (nota.getLiNotafiscal().getDatacompeteNfs().isAfter(nota.getLiNotafiscal().getDataemissaoNfs())) {
            throw new NotaInaptaException("Data de compet\u00eancia posterior \u00e0 data de emiss\u00e3o!", nota.getLiNotafiscal());
        }
        infDps.setDhEmi(BuildXmlUtils.formatToIsoOffset((LocalDateTime)(nota.getLiNotafiscal().getDataemissaorpsNfs() != null ? nota.getLiNotafiscal().getDataemissaorpsNfs() : nota.getDataHoraEmissao())));
        infDps.setVerAplic(this.versaoNfse);
        String serie = nota.getLiNotafiscal().getSerierpsNfs() != null ? nota.getLiNotafiscal().getSerierpsNfs() : BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getCodSnfNfs());
        infDps.setSerie(StringUtils.leftPad((String)serie, (int)5, (char)'0'));
        long ndps = nota.getLiNotafiscal().getNumerorpsNfs() != null ? (long)nota.getLiNotafiscal().getNumerorpsNfs().intValue() : nota.getLiNotafiscal().getNrnotaNfs();
        infDps.setNDPS(BuildXmlUtils.numToString((Number)ndps));
        ConsultaConvenioResponse dadosConvenioMunicipio = this.utilService.fetchDadosConvenioMunicipio(this.entidadeVO.getCodigoIbge());
        LocalDate dataInicioConvenio = this.entidadeVO.getDataInicioConvenio();
        if (dadosConvenioMunicipio == null || nota.getLiNotafiscal().getDatacompeteNfs().isBefore(dataInicioConvenio)) {
            throw new NotaInaptaException("Data de compet\u00eancia anterior \u00e0 data de ativa\u00e7\u00e3o do conv\u00eanio", nota.getLiNotafiscal());
        }
        infDps.setDCompet(BuildXmlUtils.formatToDate((LocalDateTime)nota.getLiNotafiscal().getDatacompeteNfs().atStartOfDay()));
        TipoEmitenteDPS tipoEmitenteDPS = NFSeUtil.parseTipoEmitente((LiNotafiscal)nota.getLiNotafiscal());
        if (tipoEmitenteDPS != TipoEmitenteDPS.PRESTADOR) {
            throw new NotaInaptaException("Sistema nacional n\u00e3o aceita DPS emitida por tomador/intermedi\u00e1rio", nota.getLiNotafiscal());
        }
        if (tipoEmitenteDPS != TipoEmitenteDPS.PRESTADOR) {
            infDps.setCMotivoEmisTI(MotivoEmissaoDPSTomaInterm.of(null).codigo);
        }
        infDps.setTpEmit(tipoEmitenteDPS.codigo);
        infDps.setCLocEmi(BuildXmlUtils.numToString((Number)this.entidadeVO.getCodigoIbge()));
        infDps.setPrest(this.preencherPrestador(nota, tipoEmitenteDPS));
        if (StringUtils.isNotBlank((CharSequence)nota.getNomeTomador()) || StringUtils.isNotBlank((CharSequence)nota.getDocumentoTomador())) {
            infDps.setToma(this.preencherTomador(nota));
        }
        if (tipoEmitenteDPS == TipoEmitenteDPS.INTERMEDIARIO) {
            infDps.setInterm(this.preencherIntermediario(nota));
        }
        infDps.setServ(this.buildServico(nota));
        infDps.setValores(this.buildValores(nota));
        infDps.setId(this.generateIdDPS(infDps));
        dps.setInfDPS(infDps);
        return dps;
    }

    private TCRTCInfoIBSCBS buildIbsCbs(NotaEnvioVO nota) {
        TCRTCInfoIBSCBS ibscbs = this.factory_v1_01.createTCRTCInfoIBSCBS();
        ibscbs.setFinNFSe("0");
        ibscbs.setCIndOp(null);
        if (this.isObrigatorioInformarTpOper(nota)) {
            ibscbs.setTpOper(null);
        }
        ibscbs.setTpEnteGov(null);
        ibscbs.setIndDest(null);
        if (IndDestinatario.DESTINATARIO_OUTRO.equals((Object)ibscbs.getIndDest())) {
            TCRTCInfoDest dest = this.factory_v1_01.createTCRTCInfoDest();
            String documento = "";
            if (documento.length() == 14) {
                dest.setCNPJ(documento);
            } else if (documento.length() == 11) {
                dest.setCPF(documento);
            }
            ibscbs.setDest(dest);
        }
        ibscbs.setValores(this.buildValoresIBSCBS(nota));
        return null;
    }

    private TCRTCInfoValoresIBSCBS buildValoresIBSCBS(NotaEnvioVO nota) {
        TCRTCInfoValoresIBSCBS valores = this.factory_v1_01.createTCRTCInfoValoresIBSCBS();
        TCRTCInfoTributosIBSCBS trib = this.factory_v1_01.createTCRTCInfoTributosIBSCBS();
        TCRTCInfoTributosSitClas gibscbs = this.factory_v1_01.createTCRTCInfoTributosSitClas();
        gibscbs.setCST(null);
        gibscbs.setCClassTrib(null);
        gibscbs.setCCredPres(null);
        trib.setGIBSCBS(gibscbs);
        valores.setTrib(trib);
        return valores;
    }

    private TCRTCInfoImovel buildImovelIBSCBS(NotaEnvioVO nota) {
        TCRTCInfoImovel imovel = this.factory_v1_01.createTCRTCInfoImovel();
        imovel.setInscImobFisc(null);
        TCEnderObraEvento end = this.factory_v1_01.createTCEnderObraEvento();
        end.setXLgr(null);
        end.setNro(null);
        end.setXCpl(null);
        end.setXBairro(null);
        TCEnderExtSimples endExt = this.factory_v1_01.createTCEnderExtSimples();
        endExt.setCEndPost(null);
        endExt.setXCidade(null);
        endExt.setXEstProvReg(null);
        end.setEndExt(endExt);
        imovel.setEnd(end);
        return imovel;
    }

    private boolean isObrigatorioInformarTpOper(NotaEnvioVO nota) {
        return List.of("2505", "1509", "1702", "1005").contains(nota.getCodigoTributacao().substring(0, 4));
    }

    private TCInfoValores buildValores(NotaEnvioVO nota) {
        TCInfoValores valores = this.factory_v1_01.createTCInfoValores();
        TCVServPrest vServPrest = this.factory_v1_01.createTCVServPrest();
        vServPrest.setVReceb(null);
        vServPrest.setVServ(BuildXmlUtils.format((Double)nota.valorServico()));
        valores.setVServPrest(vServPrest);
        valores.setTrib(this.buildTributacao(nota));
        if (DPSBuildService_v1_01.isPreencherDedRed((NotaEnvioVO)nota)) {
            TCInfoDedRed vDedRed = this.factory_v1_01.createTCInfoDedRed();
            vDedRed.setVDR(BuildXmlUtils.format((Double)BuildXmlUtils.nulledZero((Double)nota.deducoes())));
            if (vDedRed.getVDR() != null || vDedRed.getPDR() != null || vDedRed.getDocumentos() != null) {
                valores.setVDedRed(vDedRed);
            }
        }
        double descontoCondicional = nota.descontoCondicional();
        double descontoIncondicional = nota.descontoIncondicional();
        if (descontoCondicional > 0.0 || descontoIncondicional > 0.0) {
            TCVDescCondIncond vDescCondIncond = this.factory_v1_01.createTCVDescCondIncond();
            vDescCondIncond.setVDescCond(BuildXmlUtils.format((Double)(descontoCondicional == 0.0 ? null : Double.valueOf(descontoCondicional))));
            vDescCondIncond.setVDescIncond(BuildXmlUtils.format((Double)(descontoIncondicional == 0.0 ? null : Double.valueOf(descontoIncondicional))));
            valores.setVDescCondIncond(vDescCondIncond);
        }
        return valores;
    }

    private TCListaDocDedRed buildDocumentosReducao(NotaEnvioVO nota) {
        TCListaDocDedRed documentos = this.factory_v1_01.createTCListaDocDedRed();
        return documentos;
    }

    private static boolean isPreencherDedRed(NotaEnvioVO nota) {
        SituacaoSimplesNacional optanteSimples = nota.optanteSimples();
        if (nota.getTribIssqnNfn() != TributacaoIssqn.OPERACAO_TRIBUTAVEL) {
            return false;
        }
        if (optanteSimples == SituacaoSimplesNacional.OPTANTE_MEI) {
            return false;
        }
        return NFSeUtil.regimeNossoParaNacional((RegimeEspecialTributacao)nota.getLiNotafiscal().getRegimeespecialtribNfs()) == RegimeEspecialTributacaoNacional.NENHUM;
    }

    private TCInfoTributacao buildTributacao(NotaEnvioVO nota) {
        TCInfoTributacao trib = this.factory_v1_01.createTCInfoTributacao();
        trib.setTribMun(this.buildTributosMunicipais(nota));
        if (nota.getGrContribuintes().getCnpjCnt().length() != 11) {
            trib.setTribFed(this.buildTributosFederais(nota));
        }
        TCTribTotal totTrib = this.factory_v1_01.createTCTribTotal();
        TCTribTotalMonet vTotTrib = this.factory_v1_01.createTCTribTotalMonet();
        vTotTrib.setVTotTribMun(BuildXmlUtils.format((BigDecimal)this.calcularTotalAproxTributosMunicipais(nota)));
        vTotTrib.setVTotTribEst(BuildXmlUtils.format((BigDecimal)this.calcularTotalAproxTributosEstaduais(nota)));
        vTotTrib.setVTotTribFed(BuildXmlUtils.format((BigDecimal)this.calcularTotalAproxTributosFederais(nota)));
        totTrib.setVTotTrib(vTotTrib);
        trib.setTotTrib(totTrib);
        return trib;
    }

    private BigDecimal calcularTotalAproxTributosFederais(NotaEnvioVO nota) {
        return BigDecimal.valueOf(nota.getLiNotafiscal().getValorpisNfs()).add(BigDecimal.valueOf(nota.getLiNotafiscal().getValorcofinsNfs())).add(BigDecimal.valueOf(nota.getLiNotafiscal().getValorcsllNfs())).add(BigDecimal.valueOf(nota.getLiNotafiscal().getValorirrfNfs())).add(BigDecimal.valueOf(nota.getLiNotafiscal().getValorinssNfs())).setScale(-1, RoundingMode.FLOOR);
    }

    private BigDecimal calcularTotalAproxTributosEstaduais(NotaEnvioVO nota) {
        return BigDecimal.ZERO;
    }

    private BigDecimal calcularTotalAproxTributosMunicipais(NotaEnvioVO nota) {
        return BigDecimal.valueOf(nota.getLiNotafiscal().getValorissNfs()).setScale(-1, RoundingMode.FLOOR);
    }

    private TCTribFederal buildTributosFederais(NotaEnvioVO nota) {
        TCTribFederal tribFed = this.factory_v1_01.createTCTribFederal();
        tribFed.setVRetCSLL(BuildXmlUtils.format((Double)BuildXmlUtils.nulledZero((Double)nota.getLiNotafiscal().getValorcsllNfs())));
        tribFed.setVRetIRRF(BuildXmlUtils.format((Double)BuildXmlUtils.nulledZero((Double)nota.getLiNotafiscal().getValorirrfNfs())));
        tribFed.setVRetCP(BuildXmlUtils.format((Double)BuildXmlUtils.nulledZero((Double)nota.getLiNotafiscal().getValorinssNfs())));
        if (nota.isPisConfins()) {
            TCTribOutrosPisCofins piscofins = this.factory_v1_01.createTCTribOutrosPisCofins();
            piscofins.setCST(nota.getLiNotafiscal().getNotaNacional().getSitTribPiscofinsNfn().codigo);
            piscofins.setVBCPisCofins(BuildXmlUtils.format((Double)nota.getLiNotafiscal().getBasecalculocofinsNfs()));
            piscofins.setTpRetPisCofins(nota.getLiNotafiscal().getNotaNacional().getTpRetPiscofinsNfn().codigo);
            piscofins.setPAliqPis(BuildXmlUtils.format((Double)nota.getLiNotafiscal().getAliquotapisNfs()));
            piscofins.setVPis(BuildXmlUtils.format((Double)nota.getLiNotafiscal().getValorpisNfs()));
            piscofins.setPAliqCofins(BuildXmlUtils.format((Double)nota.getLiNotafiscal().getAliquotacofinsNfs()));
            piscofins.setVCofins(BuildXmlUtils.format((Double)nota.getLiNotafiscal().getValorcofinsNfs()));
            tribFed.setPiscofins(piscofins);
        }
        return tribFed;
    }

    private TCTribMunicipal buildTributosMunicipais(NotaEnvioVO nota) {
        TCTribMunicipal tribMun = this.factory_v1_01.createTCTribMunicipal();
        TributacaoIssqn notaTribIssqn = nota.getTribIssqnNfn();
        tribMun.setTribISSQN(notaTribIssqn.codigo);
        tribMun.setTpImunidade(notaTribIssqn == TributacaoIssqn.IMUNIDADE ? nota.getTpImunidadeNfn().codigo : null);
        tribMun.setTpRetISSQN(nota.tipoRetencaoISSQN().codigo);
        TCBeneficioMunicipal tCBeneficioMunicipal = this.factory_v1_01.createTCBeneficioMunicipal();
        return tribMun;
    }

    private TCServ buildServico(NotaEnvioVO nota) {
        TCServ serv = this.factory_v1_01.createTCServ();
        TCLocPrest locPrest = this.factory_v1_01.createTCLocPrest();
        String municipioPrest = BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getCdMunicipioprestacaoNfs());
        locPrest.setCLocPrestacao(municipioPrest);
        if (municipioPrest == null) {
            Integer cdPaisPrestacao = nota.getLiNotafiscal().getCdPaisprestacaoNfs();
            if (cdPaisPrestacao == null) {
                throw new NotaInaptaException("Ou o munic\u00edpio, ou o pa\u00eds de presta\u00e7\u00e3o devem ser informados na nota!", nota.getLiNotafiscal());
            }
            if (cdPaisPrestacao == 1058) {
                throw new NotaInaptaException("Pa\u00eds da presta\u00e7\u00e3o informado como Brasil, mas munic\u00edpio n\u00e3o informado!", nota.getLiNotafiscal());
            }
            locPrest.setCPaisPrestacao(this.utilService.findIso2ByCodBce(cdPaisPrestacao));
        }
        serv.setLocPrest(locPrest);
        TCCServ cServ = this.factory_v1_01.createTCCServ();
        cServ.setCTribNac(nota.getCodigoTributacao());
        cServ.setXDescServ(String.format("<![CDATA[%s]]>", StringEscapeUtils.escapeXml11((String)BuildXmlUtils.strip((String)nota.getDescricaoServico()))));
        if (this.isObrigatorioInformarNBS(nota)) {
            cServ.setCNBS(Objects.requireNonNull(nota.getCodigoNBS(), "NBS nulo!"));
        }
        serv.setCServ(cServ);
        if (DPSBuildService_v1_01.isObrigatorioInformarComExt((NotaEnvioVO)nota)) {
            serv.setComExt(this.buildInfosComercioExterior(nota));
        }
        if (DPSBuildService_v1_01.isObrigatorioInformarObra((NotaEnvioVO)nota)) {
            serv.setObra(this.buildObra(nota));
        }
        if (DPSBuildService_v1_01.isObrigatorioInformarAtvEvento((NotaEnvioVO)nota)) {
            serv.setAtvEvento(this.buildAtvEvento(nota));
        }
        return serv;
    }

    private boolean isObrigatorioInformarNBS(NotaEnvioVO nota) {
        TipoEmitenteDPS tpEmit = NFSeUtil.parseTipoEmitente((LiNotafiscal)nota.getLiNotafiscal());
        if (tpEmit == TipoEmitenteDPS.PRESTADOR) {
            Integer paisIntermediario;
            Integer paisTomador = nota.getLiNotafiscal().getCdPaistomadorNfs();
            if (paisTomador != null && paisTomador != 1058) {
                return true;
            }
            LiNotaintermediario intermediario = nota.getLiNotafiscal().getIntermediario();
            if (intermediario != null && (paisIntermediario = intermediario.getCdPaisNit()) != null && paisIntermediario != 1058) {
                return true;
            }
            Integer paisPrestacao = nota.getLiNotafiscal().getCdPaisprestacaoNfs();
            if (paisPrestacao != null && paisPrestacao != 1058) {
                return true;
            }
        } else if (tpEmit == TipoEmitenteDPS.TOMADOR || tpEmit == TipoEmitenteDPS.INTERMEDIARIO) {
            Integer paisPrestador = tpEmit == TipoEmitenteDPS.TOMADOR ? nota.getLiNotafiscal().getCdPaistomadorNfs() : nota.getGrContribuintes().getCodPaisCnt();
            if (paisPrestador != null && paisPrestador != 1058) {
                return true;
            }
            Integer paisPrestacao = nota.getLiNotafiscal().getCdPaisprestacaoNfs();
            if (paisPrestacao != null && paisPrestacao != 1058) {
                return true;
            }
        }
        return false;
    }

    private boolean isObrigatorioInformarInfoCompl(NotaEnvioVO nota) {
        TipoEmitenteDPS tpEmit = NFSeUtil.parseTipoEmitente((LiNotafiscal)nota.getLiNotafiscal());
        return tpEmit == TipoEmitenteDPS.TOMADOR || tpEmit == TipoEmitenteDPS.INTERMEDIARIO;
    }

    private TCInfoCompl buildInfoCompl(NotaEnvioVO nota) {
        TCInfoCompl infoCompl = this.factory_v1_01.createTCInfoCompl();
        infoCompl.setIdDocTec(nota.getLiNotafiscal().getNumeroArtNfs());
        infoCompl.setDocRef(null);
        String obs = nota.getLiNotafiscal().getObsNfs();
        infoCompl.setXInfComp(StringUtils.length((CharSequence)obs) < 2000 ? obs : null);
        return infoCompl;
    }

    private static boolean isObrigatorioInformarAtvEvento(NotaEnvioVO nota) {
        String codigoTrib = nota.getCodigoTributacao();
        return codigoTrib.startsWith("12");
    }

    private TCAtvEvento buildAtvEvento(NotaEnvioVO nota) {
        TCAtvEvento atvEvento = this.factory_v1_01.createTCAtvEvento();
        LiNotafiscalNacional liNotaNacional = nota.getLiNotafiscal().getNotaNacional();
        atvEvento.setXNome(liNotaNacional.getNomeEvtoNfn());
        atvEvento.setDtIni(BuildXmlUtils.formatToDate((LocalDate)liNotaNacional.getDatainiEvtoNfn()));
        atvEvento.setDtFim(BuildXmlUtils.formatToDate((LocalDate)liNotaNacional.getDatafimEvtoNfn()));
        if (liNotaNacional.getIdEvtoNfn() != null) {
            atvEvento.setIdAtvEvt(liNotaNacional.getIdEvtoNfn());
        } else {
            TCEnderecoSimples end = this.factory_v1_01.createTCEnderecoSimples();
            end.setXLgr(liNotaNacional.getLograEvtoNfn());
            end.setNro(liNotaNacional.getNroEvtoNfn());
            end.setXCpl(liNotaNacional.getComplEvtoNfn());
            end.setXBairro(liNotaNacional.getBairroEvtoNfn());
            if (StringUtils.isNotBlank((CharSequence)liNotaNacional.getCepEvtoNfn())) {
                end.setCEP(liNotaNacional.getCepEvtoNfn());
            } else {
                TCEnderExtSimples endExt = this.factory_v1_01.createTCEnderExtSimples();
                endExt.setCEndPost(liNotaNacional.getCpostextEvtoNfn());
                endExt.setXCidade(liNotaNacional.getCidextEvtoNfn());
                endExt.setXEstProvReg(liNotaNacional.getProvextEvtoNfn());
                end.setEndExt(endExt);
            }
            atvEvento.setEnd(end);
        }
        return atvEvento;
    }

    private static boolean isObrigatorioInformarObra(NotaEnvioVO nota) {
        List<String> codigosObrigatorios = List.of("070201", "070202", "070401", "070501", "070502", "070601", "070602", "070701", "070801", "071701", "071901");
        return codigosObrigatorios.contains(nota.getCodigoTributacao());
    }

    private TCInfoObra buildObra(NotaEnvioVO nota) {
        TCInfoObra obra = this.factory_v1_01.createTCInfoObra();
        obra.setInscImobFisc(nota.getLiNotafiscal().getNotaNacional().getInscObraNfn());
        if (nota.getLiNotafiscal().getNotaNacional().getCibObraNfn() != null) {
            obra.setCCIB(nota.getLiNotafiscal().getNotaNacional().getCibObraNfn());
        } else if (nota.getLiNotafiscal().getNotaNacional().getCodigoObraNfn() != null) {
            obra.setCObra(nota.getLiNotafiscal().getNotaNacional().getCodigoObraNfn());
        } else {
            obra.setEnd(this.buildEnderecoObra(nota));
        }
        return obra;
    }

    private TCEnderObraEvento buildEnderecoObra(NotaEnvioVO nota) {
        TCEnderObraEvento end = this.factory_v1_01.createTCEnderObraEvento();
        LiNotafiscalNacional notaNacional = nota.getLiNotafiscal().getNotaNacional();
        end.setXLgr(BuildXmlUtils.strip((String)notaNacional.getLograObraNfn()));
        end.setNro(BuildXmlUtils.strip((String)notaNacional.getNroObraNfn()));
        end.setXCpl(BuildXmlUtils.strip((String)notaNacional.getComplObraNfn()));
        end.setXBairro(BuildXmlUtils.strip((String)notaNacional.getBairroObraNfn()));
        if (StringUtils.isNotBlank((CharSequence)notaNacional.getCepObraNfn())) {
            end.setCEP(notaNacional.getCepObraNfn());
        } else {
            TCEnderExtSimples endExt = this.factory_v1_01.createTCEnderExtSimples();
            endExt.setCEndPost(notaNacional.getCpostextObraNfn());
            endExt.setXCidade(notaNacional.getCidextObraNfn());
            endExt.setXEstProvReg(notaNacional.getProvextObraNfn());
            end.setEndExt(endExt);
        }
        return end;
    }

    private static boolean isObrigatorioInformarComExt(NotaEnvioVO nota) {
        Integer cdPaisTomador;
        Integer cdPaisPrestador;
        TipoEmitenteDPS tipoEmitente = NFSeUtil.parseTipoEmitente((LiNotafiscal)nota.getLiNotafiscal());
        if (tipoEmitente == TipoEmitenteDPS.TOMADOR) {
            cdPaisPrestador = nota.getLiNotafiscal().getCdPaistomadorNfs();
            cdPaisTomador = nota.getGrContribuintes().getCodPaisCnt();
        } else {
            cdPaisPrestador = nota.getGrContribuintes().getCodPaisCnt();
            cdPaisTomador = nota.getLiNotafiscal().getCdPaistomadorNfs();
        }
        Integer cdPaisIntermediario = null;
        if (nota.getLiNotafiscal().getIntermediario() != null) {
            cdPaisIntermediario = nota.getLiNotafiscal().getIntermediario().getCdPaisNit();
        }
        Integer cdPaisPrestacao = nota.getLiNotafiscal().getCdPaisprestacaoNfs();
        TributacaoIssqn tributacaoIssqn = nota.getTribIssqnNfn();
        return tipoEmitente == TipoEmitenteDPS.PRESTADOR && (cdPaisTomador != null && cdPaisTomador != 1058 || cdPaisIntermediario != null && cdPaisIntermediario != 1058 || cdPaisPrestacao != null && cdPaisPrestacao != 1058 || tributacaoIssqn == TributacaoIssqn.EXPORTACAO_DE_SERVICO) || (tipoEmitente == TipoEmitenteDPS.TOMADOR || tipoEmitente == TipoEmitenteDPS.INTERMEDIARIO) && (cdPaisPrestador != null && cdPaisPrestador != 1058 || cdPaisPrestacao != null && cdPaisPrestacao != 1058);
    }

    private TCComExterior buildInfosComercioExterior(NotaEnvioVO nota) {
        TCComExterior comExt = this.factory_v1_01.createTCComExterior();
        LiNotafiscalNacional liNotaNacional = nota.getLiNotafiscal().getNotaNacional();
        comExt.setMdPrestacao(Objects.requireNonNull(liNotaNacional.getMdprestacaoComextNfn(), (String)"Necess\u00e1rio informar o modo de presta\u00e7\u00e3o de com\u00e9rcio exterior").codigo);
        comExt.setVincPrest(Objects.requireNonNull(liNotaNacional.getVincprestComextNfn(), (String)"Necess\u00e1rio informar o v\u00ednculo entre as partes do com\u00e9rcio exterior").codigo);
        comExt.setTpMoeda(Objects.requireNonNull(liNotaNacional.getTpmoedaComextNfn(), "Necess\u00e1rio informar o tipo da moeda usado no com\u00e9rcio exterior"));
        comExt.setVServMoeda(BuildXmlUtils.format((Double)Objects.requireNonNull(liNotaNacional.getVservmoedaComextNfn(), "Necess\u00e1rio informar o valor do servi\u00e7o especificado na moeda")));
        comExt.setMecAFComexP(Objects.requireNonNull(liNotaNacional.getMecafprestComextNfn(), (String)"Necess\u00e1rio informar o mecanismo de apoio ao com\u00e9rcio exterior do prestador").codigo);
        comExt.setMecAFComexT(Objects.requireNonNull(liNotaNacional.getMecaftomaComextNfn(), (String)"").codigo);
        comExt.setMovTempBens(Objects.requireNonNull(liNotaNacional.getVincmovbensComextNfn(), (String)"").codigo);
        comExt.setNDI(liNotaNacional.getNdiComextNfn());
        comExt.setNRE(liNotaNacional.getNreComextNfn());
        comExt.setMdic(liNotaNacional.getMdicComextNfn() == SimNao.SIM ? "1" : "0");
        return comExt;
    }

    private String generateIdDPS(TCInfDPS infDPS) {
        String cpfCnpj = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$schema$enums$TipoEmitenteDPS[TipoEmitenteDPS.of((String)infDPS.getTpEmit()).ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> (String)StringUtils.defaultIfBlank((CharSequence)infDPS.getPrest().getCNPJ(), (CharSequence)infDPS.getPrest().getCPF());
            case 2 -> (String)StringUtils.defaultIfBlank((CharSequence)infDPS.getToma().getCNPJ(), (CharSequence)infDPS.getToma().getCPF());
            case 3 -> (String)StringUtils.defaultIfBlank((CharSequence)infDPS.getInterm().getCNPJ(), (CharSequence)infDPS.getInterm().getCPF());
        };
        Integer codigoMunicipio = this.entidadeVO.getMunicipio().getCdMunicipio();
        int tipoInscricao = cpfCnpj.length() == 14 ? 2 : 1;
        String inscricaoFederal = StringUtils.leftPad((String)cpfCnpj, (int)14, (char)'0');
        String serieDps = StringUtils.leftPad((String)infDPS.getSerie(), (int)5, (char)'0');
        String numeroDps = StringUtils.leftPad((String)infDPS.getNDPS(), (int)15, (char)'0');
        return "DPS" + codigoMunicipio + tipoInscricao + inscricaoFederal + serieDps + numeroDps;
    }

    private TCInfoPrestador preencherPrestador(NotaEnvioVO nota, TipoEmitenteDPS tipoEmitenteDPS) {
        Integer codigoPais;
        boolean isNotaTomador = nota.getLiNotafiscal().getTiponotaNfs() == TipoNota.DEC_TOMADOR;
        TCInfoPrestador prest = this.factory_v1_01.createTCInfoPrestador();
        String documento = (isNotaTomador ? nota.getLiNotafiscal().getCpfCnpjNfs() : nota.getGrContribuintes().getCnpjCnt()).replaceAll("\\D", "");
        Integer n = codigoPais = isNotaTomador ? nota.getLiNotafiscal().getCdPaistomadorNfs() : nota.getGrContribuintes().getCodPaisCnt();
        if (codigoPais == null || codigoPais == 1058) {
            if (documento.length() == 14) {
                prest.setCNPJ(documento);
            } else if (documento.length() == 11) {
                prest.setCPF(documento);
            }
        } else {
            if (tipoEmitenteDPS == TipoEmitenteDPS.PRESTADOR) {
                throw new NotaInaptaException("O prestador emitente n\u00e3o pode ser identificado pelo NIF (deve possuir CNPJ/CPF)!", nota.getLiNotafiscal());
            }
            prest.setNIF(documento);
        }
        prest.setIM(nota.getInscricaoMunicipalCadastro());
        if (tipoEmitenteDPS != TipoEmitenteDPS.PRESTADOR) {
            prest.setXNome(nota.getGrContribuintes().getNomeCnt());
        }
        String fone = isNotaTomador ? nota.getLiNotafiscal().getFoneNfs() : nota.getFoneCadastro();
        prest.setFone(BuildXmlUtils.nullBlank((String)BuildXmlUtils.removeNonDigits((String)fone)));
        String email = isNotaTomador ? nota.getLiNotafiscal().getEmailNfs() : nota.getEmailCadastro();
        prest.setEmail(StringEscapeUtils.escapeXml11((String)BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)email))));
        if (tipoEmitenteDPS != TipoEmitenteDPS.PRESTADOR) {
            prest.setEnd(this.buildEnderecoPrestador(nota, prest, isNotaTomador));
        }
        prest.setRegTrib(this.buildRegTribPrestador(nota));
        return prest;
    }

    private TCEndereco buildEnderecoPrestador(NotaEnvioVO nota, TCInfoPrestador prest, boolean isNotaTomador) {
        TCEndereco end = this.factory_v1_01.createTCEndereco();
        if (prest.getCNPJ() != null) {
            TCEnderNac endNac = this.factory_v1_01.createTCEnderNac();
            endNac.setCEP(isNotaTomador ? nota.getLiNotafiscal().getCepNfs().replaceAll("\\D", "") : nota.getCepCadastro());
            endNac.setCMun(isNotaTomador ? BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getCdMunicipiotomadorNfs()) : nota.getCodCidCadastro());
            end.setEndNac(endNac);
        } else if (prest.getNIF() != null) {
            TCEnderExt endExt = this.factory_v1_01.createTCEnderExt();
            endExt.setCPais(this.utilService.findIso2ByCodBce(isNotaTomador ? nota.getLiNotafiscal().getCdPaistomadorNfs() : nota.getGrContribuintes().getCodPaisCnt()));
            endExt.setCEndPost(isNotaTomador ? nota.getLiNotafiscal().getCepNfs() : nota.getCepCadastro());
            endExt.setXCidade(isNotaTomador ? nota.getLiNotafiscal().getMunicipioNfs() : nota.getGrContribuintes().getNomCidCnt());
            endExt.setXEstProvReg(nota.getLiNotafiscal().getNotaNacional().getProvextPrestNfn());
            end.setEndExt(endExt);
        }
        String logradouro = isNotaTomador ? nota.getLiNotafiscal().getLogradouroNfs() : nota.getLogradouroCadastro();
        end.setXLgr(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)logradouro)));
        end.setNro(BuildXmlUtils.strip((String)(isNotaTomador ? nota.getLiNotafiscal().getNumeroNfs() : nota.getNroEndCadastro())));
        String complemento = isNotaTomador ? nota.getLiNotafiscal().getComplementoNfs() : nota.getComplEndCadastro();
        end.setXCpl(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)complemento)));
        String bairro = isNotaTomador ? nota.getLiNotafiscal().getBairroNfs() : nota.getBairroCadastro();
        end.setXBairro(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)bairro)));
        return end;
    }

    private TCRegTrib buildRegTribPrestador(NotaEnvioVO nota) {
        TCRegTrib regTrib = this.factory_v1_01.createTCRegTrib();
        SituacaoSimplesNacional optanteSimples = nota.optanteSimples();
        regTrib.setOpSimpNac(optanteSimples.codigo);
        regTrib.setRegEspTrib(NFSeUtil.regimeNossoParaNacional((RegimeEspecialTributacao)nota.getLiNotafiscal().getRegimeespecialtribNfs()).codigo);
        if (!Objects.equals(nota.getTribIssqnNfn(), TributacaoIssqn.OPERACAO_TRIBUTAVEL)) {
            regTrib.setRegEspTrib(RegimeEspecialTributacaoNacional.NENHUM.codigo);
        }
        nota.getLiNotafiscal().getNotaNacional().setRegaptribSnNfn(nota.getRegimeApuracaoSimples());
        if (optanteSimples == SituacaoSimplesNacional.OPTANTE_MEEPP) {
            regTrib.setRegApTribSN(Objects.requireNonNull(nota.getLiNotafiscal().getNotaNacional().getRegaptribSnNfn(), (String)"Prestador \u00e9 ME/EPP e optante do simples, mas n\u00e3o foi informado o regime de apura\u00e7\u00e3o").codigo);
        }
        return regTrib;
    }

    private TCInfoPessoa preencherTomador(NotaEnvioVO nota) {
        TCInfoPessoa toma = this.factory_v1_01.createTCInfoPessoa();
        String documento = RegExUtils.replaceAll((String)nota.getDocumentoTomador(), (String)"\\D", (String)"");
        Integer codigoPais = nota.getPaisTomador();
        if (codigoPais == null || codigoPais == 1058) {
            if (documento.length() == 14) {
                toma.setCNPJ(documento);
            } else if (documento.length() == 11) {
                toma.setCPF(documento);
            }
        } else {
            toma.setNIF(documento);
        }
        String xnome = nota.getNomeTomador();
        toma.setXNome(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)xnome)));
        String fone = nota.getFoneTomador();
        toma.setFone(BuildXmlUtils.nullBlank((String)BuildXmlUtils.removeNonDigits((String)fone)));
        String email = nota.getEmailTomador();
        toma.setEmail(StringEscapeUtils.escapeXml11((String)BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)email))));
        toma.setEnd(this.buildEnderecoTomador(nota, toma, nota.isNotaTomador()));
        return toma;
    }

    private TCEndereco buildEnderecoTomador(NotaEnvioVO nota, TCInfoPessoa toma, boolean isNotaTomador) {
        TCEndereco end = this.factory_v1_01.createTCEndereco();
        if (toma.getCNPJ() != null) {
            TCEnderNac endNac = this.factory_v1_01.createTCEnderNac();
            endNac.setCEP(isNotaTomador ? nota.getCepCadastro() : nota.getLiNotafiscal().getCepNfs().replaceAll("\\D", ""));
            endNac.setCMun(isNotaTomador ? nota.getCodCidCadastro() : BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getCdMunicipiotomadorNfs()));
            end.setEndNac(endNac);
        } else if (toma.getNIF() != null) {
            TCEnderExt endExt = this.factory_v1_01.createTCEnderExt();
            endExt.setCPais(this.utilService.findIso2ByCodBce(isNotaTomador ? nota.getGrContribuintes().getCodPaisCnt() : nota.getLiNotafiscal().getCdPaistomadorNfs()));
            endExt.setCEndPost(isNotaTomador ? nota.getCepCadastro() : nota.getLiNotafiscal().getCepNfs());
            endExt.setXCidade(isNotaTomador ? nota.getGrContribuintes().getNomCidCnt() : nota.getLiNotafiscal().getMunicipioNfs());
            endExt.setXEstProvReg(nota.getLiNotafiscal().getEstadoProvinciaNfs());
            end.setEndExt(endExt);
        }
        String logradouro = isNotaTomador ? nota.getLogradouroCadastro() : nota.getLiNotafiscal().getLogradouroNfs();
        end.setXLgr(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)logradouro)));
        end.setNro(BuildXmlUtils.strip((String)(isNotaTomador ? nota.getNroEndCadastro() : nota.getLiNotafiscal().getNumeroNfs())));
        String complemento = isNotaTomador ? nota.getComplEndCadastro() : nota.getLiNotafiscal().getComplementoNfs();
        end.setXCpl(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)complemento)));
        String bairro = isNotaTomador ? nota.getBairroCadastro() : nota.getLiNotafiscal().getBairroNfs();
        end.setXBairro(BuildXmlUtils.strip((String)BuildXmlUtils.nullBlank((String)bairro)));
        return end;
    }

    private TCInfoPessoa preencherIntermediario(NotaEnvioVO nota) {
        TCInfoPessoa interm = this.factory_v1_01.createTCInfoPessoa();
        String documento = Objects.requireNonNull(nota.getLiNotafiscal().getIntermediario().getCpfCnpjNit(), "Documento do intermedi\u00e1rio n\u00e3o informado").replaceAll("\\D", "");
        if (nota.getLiNotafiscal().getIntermediario().getForapaisNit() == SimNao.SIM) {
            interm.setNIF(documento);
        } else if (documento.length() == 14) {
            interm.setCNPJ(documento);
        } else {
            interm.setCPF(documento);
        }
        interm.setIM(nota.getLiNotafiscal().getIntermediario().getInscrmNit());
        interm.setXNome(nota.getLiNotafiscal().getIntermediario().getNomeRazaosocialNit());
        interm.setFone(nota.getLiNotafiscal().getIntermediario().getFoneNit());
        interm.setEmail(StringEscapeUtils.escapeXml11((String)BuildXmlUtils.strip((String)nota.getLiNotafiscal().getIntermediario().getEmailNit())));
        interm.setEnd(this.buildEnderecoIntermediario(nota));
        return interm;
    }

    private TCEndereco buildEnderecoIntermediario(NotaEnvioVO nota) {
        TCEndereco end = this.factory_v1_01.createTCEndereco();
        end.setXLgr(nota.getLiNotafiscal().getIntermediario().getLogradouroNit());
        end.setNro(BuildXmlUtils.strip((String)nota.getLiNotafiscal().getIntermediario().getNumeroNit()));
        end.setXCpl(nota.getLiNotafiscal().getIntermediario().getComplementoNit());
        end.setXBairro(nota.getLiNotafiscal().getIntermediario().getBairroNit());
        if (nota.getLiNotafiscal().getIntermediario().getForapaisNit() == SimNao.SIM) {
            TCEnderExt endExt = this.factory_v1_01.createTCEnderExt();
            endExt.setCPais(this.utilService.findIso2ByCodBce(nota.getLiNotafiscal().getIntermediario().getCdPaisNit()));
            endExt.setXCidade(nota.getLiNotafiscal().getIntermediario().getMunicipioNit());
            endExt.setXEstProvReg(nota.getLiNotafiscal().getIntermediario().getEstadoProvinciaNit());
            endExt.setCEndPost(nota.getLiNotafiscal().getNotaNacional().getCpostextInterNfn());
            end.setEndExt(endExt);
        } else {
            TCEnderNac endNac = this.factory_v1_01.createTCEnderNac();
            endNac.setCMun(BuildXmlUtils.numToString((Number)nota.getLiNotafiscal().getIntermediario().getMunicipio().getCdMunicipio()));
            endNac.setCEP(nota.getLiNotafiscal().getIntermediario().getCepNit().replaceAll("\\D", ""));
            end.setEndNac(endNac);
        }
        return end;
    }

    public DPSBuildService_v1_01(EntidadeVO entidadeVO, ObjectFactory factory_v1_01, UtilService utilService) {
        this.entidadeVO = entidadeVO;
        this.factory_v1_01 = factory_v1_01;
        this.utilService = utilService;
    }
}

