/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.client.AdnClient;
import br.com.fiorilli.nfse_nacional.dto.nfse.DfeResponse;
import br.com.fiorilli.nfse_nacional.dto.nfse.EnviarLoteRequest;
import br.com.fiorilli.nfse_nacional.dto.nfse.LoteDFe;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiNfseEnvioLog;
import br.com.fiorilli.nfse_nacional.model.LiNfseEnvioQueue;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.model.enums.StatusImportacaoEnvio;
import br.com.fiorilli.nfse_nacional.model.enums.StatusNfseQueue;
import br.com.fiorilli.nfse_nacional.services.DfeEnvioService;
import br.com.fiorilli.nfse_nacional.services.EventoEnvioService_v1_00;
import br.com.fiorilli.nfse_nacional.services.EventoEnvioService_v1_01;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService_v1_00;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService_v1_01;
import br.com.fiorilli.nfse_nacional.services.data.LiNfseEnvioLogService;
import br.com.fiorilli.nfse_nacional.services.data.LiNfseEnvioQueueService;
import br.com.fiorilli.nfse_nacional.utils.ZipUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.xml.transform.StringSource;

@Service
public class DfeEnvioService {
    private static final Logger log = LoggerFactory.getLogger(DfeEnvioService.class);
    private final TaskScheduler nfseTaskScheduler;
    private final AdnClient adnClient;
    private final LiNfseEnvioQueueService liNfseEnvioQueueService;
    private final NotaFiscalEnvioService_v1_00 notaFiscalEnvioService_v1_00;
    private final NotaFiscalEnvioService_v1_01 notaFiscalEnvioService_v1_01;
    private final EventoEnvioService_v1_00 eventoEnvioService_v1_00;
    private final EventoEnvioService_v1_01 eventoEnvioService_v1_01;
    private final AtomicInteger count = new AtomicInteger(0);
    private final ExecutorService envioThread = Executors.newSingleThreadExecutor();
    private final LiNfseEnvioLogService liNfseEnvioLogService;
    private final Validator nfseXsdValidator_v1_00;
    private final Validator nfseXsdValidator_v1_01;
    private final Validator eventoXsdValidator_v1_00;
    private final Validator eventoXsdValidator_v1_01;
    private ScheduledFuture<?> scheduledTask;

    @PostConstruct
    public void init() {
        this.scheduledTask = this.nfseTaskScheduler.scheduleAtFixedRate(() -> this.envioThread.submit(() -> this.checkAndSend()), Duration.ofSeconds(10L));
    }

    @PreDestroy
    public void destroy() {
        this.scheduledTask.cancel(false);
        this.envioThread.shutdown();
    }

    public void checkCountEmissao() {
        if (this.count.incrementAndGet() >= 1) {
            this.envioThread.submit(() -> this.checkAndSend());
        }
    }

    public synchronized void checkAndSend() {
        try {
            List envios = this.liNfseEnvioQueueService.queryFirstEnvios(50);
            if (envios.isEmpty()) {
                log.debug("Nenhum lote a ser enviado!");
                return;
            }
            for (LiNfseEnvioQueue envio : envios) {
                this.prepareAndSend(envio);
            }
            this.count.addAndGet(-envios.size());
        }
        catch (Exception e) {
            log.error("Erro no processo de envio", (Throwable)e);
            throw e;
        }
    }

    private void prepareAndSend(LiNfseEnvioQueue envio) {
        try {
            String xml;
            if ("1.01".equals(envio.getVersaoXmlNeq())) {
                xml = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TipoDocumentoEnvio[envio.getTipoDocNeq().ordinal()]) {
                    default -> throw new MatchException(null, null);
                    case 1 -> {
                        x = this.eventoEnvioService_v1_01.prepararCancelamento(envio.getLiNotafiscal().getCancelamento());
                        this.eventoXsdValidator_v1_01.validate((Source)new StringSource(x));
                        yield x;
                    }
                    case 2 -> {
                        x = this.notaFiscalEnvioService_v1_01.prepararEnvio(envio.getLiNotafiscal());
                        this.nfseXsdValidator_v1_01.validate((Source)new StringSource(x));
                        yield x;
                    }
                };
            } else if ("1.00".equals(envio.getVersaoXmlNeq()) || StringUtils.isBlank((CharSequence)envio.getVersaoXmlNeq())) {
                xml = switch (1.$SwitchMap$br$com$fiorilli$nfse_nacional$model$enums$TipoDocumentoEnvio[envio.getTipoDocNeq().ordinal()]) {
                    default -> throw new MatchException(null, null);
                    case 1 -> x = this.eventoEnvioService_v1_00.prepararCancelamento(envio.getLiNotafiscal().getCancelamento());
                    case 2 -> x = this.notaFiscalEnvioService_v1_00.prepararEnvio(envio.getLiNotafiscal());
                };
            } else {
                throw new IllegalArgumentException("Vers\u00e3o '" + envio.getVersaoXmlNeq() + "' do XSD n\u00e3o suportada!");
            }
            envio.setXml(xml);
            String compressedEncodedXml = new String(Base64.getEncoder().encode(ZipUtils.compressUTF8((String)xml)), StandardCharsets.UTF_8);
            this.sendAndProcess(List.of(compressedEncodedXml), List.of(envio));
        }
        catch (Exception e) {
            log.error("Erro no preparo ou envio da nota {} : {}", new Object[]{envio.getLiNotafiscal().getPk(), e.getMessage(), e});
            this.marcarErroPreEnvio(envio, e.getMessage());
            this.liNfseEnvioQueueService.batchSave(List.of(envio));
        }
    }

    private void sendAndProcess(List<String> compressedEncodedXmls, List<LiNfseEnvioQueue> envios) {
        ResponseEntity res = this.adnClient.enviarLote(new EnviarLoteRequest(compressedEncodedXmls));
        if (res.getStatusCode().is2xxSuccessful()) {
            DfeResponse retorno = (DfeResponse)res.getBody();
            if (retorno == null) {
                throw new FiorilliException("Resposta nula da API");
            }
            for (int i = 0; i < retorno.getLote().size(); ++i) {
                LoteDFe lote = (LoteDFe)retorno.getLote().get(i);
                LiNfseEnvioQueue envio = envios.get(i);
                if (lote.getStatusProcessamento().equals("PROCESSADO_COM_ERROS")) {
                    this.marcarErroNoEnvio(envio, lote.getErros().stream().map(err -> err.toString().trim()).collect(Collectors.joining("\n")));
                    continue;
                }
                if (lote.getStatusProcessamento().equals("PROCESSADO_COM_SUCESSO")) {
                    this.marcarSucessoNoEnvio(envio);
                    continue;
                }
                throw new FiorilliException("Status de processamento inesperado: " + lote.getStatusProcessamento());
            }
            this.liNfseEnvioQueueService.batchSave(envios);
            List logs = envios.stream().map(LiNfseEnvioQueue::getLiNfseEnvioLog).filter(Objects::nonNull).collect(Collectors.toList());
            this.liNfseEnvioLogService.batchSave(logs);
        }
        if (log.isDebugEnabled()) {
            log.debug("Resposta do envio: {}", (Object)res);
        }
    }

    public void marcarErroPreEnvio(LiNfseEnvioQueue envio, String erro) {
        envio.setStatusNeq(StatusNfseQueue.NAO_ENVIADO_ERROS);
        envio.setRetornoErroNeq(erro);
    }

    public void marcarErroNoEnvio(LiNfseEnvioQueue envio, String erro) {
        envio.setStatusNeq(StatusNfseQueue.ENVIADO_ERROS);
        envio.setRetornoErroNeq(erro);
        envio.setLiNfseEnvioLog(LiNfseEnvioLog.builder().liNotafiscal(envio.getLiNotafiscal()).tipoDocNen(envio.getTipoDocNeq()).xmlNen(envio.getXml()).statusNen(StatusImportacaoEnvio.ERRO).build());
    }

    public void marcarSucessoNoEnvio(LiNfseEnvioQueue envio) {
        if (envio.getLiNotafiscal() != null && envio.getLiNotafiscal().getNotaNacional() != null) {
            envio.getLiNotafiscal().getNotaNacional().setStatusEnvioNac(StatusEnvioNotaNacional.ENVIADA);
        }
        envio.setStatusNeq(null);
        envio.setLiNfseEnvioLog(LiNfseEnvioLog.builder().liNotafiscal(envio.getLiNotafiscal()).tipoDocNen(envio.getTipoDocNeq()).xmlNen(envio.getXml()).statusNen(StatusImportacaoEnvio.SUCESSO).build());
    }

    public DfeEnvioService(TaskScheduler nfseTaskScheduler, AdnClient adnClient, LiNfseEnvioQueueService liNfseEnvioQueueService, NotaFiscalEnvioService_v1_00 notaFiscalEnvioService_v1_00, NotaFiscalEnvioService_v1_01 notaFiscalEnvioService_v1_01, EventoEnvioService_v1_00 eventoEnvioService_v1_00, EventoEnvioService_v1_01 eventoEnvioService_v1_01, LiNfseEnvioLogService liNfseEnvioLogService, Validator nfseXsdValidator_v1_00, Validator nfseXsdValidator_v1_01, Validator eventoXsdValidator_v1_00, Validator eventoXsdValidator_v1_01) {
        this.nfseTaskScheduler = nfseTaskScheduler;
        this.adnClient = adnClient;
        this.liNfseEnvioQueueService = liNfseEnvioQueueService;
        this.notaFiscalEnvioService_v1_00 = notaFiscalEnvioService_v1_00;
        this.notaFiscalEnvioService_v1_01 = notaFiscalEnvioService_v1_01;
        this.eventoEnvioService_v1_00 = eventoEnvioService_v1_00;
        this.eventoEnvioService_v1_01 = eventoEnvioService_v1_01;
        this.liNfseEnvioLogService = liNfseEnvioLogService;
        this.nfseXsdValidator_v1_00 = nfseXsdValidator_v1_00;
        this.nfseXsdValidator_v1_01 = nfseXsdValidator_v1_01;
        this.eventoXsdValidator_v1_00 = eventoXsdValidator_v1_00;
        this.eventoXsdValidator_v1_01 = eventoXsdValidator_v1_01;
    }
}

