/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.model.GrCadEmpresa;
import br.com.fiorilli.nfse_nacional.model.Municipio;
import br.com.fiorilli.nfse_nacional.services.data.NfsePersistenceManager;
import br.com.fiorilli.nfse_nacional.utils.FiorilliUtils;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmpresaService {
    private static final Logger log = LoggerFactory.getLogger(EmpresaService.class);
    private final NfsePersistenceManager nfsePersistenceManager;

    public GrCadEmpresa recuperarEmpresa() {
        log.trace("Recuperando empresa do banco");
        GrCadEmpresa grCadEmpresa = (GrCadEmpresa)((Optional)this.nfsePersistenceManager.call(em -> Optional.ofNullable((GrCadEmpresa)em.find(GrCadEmpresa.class, (Object)1)).map(emp -> {
            if (emp.getDatainiConvnfsenacEmp() == null) {
                emp.setDatainiConvnfsenacEmp(LocalDate.now());
                em.merge(emp);
            }
            return emp;
        }), false)).orElseThrow(() -> new IllegalStateException("Dados da empresa n\u00e3o encontrados! N\u00e3o \u00e9 poss\u00edvel iniciar a aplica\u00e7\u00e3o"));
        log.debug("Recuperado: {}", (Object)grCadEmpresa.getNomeEmp());
        return grCadEmpresa;
    }

    public EntidadeVO loadConfigs() {
        GrCadEmpresa grCadEmpresa = this.recuperarEmpresa();
        log.info("Carregando informa\u00e7\u00f5es para {}", (Object)grCadEmpresa.getNomeEmp());
        return EntidadeVO.builder().id(grCadEmpresa.getCodEmp()).nome(grCadEmpresa.getNomeEmp()).cnpj(grCadEmpresa.getCnpjEmp()).certificado(grCadEmpresa.getCertificadoDigital()).maskMobil(grCadEmpresa.getMascmobiEmp()).senhaCertificado(FiorilliUtils.cifrarDecifrar((String)grCadEmpresa.getSenhaCertificadoDigital())).codigoIbge(NumberUtils.createInteger((String)grCadEmpresa.getCidadeIbge())).dataInicioConvenio(grCadEmpresa.getDatainiConvnfsenacEmp()).municipio((Municipio)((Optional)this.nfsePersistenceManager.call(em -> Optional.ofNullable((Municipio)em.find(Municipio.class, (Object)NumberUtils.createInteger((String)grCadEmpresa.getCidadeIbge()))), true)).orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel encontrar MUNICIPIO para c\u00f3digo " + grCadEmpresa.getCidadeIbge() + " informado na empresa"))).build();
    }

    public EmpresaService(NfsePersistenceManager nfsePersistenceManager) {
        this.nfsePersistenceManager = nfsePersistenceManager;
    }
}

