/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.nfse_nacional.services;

import br.com.fiorilli.nfse_nacional.dto.servicosweb.EntidadeVO;
import br.com.fiorilli.nfse_nacional.exception.FiorilliException;
import br.com.fiorilli.nfse_nacional.model.LiNotasubcancelada;
import br.com.fiorilli.nfse_nacional.model.enums.MotivoNacionalCancelamento;
import br.com.fiorilli.nfse_nacional.model.enums.StatusEnvioNotaNacional;
import br.com.fiorilli.nfse_nacional.schema.v101.common.ObjectFactory;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCEvento;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCInfEvento;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCInfPedReg;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TCPedRegEvt;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TE101101;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TE105102;
import br.com.fiorilli.nfse_nacional.schema.v101.evento.TSCodigoEventoNFSe;
import br.com.fiorilli.nfse_nacional.services.FirebirdService;
import br.com.fiorilli.nfse_nacional.services.NotaFiscalEnvioService_v1_01;
import br.com.fiorilli.nfse_nacional.services.data.LiNotasubcanceladaService;
import br.com.fiorilli.nfse_nacional.utils.BuildXmlUtils;
import br.com.fiorilli.nfse_nacional.utils.XmlUtils;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventoEnvioService_v1_01 {
    private static final Logger log = LoggerFactory.getLogger(EventoEnvioService_v1_01.class);
    public static final String AMBIENTE_GERADOR_MUNICIPIO = "1";
    private final EntidadeVO entidadeVO;
    private final Jaxb2Marshaller EventoMarshaller_v1_01;
    private final Jaxb2Marshaller PedRegEventoMarshaller_v1_01;
    private final ObjectFactory factory_v1_01;
    private final FirebirdService firebirdService;
    private final LiNotasubcanceladaService liNotasubcanceladaService;
    @Value(value="${spring.profiles.active}")
    private String ambiente;
    @Value(value="${spring.application.version}")
    private String versaoNfse;

    public String apenasMontarXml(LiNotasubcancelada liNotasubcancelada) {
        TCPedRegEvt pedRegEvento = this.buildPedRegEvento(liNotasubcancelada);
        TCEvento evento = this.buildEvento(pedRegEvento, liNotasubcancelada);
        liNotasubcancelada.setNdfeNfn(Long.valueOf(evento.getInfEvento().getNDFe()));
        CompletableFuture.runAsync(() -> this.liNotasubcanceladaService.merge(liNotasubcancelada));
        return XmlUtils.xmlToString((Object)evento, (Marshaller)this.EventoMarshaller_v1_01);
    }

    public String prepararCancelamento(LiNotasubcancelada liNotasubcancelada) throws Exception {
        if (liNotasubcancelada.getCancelada().getNotaNacional().getStatusEnvioNac() == StatusEnvioNotaNacional.NAO_ENVIADA) {
            throw new FiorilliException("N\u00e3o \u00e9 poss\u00edvel enviar evento de cancelamento da nota sem enviar a nota primeiro");
        }
        byte[] pkcs12 = this.entidadeVO.getCertificado();
        char[] password = this.entidadeVO.getSenhaCertificado().toCharArray();
        TCPedRegEvt pedRegEvento = this.buildPedRegEvento(liNotasubcancelada);
        String stringPedRegEvento = BuildXmlUtils.removeNamespace((String)XmlUtils.xmlToString((Object)pedRegEvento, (Marshaller)this.PedRegEventoMarshaller_v1_01));
        String rawSignedPedReg = BuildXmlUtils.removeNamespace((String)XmlUtils.sign((byte[])stringPedRegEvento.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password));
        TCPedRegEvt signedPedReg = (TCPedRegEvt)XmlUtils.stringToXml((String)rawSignedPedReg, (Unmarshaller)this.PedRegEventoMarshaller_v1_01);
        pedRegEvento.setSignature(signedPedReg.getSignature());
        TCEvento evento = this.buildEvento(pedRegEvento, liNotasubcancelada);
        String stringEvento = XmlUtils.xmlToString((Object)evento, (Marshaller)this.EventoMarshaller_v1_01);
        String rawXml = XmlUtils.sign((byte[])stringEvento.replaceAll("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>", "").getBytes(), (byte[])pkcs12, (char[])password);
        if (log.isDebugEnabled()) {
            System.out.println(NotaFiscalEnvioService_v1_01.prettyPrintByTransformer((String)rawXml, (int)2, (boolean)true));
        }
        return rawXml;
    }

    public TCPedRegEvt buildPedRegEvento(LiNotasubcancelada liNotasubcancelada) {
        TCPedRegEvt pedRegEvento = this.factory_v1_01.createTCPedRegEvt();
        pedRegEvento.setVersao("1.01");
        TCInfPedReg infPedReg = this.factory_v1_01.createTCInfPedReg();
        infPedReg.setId(EventoEnvioService_v1_01.prepararIdPedReg((LiNotasubcancelada)liNotasubcancelada));
        infPedReg.setVerAplic(this.versaoNfse);
        infPedReg.setDhEvento(BuildXmlUtils.formatToIsoOffset((LocalDateTime)liNotasubcancelada.getDtaIncNca()));
        String string = this.ambiente;
        int n = 0;
        infPedReg.setTpAmb(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Production"}, (Object)string, n)) {
            case 0 -> "1";
            default -> "2";
        });
        String chave = (String)ObjectUtils.getIfNull((Object)liNotasubcancelada.getCancelada().getNotaNacional().getChaveNfseNfn(), (Object)liNotasubcancelada.getCancelada().getCodsegurancaNfs());
        infPedReg.setChNFSe(chave);
        infPedReg.setCNPJAutor(this.entidadeVO.getCnpj());
        if (liNotasubcancelada.getSubstituta() == null) {
            TE101101 e101101 = this.factory_v1_01.createTE101101();
            e101101.setXDesc("Cancelamento de NFS-e");
            e101101.setCMotivo("9");
            e101101.setXMotivo(liNotasubcancelada.getDetalhemotivoNca());
            infPedReg.setE101101(e101101);
        } else {
            TE105102 e105102 = this.factory_v1_01.createTE105102();
            e105102.setXDesc("Cancelamento de NFS-e por Substituicao");
            e105102.setChSubstituta(liNotasubcancelada.getSubstituta().getNotaNacional().getChaveNfseNfn());
            e105102.setCMotivo(Objects.requireNonNullElse(liNotasubcancelada.getCodMotivoNacionalNca(), MotivoNacionalCancelamento.OUTROS).codigo);
            e105102.setXMotivo(liNotasubcancelada.getDetalhemotivoNca());
            infPedReg.setE105102(e105102);
        }
        pedRegEvento.setInfPedReg(infPedReg);
        return pedRegEvento;
    }

    private static String prepararIdPedReg(LiNotasubcancelada liNotasubcancelada) {
        TSCodigoEventoNFSe evento = liNotasubcancelada.getSubstituta() == null ? TSCodigoEventoNFSe.E_101101 : TSCodigoEventoNFSe.E_105102;
        return "PRE" + liNotasubcancelada.getCancelada().getCodsegurancaNfs() + evento.name().replaceAll("\\D", "");
    }

    public TCEvento buildEvento(TCPedRegEvt pedRegEvento, LiNotasubcancelada liNotasubcancelada) {
        TCEvento evento = this.factory_v1_01.createTCEvento();
        evento.setVersao("1.01");
        TCInfEvento infEvento = this.factory_v1_01.createTCInfEvento();
        infEvento.setVerAplic(this.versaoNfse);
        infEvento.setAmbGer("1");
        infEvento.setNSeqEvento("001");
        infEvento.setDhProc(BuildXmlUtils.formatToIsoOffset((LocalDateTime)LocalDateTime.now()));
        infEvento.setNDFe(BuildXmlUtils.numToString((Number)Optional.ofNullable(liNotasubcancelada.getNdfeNfn()).orElseGet(() -> this.generateNDFe())));
        infEvento.setPedRegEvento(pedRegEvento);
        evento.setInfEvento(infEvento);
        return evento;
    }

    private synchronized Long generateNDFe() {
        return this.firebirdService.genId(FirebirdService.Generators.GEN_NUMERO_DFE).longValue();
    }

    public EventoEnvioService_v1_01(EntidadeVO entidadeVO, Jaxb2Marshaller EventoMarshaller_v1_01, Jaxb2Marshaller PedRegEventoMarshaller_v1_01, ObjectFactory factory_v1_01, FirebirdService firebirdService, LiNotasubcanceladaService liNotasubcanceladaService) {
        this.entidadeVO = entidadeVO;
        this.EventoMarshaller_v1_01 = EventoMarshaller_v1_01;
        this.PedRegEventoMarshaller_v1_01 = PedRegEventoMarshaller_v1_01;
        this.factory_v1_01 = factory_v1_01;
        this.firebirdService = firebirdService;
        this.liNotasubcanceladaService = liNotasubcanceladaService;
    }
}

